/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.el.MethodExpression;
import javax.faces.component.NamingContainer;
import javax.faces.component.StateHelper;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIPanel;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.render.Renderer;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.ComponentProcessingContext;
import org.apache.myfaces.trinidad.component.ComponentProcessor;
import org.apache.myfaces.trinidad.component.FlattenedComponent;
import org.apache.myfaces.trinidad.context.PartialPageContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.event.AttributeChangeListener;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.render.CoreRenderer;

public abstract class UIXComponent
extends UIComponent {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(UIXComponent.class);

    public static <S> boolean processFlattenedChildren(FacesContext context, ComponentProcessor<S> childProcessor, UIComponent child, S callbackContext) throws IOException {
        return UIXComponent.processFlattenedChildren(context, new ComponentProcessingContext(), childProcessor, child, callbackContext);
    }

    public static <S> boolean encodeFlattenedChild(FacesContext context, ComponentProcessor<S> childProcessor, UIComponent child, S callbackContext) throws IOException {
        ComponentProcessingContext processingContext = new ComponentProcessingContext();
        processingContext.__setIsRendering();
        return UIXComponent.processFlattenedChildren(context, processingContext, childProcessor, child, callbackContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S> boolean processFlattenedChildren(FacesContext context, ComponentProcessingContext cpContext, ComponentProcessor<S> childProcessor, UIComponent child, S callbackContext) throws IOException {
        if (child.isRendered()) {
            boolean processed;
            block9: {
                if (child instanceof FlattenedComponent && ((FlattenedComponent)child).isFlatteningChildren(context)) {
                    return ((FlattenedComponent)child).processFlattenedChildren(context, cpContext, childProcessor, callbackContext);
                }
                processed = true;
                child.pushComponentToEL(context, null);
                try {
                    if (UIXComponent.isFlattenableCoreComponent(child)) {
                        processed = UIXComponent.processFlattenedChildren(context, cpContext, childProcessor, child.getChildren(), callbackContext);
                        break block9;
                    }
                    try {
                        childProcessor.processComponent(context, cpContext, child, callbackContext);
                    }
                    finally {
                        cpContext.resetStartDepth();
                    }
                }
                finally {
                    child.popComponentFromEL(context);
                }
            }
            return processed;
        }
        return false;
    }

    public static <S> boolean processFlattenedChildren(FacesContext context, ComponentProcessor<S> childProcessor, Iterable<UIComponent> children, S callbackContext) throws IOException {
        return UIXComponent.processFlattenedChildren(context, new ComponentProcessingContext(), childProcessor, children, callbackContext);
    }

    public static <S> boolean encodeFlattenedChildren(FacesContext context, ComponentProcessor<S> childProcessor, Iterable<UIComponent> children, S callbackContext) throws IOException {
        ComponentProcessingContext processingContext = new ComponentProcessingContext();
        processingContext.__setIsRendering();
        return UIXComponent.processFlattenedChildren(context, processingContext, childProcessor, children, callbackContext);
    }

    public static <S> boolean processFlattenedChildren(FacesContext context, ComponentProcessingContext cpContext, ComponentProcessor<S> childProcessor, Iterable<UIComponent> children, S callbackContext) throws IOException {
        boolean processedChild = false;
        for (UIComponent currChild : children) {
            processedChild |= UIXComponent.processFlattenedChildren(context, cpContext, childProcessor, currChild, callbackContext);
        }
        return processedChild;
    }

    public boolean visitTree(VisitContext visitContext, VisitCallback callback) {
        return UIXComponent.visitTree(visitContext, this, callback);
    }

    protected Iterator<UIComponent> getRenderedFacetsAndChildren(FacesContext facesContext) {
        Renderer renderer = this.getRenderer(facesContext);
        if (renderer instanceof CoreRenderer) {
            return ((CoreRenderer)renderer).getRenderedFacetsAndChildren(facesContext, this);
        }
        return this.getFacetsAndChildren();
    }

    protected boolean visitChildren(VisitContext visitContext, VisitCallback callback) {
        Renderer renderer;
        if (UIXComponent._isEncodingVisit(visitContext) && (renderer = this.getRenderer(visitContext.getFacesContext())) instanceof CoreRenderer) {
            CoreRenderer coreRenderer = (CoreRenderer)renderer;
            return coreRenderer.visitChildrenForEncoding(this, visitContext, callback);
        }
        return this.visitAllChildren(visitContext, callback);
    }

    protected final boolean visitAllChildren(VisitContext visitContext, VisitCallback callback) {
        Iterator<UIComponent> kids;
        Iterator<UIComponent> iterator = kids = visitContext.getHints().contains(VisitHint.SKIP_UNRENDERED) ? this.getRenderedFacetsAndChildren(visitContext.getFacesContext()) : this.getFacetsAndChildren();
        while (kids.hasNext()) {
            if (!kids.next().visitTree(visitContext, callback)) continue;
            return true;
        }
        return false;
    }

    private static boolean _isEncodingVisit(VisitContext visitContext) {
        return visitContext.getHints().contains(VisitHint.EXECUTE_LIFECYCLE) && FacesContext.getCurrentInstance().getCurrentPhaseId() == PhaseId.RENDER_RESPONSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean visitTree(VisitContext visitContext, UIComponent component, VisitCallback callback) {
        boolean doneVisiting;
        block28: {
            if (!(component instanceof UIXComponent)) {
                return component.visitTree(visitContext, callback);
            }
            UIXComponent uixComponent = (UIXComponent)component;
            FacesContext context = visitContext.getFacesContext();
            if (!uixComponent.isVisitable(visitContext)) {
                return false;
            }
            component.pushComponentToEL(context, null);
            doneVisiting = false;
            RuntimeException re = null;
            try {
                RenderingContext rc;
                RenderingContext renderingContext = rc = UIXComponent._isEncodingVisit(visitContext) ? RenderingContext.getCurrentInstance() : null;
                if (rc == null) {
                    uixComponent.setupVisitingContext(context);
                }
                VisitResult visitResult = VisitResult.REJECT;
                try {
                    visitResult = visitContext.invokeVisitCallback(component, callback);
                    if (visitResult == VisitResult.COMPLETE) {
                        doneVisiting = true;
                        break block28;
                    }
                    if (visitResult == VisitResult.ACCEPT) {
                        boolean skipChildren;
                        boolean bl = skipChildren = uixComponent instanceof NamingContainer && visitContext.getSubtreeIdsToVisit((UIComponent)uixComponent).isEmpty();
                        if (skipChildren) break block28;
                        if (rc != null) {
                            uixComponent.setupEncodingContext(context, rc);
                        }
                        try {
                            doneVisiting = UIXComponent.visitChildren(visitContext, uixComponent, callback);
                            break block28;
                        }
                        finally {
                            if (rc != null) {
                                uixComponent.tearDownEncodingContext(context, rc);
                            }
                        }
                    }
                    assert (visitResult == VisitResult.REJECT);
                }
                catch (RuntimeException ex) {
                    re = ex;
                }
                finally {
                    try {
                        if (rc == null) {
                            uixComponent.tearDownVisitingContext(context);
                        }
                    }
                    catch (RuntimeException ex) {
                        if (re == null) {
                            throw ex;
                        }
                        _LOG.warning(ex);
                    }
                }
            }
            finally {
                component.popComponentFromEL(context);
                if (re != null) {
                    throw re;
                }
            }
        }
        return doneVisiting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean visitChildren(VisitContext visitContext, UIComponent parentComponent, VisitCallback callback) {
        boolean doneVisiting;
        block19: {
            if (!(parentComponent instanceof UIXComponent)) {
                Iterator iter = parentComponent.getFacetsAndChildren();
                while (iter.hasNext()) {
                    UIComponent child = (UIComponent)iter.next();
                    if (!child.visitTree(visitContext, callback)) continue;
                    return true;
                }
                return false;
            }
            UIXComponent uixParentComponent = (UIXComponent)parentComponent;
            FacesContext context = visitContext.getFacesContext();
            RenderingContext rc = UIXComponent._isEncodingVisit(visitContext) ? RenderingContext.getCurrentInstance() : null;
            doneVisiting = false;
            RuntimeException re = null;
            if (parentComponent instanceof UIXComponent) {
                if (rc != null) {
                    uixParentComponent.setupChildrenEncodingContext(context, rc);
                } else {
                    uixParentComponent.setupChildrenVisitingContext(context);
                }
            }
            try {
                doneVisiting = uixParentComponent.visitChildren(visitContext, callback);
            }
            catch (RuntimeException ex) {
                re = ex;
                return (boolean)re;
            }
            finally {
                try {
                    if (rc != null) {
                        uixParentComponent.tearDownChildrenEncodingContext(context, rc);
                    } else {
                        uixParentComponent.tearDownChildrenVisitingContext(context);
                    }
                }
                catch (RuntimeException ex) {
                    if (re == null) {
                        throw ex;
                    }
                    _LOG.warning(ex);
                }
                if (re == null) break block19;
                throw re;
            }
        }
        return doneVisiting;
    }

    public static void addPartialTarget(FacesContext facesContext, PartialPageContext partialContext, UIComponent component) {
        if (component == null) {
            throw new NullPointerException("UIComponent is null");
        }
        if (component instanceof UIXComponent) {
            ((UIXComponent)component).setPartialTarget(facesContext, partialContext);
        } else {
            UIXComponent._addPartialTargetImpl(facesContext, partialContext, component);
        }
    }

    public final void clearCachedClientIds() {
        UIXComponent.clearCachedClientIds(this);
    }

    public static void clearCachedClientIds(UIComponent component) {
        String id = component.getId();
        component.setId(id);
        Iterator allChildren = component.getFacetsAndChildren();
        while (allChildren.hasNext()) {
            UIXComponent.clearCachedClientIds((UIComponent)allChildren.next());
        }
    }

    protected void setPartialTarget(FacesContext facesContext, PartialPageContext partialContext) {
        UIXComponent._addPartialTargetImpl(facesContext, partialContext, this);
    }

    protected boolean isVisitable(VisitContext visitContext) {
        return UIXComponent._isVisitable(visitContext, this);
    }

    private static void _addPartialTargetImpl(FacesContext facesContext, PartialPageContext partialContext, UIComponent component) {
        if (component.getRendererType() == null) {
            if (component.getParent() != null) {
                UIXComponent.addPartialTarget(facesContext, partialContext, component.getParent());
            }
        } else {
            partialContext.addPartialTarget(component.getClientId(facesContext));
        }
    }

    private static boolean _isVisitable(VisitContext visitContext, UIComponent component) {
        Set hints = visitContext.getHints();
        if (hints.contains(VisitHint.SKIP_TRANSIENT) && component.isTransient()) {
            return false;
        }
        return !hints.contains(VisitHint.SKIP_UNRENDERED) || component.isRendered();
    }

    public VisitResult partialEncodeVisit(VisitContext visitContext, PartialPageContext partialContext, VisitCallback callback) {
        FacesContext context = visitContext.getFacesContext();
        Renderer renderer = this.getRenderer(context);
        if (renderer instanceof CoreRenderer) {
            return ((CoreRenderer)renderer).partialEncodeVisit(visitContext, partialContext, this, callback);
        }
        if (partialContext.isPossiblePartialTarget(this.getId()) && partialContext.isPartialTarget(this.getClientId(context))) {
            return callback.visit(visitContext, (UIComponent)this);
        }
        return VisitResult.ACCEPT;
    }

    protected void setupVisitingContext(FacesContext context) {
    }

    protected void setupChildrenVisitingContext(FacesContext context) {
    }

    protected void tearDownVisitingContext(FacesContext context) {
    }

    protected void tearDownChildrenVisitingContext(FacesContext context) {
    }

    @Deprecated
    protected final void setUpEncodingContext(FacesContext context, RenderingContext rc) {
        this.setupEncodingContext(context, rc);
    }

    protected void setupEncodingContext(FacesContext context, RenderingContext rc) {
        this.setupVisitingContext(context);
        Renderer renderer = this.getRenderer(context);
        if (renderer instanceof CoreRenderer) {
            CoreRenderer coreRenderer = (CoreRenderer)renderer;
            coreRenderer.setupEncodingContext(context, rc, (UIComponent)this);
        }
    }

    public void setupChildrenEncodingContext(FacesContext context, RenderingContext rc) {
        this.setupChildrenVisitingContext(context);
        Renderer renderer = this.getRenderer(context);
        if (renderer instanceof CoreRenderer) {
            CoreRenderer coreRenderer = (CoreRenderer)renderer;
            coreRenderer.setupChildrenEncodingContext(context, rc, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDownEncodingContext(FacesContext context, RenderingContext rc) {
        Renderer renderer = this.getRenderer(context);
        try {
            if (renderer instanceof CoreRenderer) {
                CoreRenderer coreRenderer = (CoreRenderer)renderer;
                coreRenderer.tearDownEncodingContext(context, rc, (UIComponent)this);
            }
        }
        finally {
            this.tearDownVisitingContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDownChildrenEncodingContext(FacesContext context, RenderingContext rc) {
        Renderer renderer = this.getRenderer(context);
        try {
            if (renderer instanceof CoreRenderer) {
                CoreRenderer coreRenderer = (CoreRenderer)renderer;
                coreRenderer.tearDownChildrenEncodingContext(context, rc, this);
            }
        }
        finally {
            this.tearDownChildrenVisitingContext(context);
        }
    }

    public abstract FacesBean getFacesBean();

    public abstract void addAttributeChangeListener(AttributeChangeListener var1);

    public abstract void removeAttributeChangeListener(AttributeChangeListener var1);

    public abstract AttributeChangeListener[] getAttributeChangeListeners();

    public abstract void setAttributeChangeListener(MethodExpression var1);

    public abstract MethodExpression getAttributeChangeListener();

    public abstract void markInitialState();

    public abstract String getContainerClientId(FacesContext var1, UIComponent var2);

    public UIComponent getLogicalParent() {
        return this.getParent();
    }

    public static UIComponent getLogicalParent(UIComponent component) {
        if (component instanceof UIXComponent) {
            return ((UIXComponent)component).getLogicalParent();
        }
        return component.getParent();
    }

    protected StateHelper getStateHelper() {
        throw new UnsupportedOperationException();
    }

    protected StateHelper getStateHelper(boolean create) {
        throw new UnsupportedOperationException();
    }

    private static boolean isFlattenableCoreComponent(UIComponent component) {
        Class<?> componentClass = component.getClass();
        if (UINamingContainer.class == componentClass) {
            return component.getFacet("javax.faces.component.COMPOSITE_FACET_NAME") == null;
        }
        return UIPanel.class == componentClass;
    }
}

