/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.menu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ContainerUtils;
import org.apache.myfaces.trinidad.util.ThreadLocalUtils;

class MenuUtils {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(MenuUtils.class);

    MenuUtils() {
    }

    static String stringReplaceFirst(String fullstring, String str1, String str2) {
        if (fullstring == null) {
            return null;
        }
        StringBuffer returnStr = MenuUtils.stringBufferReplaceFirst(new StringBuffer(fullstring), str1, str2);
        return returnStr.toString();
    }

    static StringBuffer stringBufferReplaceFirst(StringBuffer fullBuf, String str1, String str2) {
        if (fullBuf == null) {
            return null;
        }
        String fullstr = fullBuf.toString();
        if (str1 == null || str2 == null) {
            return fullBuf;
        }
        if ("".equals(fullstr) && !"".equals(str1)) {
            return fullBuf;
        }
        int startIdx = fullBuf.indexOf(str1);
        if (startIdx == -1) {
            return fullBuf;
        }
        int foundLen = str1.length();
        int endIdx = startIdx + foundLen;
        StringBuffer returnBuf = fullBuf.replace(startIdx, endIdx, str2);
        return returnBuf;
    }

    static <T> T getBoundValue(String elExpression, Class<T> desiredClass) {
        try {
            if (desiredClass == null) {
                throw new NullPointerException();
            }
            FacesContext ctx = FacesContext.getCurrentInstance();
            return (T)ctx.getApplication().evaluateExpressionGet(ctx, elExpression, desiredClass);
        }
        catch (Exception ex) {
            _LOG.severe("EL Expression " + elExpression + " is invalid or returned a bad value.\n", (Throwable)ex);
            _LOG.severe((Throwable)ex);
            return null;
        }
    }

    static boolean evalBoolean(String boolStr, boolean defaultVal) {
        if (boolStr != null && ContainerUtils.isValueReference((String)boolStr)) {
            Boolean bValue = MenuUtils.getBoundValue(boolStr, Boolean.class);
            return bValue;
        }
        if ("true".equals(boolStr) || "false".equals(boolStr)) {
            return Boolean.valueOf(boolStr);
        }
        return defaultVal;
    }

    static String evalString(String propVal) {
        if (propVal != null && ContainerUtils.isValueReference((String)propVal)) {
            String elVal = MenuUtils.getBoundValue(propVal, String.class);
            return elVal;
        }
        return propVal;
    }

    static int evalInt(String propVal) {
        if (propVal != null && ContainerUtils.isValueReference((String)propVal)) {
            Integer elVal = MenuUtils.getBoundValue(propVal, Integer.class);
            return elVal;
        }
        return Integer.parseInt(propVal);
    }

    static void loadBundle(String resBundle, ThreadLocal<String> key) {
        ResourceBundle bundle;
        _BundleMap bundleMap;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map applicationMap = facesContext.getExternalContext().getApplicationMap();
        Locale requestLocale = facesContext.getViewRoot().getLocale();
        if (requestLocale == null) {
            requestLocale = facesContext.getApplication().getDefaultLocale();
        }
        if ((bundleMap = (_BundleMap)applicationMap.get(key.get())) != null) {
            Locale bundleLocale = bundleMap.getLocale();
            if (bundleLocale == null) {
                ResourceBundle rb = bundleMap.getBundle();
                bundleLocale = rb.getLocale();
            }
            if (requestLocale == bundleLocale) {
                return;
            }
        }
        String bundleName = null;
        if (resBundle != null) {
            bundleName = ContainerUtils.isValueReference((String)resBundle) ? MenuUtils.getBoundValue(resBundle, String.class) : resBundle;
        }
        try {
            bundle = ResourceBundle.getBundle(bundleName, requestLocale);
        }
        catch (MissingResourceException e) {
            _LOG.severe("RESOURCE_BUNDLE_NOT_FOUND", (Object)bundleName);
            _LOG.severe((Throwable)e);
            return;
        }
        applicationMap.put(key.get(), new _BundleMap(bundle, requestLocale));
    }

    static void loadBundle(String resBundleName, String resBundleKey) {
        ThreadLocal bundleKey = ThreadLocalUtils.newRequestThreadLocal();
        bundleKey.set(resBundleKey);
        MenuUtils.loadBundle(resBundleName, bundleKey);
    }

    private static class _BundleMap
    implements Map<String, String> {
        private ResourceBundle _bundle;
        private Locale _locale;
        private List<String> _values;

        public _BundleMap(ResourceBundle bundle) {
            this._bundle = bundle;
            this._locale = bundle.getLocale();
        }

        public _BundleMap(ResourceBundle bundle, Locale locale) {
            this._bundle = bundle;
            this._locale = locale;
        }

        @Override
        public String get(Object key) {
            try {
                return this._bundle.getString(key.toString());
            }
            catch (Exception e) {
                return "!!!" + key + "!!!";
            }
        }

        @Override
        public boolean isEmpty() {
            return !this._bundle.getKeys().hasMoreElements();
        }

        @Override
        public boolean containsKey(Object key) {
            return this._bundle.getObject(key.toString()) != null;
        }

        @Override
        public Collection<String> values() {
            if (this._values == null) {
                this._values = new ArrayList<String>();
                Enumeration<String> enumer = this._bundle.getKeys();
                while (enumer.hasMoreElements()) {
                    String v = this._bundle.getString(enumer.nextElement());
                    this._values.add(v);
                }
            }
            return this._values;
        }

        @Override
        public int size() {
            return this.values().size();
        }

        @Override
        public boolean containsValue(Object value) {
            return this.values().contains(value);
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            HashSet<Map.Entry<String, String>> set = new HashSet<Map.Entry<String, String>>();
            Enumeration<String> enumer = this._bundle.getKeys();
            while (enumer.hasMoreElements()) {
                final String k = enumer.nextElement();
                set.add(new Map.Entry<String, String>(){

                    @Override
                    public String getKey() {
                        return k;
                    }

                    @Override
                    public String getValue() {
                        return _BundleMap.this._bundle.getString(k);
                    }

                    @Override
                    public String setValue(String value) {
                        throw new UnsupportedOperationException();
                    }
                });
            }
            return set;
        }

        @Override
        public Set<String> keySet() {
            HashSet<String> set = new HashSet<String>();
            Enumeration<String> enumer = this._bundle.getKeys();
            while (enumer.hasMoreElements()) {
                set.add(enumer.nextElement());
            }
            return set;
        }

        @Override
        public String remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String put(String key, String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        public ResourceBundle getBundle() {
            return this._bundle;
        }

        public Locale getLocale() {
            return this._locale;
        }
    }
}

