/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit;

import javax.faces.render.Renderer;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidadinternal.renderkit.RendererInstantiator;

class ClassRendererInstantiator
implements RendererInstantiator {
    private String _className;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ClassRendererInstantiator.class);

    public ClassRendererInstantiator(String className) {
        if (className == null) {
            throw new IllegalArgumentException();
        }
        this._className = className;
    }

    @Override
    public Renderer instantiate() {
        try {
            Class classInstance = ClassLoaderUtils.loadClass((String)this._className);
            return (Renderer)classInstance.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            this._showInstantiationError(cnfe);
        }
        catch (IllegalAccessException iae) {
            this._showInstantiationError(iae);
        }
        catch (InstantiationException ie) {
            this._showInstantiationError(ie);
        }
        return null;
    }

    private void _showInstantiationError(Throwable e) {
        _LOG.severe("RENDERER_INSTANTIATION_FAILED", (Object)this._className);
        _LOG.severe(e);
    }
}

