/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.CollectionComponent;
import org.apache.myfaces.trinidad.component.TableUtils;
import org.apache.myfaces.trinidad.component.UIXCollection;
import org.apache.myfaces.trinidad.component.UIXColumn;
import org.apache.myfaces.trinidad.component.UIXTable;
import org.apache.myfaces.trinidad.component.core.data.CoreColumn;
import org.apache.myfaces.trinidad.component.core.data.CoreTable;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.PartialPageContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.RangeChangeEvent;
import org.apache.myfaces.trinidad.event.RowDisclosureEvent;
import org.apache.myfaces.trinidad.event.SortEvent;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.RowKeySet;
import org.apache.myfaces.trinidad.model.SortCriterion;
import org.apache.myfaces.trinidad.render.ClientRowKeyManager;
import org.apache.myfaces.trinidad.render.CoreRenderer;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PartialPageUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SelectRangeChoiceBarRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlConstants;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.CellUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.ColumnData;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.DetailColumnRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.RenderStage;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.SelectionColumnRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.SpecialColumnRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableSelectManyRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableSelectOneRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TreeUtils;

public abstract class TableRenderer
extends XhtmlRenderer {
    private PropertyKey _widthKey;
    private PropertyKey _emptyTextKey;
    private final Map<String, String> _resourceKeyMap;
    private static final Object _UPPER_NAV_BAR_ID_PROPERTY = new Object();
    private static final String _VALUE_FIELD_NAME = "_value";
    public static final boolean DEFAULT_REPEAT_CONTROL_BAR = false;
    private final SpecialColumnRenderer _detailRenderer = new DetailColumnRenderer();
    private SpecialColumnRenderer _selectRenderer;
    private CoreRenderer _navBarRenderer;
    private CoreRenderer _selectOne;
    private CoreRenderer _selectMany;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(TableRenderer.class);

    public TableRenderer(FacesBean.Type type) {
        super(type);
        this._resourceKeyMap = this.createResourceKeyMap();
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._widthKey = type.findKey("width");
        this._emptyTextKey = type.findKey("emptyText");
        this._navBarRenderer = new NavBar(type);
        this._selectRenderer = new SelectionColumnRenderer(type);
        this._selectOne = new TableSelectOneRenderer(type);
        this._selectMany = new TableSelectManyRenderer(type);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void decode(FacesContext facesContext, UIComponent component, FacesBean facesBean, String clientId) {
        String id;
        this.decodeSelection(facesContext, component);
        Map parameters = facesContext.getExternalContext().getRequestParameterMap();
        Object source = parameters.get("javax.faces.source");
        if (source == null) {
            source = parameters.get("source");
        }
        String string = id = clientId == null ? component.getClientId(facesContext) : clientId;
        if (!id.equals(source)) {
            return;
        }
        UIXTable table = (UIXTable)component;
        Object eventParam = parameters.get("event");
        if ("goto".equals(eventParam)) {
            this._decodeGoto(table, parameters);
        } else if ("hide".equals(eventParam) || "show".equals(eventParam)) {
            this._decodeHideShow(table, parameters, eventParam);
        } else if ("sort".equals(eventParam)) {
            this._decodeSort(table, parameters);
        }
        RequestContext.getCurrentInstance().addPartialTarget((UIComponent)table);
    }

    protected final void decodeSelection(FacesContext context, UIComponent treeTable) {
        String selection = (String)treeTable.getAttributes().get(CoreTable.ROW_SELECTION_KEY.getName());
        if ("single".equals(selection)) {
            this._selectOne.decode(context, treeTable);
        } else if ("multiple".equals(selection)) {
            this._selectMany.decode(context, treeTable);
        }
    }

    public static RangeChangeEvent createRangeChangeEvent(CollectionComponent table, int newStart) {
        int newEnd = TableUtils.getLast((CollectionComponent)table, (int)newStart);
        return TableRenderer._createRangeChangeEvent(table, newStart, newEnd);
    }

    public static Set<Object> getPartialRowKeys(FacesContext context, RenderingContext rc, UIComponent component, String clientId) {
        ClientRowKeyManager rowKeyManager = null;
        if (component instanceof UIXCollection) {
            rowKeyManager = ((UIXCollection)component).getClientRowKeyManager();
        }
        Set<Object> rowKeys = null;
        String tablePrefix = clientId + ':';
        PartialPageContext ppc = rc.getPartialPageContext();
        Iterator targets = ppc.getPartialTargets();
        while (targets.hasNext()) {
            String target = (String)targets.next();
            if (target == null || !target.startsWith(tablePrefix)) continue;
            if (rowKeyManager == null) {
                return null;
            }
            String clientRowKey = target.substring(tablePrefix.length());
            int ncIndex = clientRowKey.indexOf(58);
            if (ncIndex < 0) {
                return null;
            }
            Object rowKey = rowKeyManager.getRowKey(context, component, clientRowKey = clientRowKey.substring(0, ncIndex));
            if (rowKey == null) {
                return null;
            }
            if (rowKeys == null) {
                rowKeys = new HashSet<Object>();
            }
            rowKeys.add(rowKey);
        }
        if (rowKeys == null) {
            rowKeys = Collections.emptySet();
        }
        return rowKeys;
    }

    private static RangeChangeEvent _createRangeChangeEvent(CollectionComponent table, int newStart, int newEnd) {
        int oldStart = table.getFirst();
        int oldEnd = TableUtils.getLast((CollectionComponent)table) + 1;
        return new RangeChangeEvent((UIComponent)table, oldStart, oldEnd, newStart, newEnd);
    }

    private void _decodeSort(UIXTable table, Map<String, String> parameters) {
        String property = parameters.get("value");
        String state = parameters.get("state");
        boolean sortOrder = !"ascending".equals(state);
        SortCriterion criterion = new SortCriterion(property, sortOrder);
        SortEvent event = new SortEvent((UIComponent)table, Collections.singletonList(criterion));
        event.queue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _decodeGoto(UIXTable table, Map<String, String> parameters) {
        RangeChangeEvent event;
        String value = parameters.get("value");
        if (value == null) return;
        if ("all".equals(value)) {
            int newEnd = table.getRowCount();
            if (newEnd < 0) return;
            event = TableRenderer._createRangeChangeEvent((CollectionComponent)table, 0, newEnd);
        } else {
            int newStart = Integer.parseInt(value) - 1;
            event = TableRenderer.createRangeChangeEvent((CollectionComponent)table, newStart);
        }
        event.queue();
    }

    private void _decodeHideShow(UIXTable table, Map<String, String> parameters, Object eventParam) {
        boolean doExpand = "show".equals(eventParam);
        String value = parameters.get("value");
        if (value != null) {
            RowKeySet old = table.getDisclosedRowKeys();
            RowKeySet newset = old.clone();
            if ("all".equals(value)) {
                if (doExpand) {
                    newset.addAll();
                } else {
                    newset.removeAll();
                }
                RowDisclosureEvent event = new RowDisclosureEvent(old, newset, (UIComponent)table);
                event.queue();
            } else {
                int rowIndex = Integer.parseInt(value);
                int oldIndex = table.getRowIndex();
                table.setRowIndex(rowIndex);
                newset.setContained(doExpand);
                RowDisclosureEvent event = new RowDisclosureEvent(old, newset, (UIComponent)table);
                event.queue();
                table.setRowIndex(oldIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        Set<Object> keysToRender = null;
        if (this.canSkipRendering(context, rc, component) && (keysToRender = TableRenderer.getPartialRowKeys(context, rc, component, this.getClientId(context, component))) != null && keysToRender.isEmpty()) {
            return;
        }
        Map oldSkinResourceMap = rc.getSkinResourceKeyMap();
        rc.setSkinResourceKeyMap(this._resourceKeyMap);
        TableRenderingContext tContext = this.createRenderingContext(context, rc, component);
        try {
            tContext.install();
            ResponseWriter rw = context.getResponseWriter();
            rw.startElement("div", component);
            this.renderId(context, component);
            this.renderAllAttributes(context, rc, component, bean);
            if (this.renderTableWithoutColumns(context, rc, tContext, component)) {
                return;
            }
            rw.startElement("table", null);
            this.renderTableAttributes(context, rc, component, bean, "0", "0");
            RenderStage renderStage = tContext.getRenderStage();
            assert (renderStage.getStage() == 0);
            this.renderSingleRow(context, rc, tContext, component);
            this.renderNavigationHeaderBars(context, rc, tContext, component, bean);
            this.renderTableContent(context, rc, tContext, component);
            if (this._shouldRepeatControlBar(rc)) {
                this.renderNavigationFooterBars(context, rc, tContext, component, bean);
            }
            rw.endElement("table");
            renderStage.setStage(100);
            this.renderSingleRow(context, rc, tContext, component);
            String tid = tContext.getTableId();
            FormData formData = rc.getFormData();
            if (formData != null) {
                formData.addNeededValue("state");
                formData.addNeededValue("value");
                if (TableRenderer.supportsScripting(rc)) {
                    rw.startElement("script", null);
                    TableRenderer.renderScriptDeferAttribute(context, rc);
                    TableRenderer.renderScriptTypeAttribute(context, rc);
                    String formName = formData.getName();
                    rw.writeText((Object)(tContext.getJSVarName() + "=" + TreeUtils.createNewJSCollectionComponentState(formName, tid) + ";"), null);
                    rw.endElement("script");
                }
            }
            int first = tContext.getCollectionComponent().getFirst();
            if (TableRenderer.supportsScripting(rc)) {
                XhtmlUtils.addLib(context, rc, "TableProxy()");
                int value = first + 1;
                if (value != 1) {
                    rw.startElement("script", null);
                    TableRenderer.renderScriptDeferAttribute(context, rc);
                    TableRenderer.renderScriptTypeAttribute(context, rc);
                    rw.writeText((Object)"window[\"_", null);
                    rw.writeText((Object)tContext.getTableId(), null);
                    rw.writeText((Object)_VALUE_FIELD_NAME, null);
                    rw.writeText((Object)"\"]=", null);
                    rw.writeText((Object)IntegerUtils.getString((int)value), null);
                    rw.endElement("script");
                }
            }
            OutputUtils.renderHiddenField(context, tContext.getTableId() + ":rangeStart", IntegerUtils.getString((int)first));
            rw.endElement("div");
        }
        finally {
            rc.setSkinResourceKeyMap(oldSkinResourceMap);
            if (tContext != null) {
                tContext.release();
            }
        }
    }

    @Override
    protected String getDefaultStyleClass(UIComponent component, FacesBean bean) {
        return "af|table";
    }

    protected void renderTableAttributes(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, Object cellPadding, Object border) throws IOException {
        Object width = this.getWidth(component, bean);
        OutputUtils.renderLayoutTableAttributes(context, rc, cellPadding, "0", border, width);
    }

    protected TableRenderingContext createRenderingContext(FacesContext context, RenderingContext rc, UIComponent component) {
        return new TableRenderingContext(context, rc, component);
    }

    protected abstract void renderSingleRow(FacesContext var1, RenderingContext var2, TableRenderingContext var3, UIComponent var4) throws IOException;

    protected boolean renderTableWithoutColumns(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent component) throws IOException {
        ColumnData colData = tContext.getColumnData();
        if (colData.getColumnCount() <= 0) {
            if (_LOG.isWarning()) {
                _LOG.warning("TABLE_HAS_NO_VISIABLE_COLUMN", (Object)tContext.getTableId());
            }
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("table", component);
            writer.startElement("tr", null);
            writer.startElement("td", null);
            writer.writeAttribute("width", (Object)"30", null);
            TableRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)rc, (String[])new String[]{"af|column::cell-text", CellUtils.getBorderClass(true, true, true, true)});
            this.renderSpacer(context, rc, "30", "30");
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("table");
            return true;
        }
        return false;
    }

    protected int renderSpecialColumns(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent treeTable, int physicalColumnIndex) throws IOException {
        UIComponent detail;
        ColumnData colData = tContext.getColumnData();
        int[] hidden = tContext.getHiddenColumns();
        List children = treeTable.getChildren();
        int colCount = children.size();
        for (int i = 0; i < colCount; ++i) {
            UIComponent child;
            if (hidden[i] != 0 || !((child = (UIComponent)children.get(i)) instanceof UIXColumn)) continue;
            UIXColumn column = (UIXColumn)child;
            boolean isRowHeader = Boolean.TRUE.equals(column.getAttributes().get(CoreColumn.ROW_HEADER_KEY.getName()));
            if (!isRowHeader) break;
            colData.setColumnIndex(physicalColumnIndex, i);
            this.encodeChild(context, (UIComponent)column);
            physicalColumnIndex = colData.getPhysicalColumnIndex();
        }
        if (tContext.hasSelection()) {
            colData.setColumnIndex(physicalColumnIndex, -1);
            this._renderSelectionColumn(context, rc, tContext);
            ++physicalColumnIndex;
        }
        if ((detail = tContext.getDetail()) != null) {
            colData.setColumnIndex(physicalColumnIndex, -1);
            this._renderDetailColumn(context, rc);
            ++physicalColumnIndex;
        }
        return physicalColumnIndex;
    }

    private void _renderDetailColumn(FacesContext context, RenderingContext rc) throws IOException {
        UIComponent column = this._detailRenderer.getSpecialColumn();
        this.delegateRenderer(context, rc, column, this.getFacesBean(column), this._detailRenderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _renderSelectionColumn(FacesContext context, RenderingContext rc, TableRenderingContext tContext) throws IOException {
        Map originalResourceKeyMap = rc.getSkinResourceKeyMap();
        TableRenderer.setSelectionResourceKeyMap(rc, tContext);
        try {
            UIComponent column = this._selectRenderer.getSpecialColumn();
            this.delegateRenderer(context, rc, column, this.getFacesBean(column), this._selectRenderer);
        }
        finally {
            rc.setSkinResourceKeyMap(originalResourceKeyMap);
        }
    }

    protected void renderNavigationHeaderBars(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent component, FacesBean bean) throws IOException {
        this._renderControlBar(context, rc, tContext, component, true);
        this.renderSubControlBar(context, rc, tContext, component, true);
    }

    protected void renderNavigationFooterBars(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent component, FacesBean bean) throws IOException {
        this._renderControlBar(context, rc, tContext, component, false);
    }

    private boolean _shouldRepeatControlBar(RenderingContext rc) {
        Object propValue = rc.getSkin().getProperty((Object)"af|table-tr-repeat-control-bar");
        if (propValue == null) {
            return false;
        }
        return Boolean.TRUE.equals(propValue);
    }

    private void _renderControlBar(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent component, boolean isUpper) throws IOException {
        rc.getProperties().put(XhtmlConstants.REPEAT_PROPERTY, Boolean.TRUE);
        RenderStage rs = tContext.getRenderStage();
        rs.setStage(isUpper ? 10 : 15);
        if (isUpper) {
            String id = tContext.getTableId();
            Agent agent = rc.getAgent();
            if (agent.getAgentName() == "ie" && PartialPageUtils.isPPRActive(context)) {
                String navBarID = id.toString() + "-nb";
                TableRenderer.setRenderingProperty((RenderingContext)rc, (Object)_UPPER_NAV_BAR_ID_PROPERTY, (Object)navBarID);
            }
        }
        this.renderControlBar(context, rc, tContext, component);
        rc.getProperties().remove(XhtmlConstants.REPEAT_PROPERTY);
        if (isUpper) {
            TableRenderer.setRenderingProperty((RenderingContext)rc, (Object)_UPPER_NAV_BAR_ID_PROPERTY, null);
        }
    }

    protected abstract void renderControlBar(FacesContext var1, RenderingContext var2, TableRenderingContext var3, UIComponent var4) throws IOException;

    protected abstract void renderSubControlBar(FacesContext var1, RenderingContext var2, TableRenderingContext var3, UIComponent var4, boolean var5) throws IOException;

    protected abstract void renderTableContent(FacesContext var1, RenderingContext var2, TableRenderingContext var3, UIComponent var4) throws IOException;

    protected String getEmptyText(UIComponent component, FacesBean bean) {
        return TableRenderer.toString((Object)bean.getProperty(this._emptyTextKey));
    }

    protected Object getWidth(UIComponent component, FacesBean bean) {
        return bean.getProperty(this._widthKey);
    }

    protected final CoreRenderer getSharedHideShowNode() {
        return null;
    }

    protected CoreRenderer getSharedNavBarRenderer() {
        return this._navBarRenderer;
    }

    public static String getRowHeaderFormatClass() {
        return "af|column::row-header-text";
    }

    public static String getHeaderFormatClass(TableRenderingContext tContext, boolean isColumnHeader) {
        if (isColumnHeader) {
            throw new IllegalStateException(_LOG.getMessage("DONOT_CALL_THIS_FOR_COLUMN_HEADERS"));
        }
        return "af|column::row-header-text";
    }

    public static void setSelectionResourceKeyMap(RenderingContext rc, TableRenderingContext tContext) {
        if (tContext.hasSelection()) {
            HashMap<String, String> selectionColumnStylesMap = new HashMap<String, String>();
            if (tContext.hasSelectAll()) {
                selectionColumnStylesMap.put("af|column::cell-icon-format", "af|tableSelectMany::cell-icon-format");
                selectionColumnStylesMap.put("af|column::cell-icon-format-band", "af|tableSelectMany::cell-icon-format-band");
            } else {
                selectionColumnStylesMap.put("af|column::cell-icon-format", "af|tableSelectOne::cell-icon-format");
                selectionColumnStylesMap.put("af|column::cell-icon-format-band", "af|tableSelectOne::cell-icon-format-band");
            }
            rc.setSkinResourceKeyMap(selectionColumnStylesMap);
        }
    }

    @Override
    protected boolean shouldRenderId(FacesContext context, UIComponent component) {
        return true;
    }

    protected Map<String, String> createResourceKeyMap() {
        HashMap<String, String> map = new HashMap<String, String>(6);
        map.put("af_showDetail.DISCLOSED", "af_table.DISCLOSED");
        map.put("af_showDetail.UNDISCLOSED", "af_table.UNDISCLOSED");
        map.put("af_showDetail.DISCLOSED_TIP", "af_table.DISCLOSED_TIP");
        map.put("af_showDetail.UNDISCLOSED_TIP", "af_table.UNDISCLOSED_TIP");
        map.put("af|showDetail::disclosed-icon", "af|table::disclosed-icon");
        map.put("af|showDetail::undisclosed-icon", "af|table::undisclosed-icon");
        map.put("af|selectRangeChoiceBar::prev-icon", "af|table::prev-icon");
        map.put("af|selectRangeChoiceBar::next-icon", "af|table::next-icon");
        map.put("af|selectRangeChoiceBar::prev-disabled-icon", "af|table::prev-disabled-icon");
        map.put("af|selectRangeChoiceBar::next-disabled-icon", "af|table::next-disabled-icon");
        return Collections.unmodifiableMap(map);
    }

    private static class NavBar
    extends SelectRangeChoiceBarRenderer {
        public NavBar(FacesBean.Type type) {
            super(type);
        }

        @Override
        protected void renderAllAttributes(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) {
        }

        @Override
        protected boolean getShowAll(UIComponent component, FacesBean bean) {
            TableRenderingContext tContext = TableRenderingContext.getCurrentInstance();
            UIComponent c = tContext.getTable();
            if (c instanceof UIXTable) {
                UIXTable table = (UIXTable)c;
                return table.isShowAll();
            }
            return false;
        }

        @Override
        protected boolean showAllSupported() {
            TableRenderingContext tContext = TableRenderingContext.getCurrentInstance();
            UIComponent component = tContext.getTable();
            return component instanceof UIXTable;
        }

        @Override
        protected String getSource() {
            TableRenderingContext tContext = TableRenderingContext.getCurrentInstance();
            return tContext.getTableId();
        }

        protected String getClientId(FacesContext context, UIComponent component) {
            TableRenderingContext tContext = TableRenderingContext.getCurrentInstance();
            return tContext.getTableId() + "-nb";
        }

        @Override
        protected String getVar(UIComponent component, FacesBean bean) {
            return null;
        }

        @Override
        protected UIComponent getRangeLabel(UIComponent component) {
            return null;
        }

        @Override
        protected int getRowCount(UIComponent component) {
            return ((CollectionComponent)component).getRowCount();
        }

        @Override
        protected int getRowIndex(UIComponent component) {
            return ((CollectionComponent)component).getRowIndex();
        }

        @Override
        protected void setRowIndex(UIComponent component, int index) {
            ((CollectionComponent)component).setRowIndex(index);
        }

        @Override
        protected boolean isRowAvailable(UIComponent component) {
            return ((CollectionComponent)component).isRowAvailable();
        }

        @Override
        protected boolean isRowAvailable(UIComponent component, int rowIndex) {
            return ((UIXCollection)component).isRowAvailable(rowIndex);
        }

        @Override
        protected Object getRowData(UIComponent component) {
            return ((CollectionComponent)component).getRowData();
        }

        @Override
        protected int getRows(UIComponent component, FacesBean bean) {
            return ((CollectionComponent)component).getRows();
        }

        @Override
        protected int getFirst(UIComponent component, FacesBean bean) {
            return ((CollectionComponent)component).getFirst();
        }
    }
}

