/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style.util;

import java.beans.Beans;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.style.StyleContext;
import org.apache.myfaces.trinidadinternal.style.util.CSSUtils;
import org.apache.myfaces.trinidadinternal.style.util.StyleUtils;
import org.apache.myfaces.trinidadinternal.style.util.StyleWriterFactory;
import org.apache.myfaces.trinidadinternal.style.xml.parse.PropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleNode;

public class CSSGenerationUtils {
    private static final Set<String> _BUILT_IN_PSEUDO_CLASSES = new HashSet<String>();
    private static final Pattern _DASH_PATTERN;
    private static final String[] _EMPTY_STRING_ARRAY;
    private static final int _MSIE_SELECTOR_LIMIT = 4095;
    private static final TrinidadLogger _LOG;

    public static void writeCSS(StyleContext context, String styleSheetName, StyleNode[] styles, StyleWriterFactory writerFactory, boolean compressStyles, Map<String, String> shortStyleClassMap, String[] namespacePrefixArray, Map<String, String> afSelectorMap) {
        PrintWriter out = writerFactory.createWriter();
        if (out == null) {
            return;
        }
        HashMap<String, StyleNode[]> matchingStylesMap = new HashMap<String, StyleNode[]>(101);
        String[] propertyStrings = new String[styles.length];
        for (int i = 0; i < styles.length; ++i) {
            StyleNode style = styles[i];
            if (style.getSelector() == null) continue;
            String propertyString = CSSGenerationUtils._getSortedPropertyString(style);
            StyleNode[] matchingStyles = (StyleNode[])matchingStylesMap.get(propertyString);
            if (matchingStyles == null) {
                propertyStrings[i] = propertyString;
                matchingStyles = new StyleNode[]{style};
            } else {
                int length = matchingStyles.length;
                StyleNode[] newMatchingStyles = new StyleNode[length + 1];
                System.arraycopy(matchingStyles, 0, newMatchingStyles, 0, length);
                newMatchingStyles[length] = style;
                matchingStyles = newMatchingStyles;
            }
            matchingStylesMap.put(propertyString, matchingStyles);
        }
        Date date = new Date();
        if (!compressStyles) {
            out.println("/* This CSS file generated on " + date + " */");
        }
        int numberSelectorsWritten = 0;
        String baseURI = CSSUtils.getBaseSkinStyleSheetURI(styleSheetName);
        for (int i = 0; i < styles.length; ++i) {
            int j;
            StyleNode style = styles[i];
            String propertyString = propertyStrings[i];
            if (propertyString == null || propertyString.equals("")) continue;
            StyleNode[] matchingStyles = (StyleNode[])matchingStylesMap.get(propertyString);
            assert (matchingStyles != null);
            int stylesToBeWritten = 0;
            String[] selectors = new String[matchingStyles.length];
            String[] mappedSelectors = new String[matchingStyles.length];
            for (j = 0; j < matchingStyles.length; ++j) {
                selectors[j] = matchingStyles[j].getSelector();
                assert (selectors[j] != null);
                mappedSelectors[j] = CSSGenerationUtils.getMappedSelector(afSelectorMap, namespacePrefixArray, selectors[j]);
                if (compressStyles && mappedSelectors[j].indexOf(124) == -1) {
                    stylesToBeWritten += 2;
                    continue;
                }
                ++stylesToBeWritten;
            }
            if (numberSelectorsWritten + matchingStyles.length >= 4095 && TrinidadAgent.Application.IEXPLORER == context.getAgent().getAgentApplication()) {
                out.println("/* The number of CSS selectors in this file is " + numberSelectorsWritten + " */");
                out = writerFactory.createWriter();
                if (out == null) {
                    return;
                }
                numberSelectorsWritten = 0;
            }
            for (j = 0; j < matchingStyles.length; ++j) {
                String shortSelector;
                String validFullNameSelector = null;
                if (!(compressStyles && mappedSelectors[j].indexOf(124) != -1 || (validFullNameSelector = CSSGenerationUtils.getValidFullNameSelector(mappedSelectors[j], namespacePrefixArray)) == null)) {
                    out.print(validFullNameSelector);
                    ++numberSelectorsWritten;
                }
                if (compressStyles && (shortSelector = CSSGenerationUtils.getShortSelector(shortStyleClassMap, namespacePrefixArray, mappedSelectors[j])) != null) {
                    String validShortSelector = CSSGenerationUtils.getValidFullNameSelector(shortSelector, namespacePrefixArray);
                    if (validFullNameSelector != null) {
                        if (!validFullNameSelector.equals(validShortSelector)) {
                            out.print(',');
                            out.print(validShortSelector);
                            ++numberSelectorsWritten;
                        }
                    } else {
                        out.print(validShortSelector);
                        ++numberSelectorsWritten;
                    }
                }
                if (j >= matchingStyles.length - 1) continue;
                out.print(",");
            }
            out.print(" {");
            Collection<PropertyNode> properties = style.getProperties();
            boolean first = true;
            for (PropertyNode property : properties) {
                String propName = property.getName();
                String propValue = property.getValue();
                if (propName == null || propValue == null || propValue.length() <= 0) continue;
                if (!first) {
                    out.print(";");
                } else {
                    first = false;
                }
                out.print(propName);
                out.print(":");
                String resolvedPropValue = CSSUtils.resolvePropertyValue(styleSheetName, baseURI, propName, propValue);
                out.print(resolvedPropValue);
            }
            if (compressStyles) {
                out.print("}");
                continue;
            }
            out.println("}");
        }
        out.println("/* The number of CSS selectors in this file is " + numberSelectorsWritten + " */");
    }

    public static String getShortSelector(Map<String, String> shortStyleClassMap, String[] namespacePrefixArray, String selector) {
        String shortSelector = CSSGenerationUtils._getShortNonNamespacedSelector(selector, shortStyleClassMap);
        if (shortSelector == null) {
            shortSelector = selector;
        }
        if (CSSGenerationUtils._hasNamespacePrefix(shortSelector, namespacePrefixArray)) {
            String[] shortSelectorArray = CSSGenerationUtils._splitStringByWhitespace(shortSelector);
            shortSelector = CSSGenerationUtils._getMappedNSSelector(shortStyleClassMap, namespacePrefixArray, shortSelector, shortSelectorArray, true);
        }
        return shortSelector;
    }

    public static boolean isSingleStyleClassSelector(String selector) {
        if (selector == null || selector.length() < 2 || selector.charAt(0) != '.') {
            return false;
        }
        for (int i = 1; i < selector.length(); ++i) {
            if (!CSSGenerationUtils._isStyleClassTerminator(selector.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Iterator<String> getStyleClasses(String selector) {
        ArrayList<String> styleClasses = null;
        int styleClassStartIndex = -1;
        int length = selector.length();
        for (int i = 0; i < length; ++i) {
            char c = selector.charAt(i);
            if (styleClassStartIndex == -1) {
                if (c != '.') continue;
                styleClassStartIndex = i;
                continue;
            }
            boolean end = CSSGenerationUtils._isStyleClassTerminator(c);
            if (!end && i == length - 1) {
                ++i;
                end = true;
            }
            if (!end) continue;
            String styleClass = selector.substring(styleClassStartIndex + 1, i);
            if (styleClasses == null) {
                styleClasses = new ArrayList<String>(3);
            }
            styleClasses.add(styleClass);
            styleClassStartIndex = c == '.' ? i : -1;
        }
        if (styleClasses == null) {
            return null;
        }
        return styleClasses.iterator();
    }

    public static Iterator<String> getNamespacedSelectors(String selector, String namespace, Map<String, String> afSelectorMap) {
        if (selector == null) {
            return null;
        }
        int afIndex = selector.indexOf(namespace);
        if (afIndex == -1) {
            return null;
        }
        ArrayList<String> afUnmappedSelectorList = new ArrayList<String>();
        String base = selector.substring(afIndex);
        String[] afSelectors = CSSGenerationUtils._orderPseudoElementsAndClasses(base);
        for (int i = 0; i < afSelectors.length; ++i) {
            if (!afSelectors[i].startsWith(namespace)) continue;
            String afComponentSelector = CSSGenerationUtils._getNSComponentSelector(afSelectors[i], false);
            afUnmappedSelectorList.add(afComponentSelector);
        }
        ArrayList<String> afSelectorList = new ArrayList<String>();
        int size = afUnmappedSelectorList.size();
        for (int i = 0; i < size; ++i) {
            String afComponentSelector = (String)afUnmappedSelectorList.get(i);
            String mappedSelector = null;
            if (afSelectorMap != null) {
                mappedSelector = afSelectorMap.get(afComponentSelector);
            }
            if (mappedSelector != null) {
                int namespaceIndex = mappedSelector.indexOf(namespace);
                if (namespaceIndex <= -1) continue;
                String[] baseSelector = CSSGenerationUtils._splitStringByWhitespace(mappedSelector.substring(namespaceIndex));
                afComponentSelector = baseSelector[0];
                afSelectorList.add(afComponentSelector);
                continue;
            }
            afSelectorList.add(afComponentSelector);
        }
        return afSelectorList.iterator();
    }

    public static void getNamespacePrefixes(Set<String> namespacePrefixes, String selector) {
        int length = selector.length();
        int startSubstringIndex = 0;
        for (int i = 0; i < length; ++i) {
            char c = selector.charAt(i);
            if (c == '|') {
                String prefix = selector.substring(startSubstringIndex, i + 1);
                startSubstringIndex = i + 1;
                if (prefix.length() <= 1) continue;
                namespacePrefixes.add(prefix);
                continue;
            }
            if (!CSSGenerationUtils._isStyleClassTerminator(c)) continue;
            startSubstringIndex = i + 1;
        }
    }

    private static String _getNSComponentSelector(String singleAfSelector, boolean allowPseudoClass) {
        int endIndex;
        int colonIndex = singleAfSelector.indexOf("::");
        colonIndex = colonIndex != -1 ? (colonIndex += 2) : 0;
        String afterDoubleColon = singleAfSelector.substring(colonIndex);
        boolean end = false;
        int afterLength = afterDoubleColon.length();
        for (endIndex = 0; endIndex < afterLength && !end; ++endIndex) {
            char c = afterDoubleColon.charAt(endIndex);
            end = allowPseudoClass ? Character.isWhitespace(c) : CSSGenerationUtils._isStyleClassTerminator(c);
        }
        String afComponentSelector = null;
        afComponentSelector = end ? singleAfSelector.substring(0, colonIndex + endIndex - 1) : singleAfSelector;
        return afComponentSelector;
    }

    private static String _getShortNonNamespacedSelector(String selector, Map<String, String> shortStyleClassMap) {
        if (shortStyleClassMap == null) {
            return null;
        }
        if (CSSGenerationUtils.isSingleStyleClassSelector(selector)) {
            String shortStyleClass = shortStyleClassMap.get(selector.substring(1));
            return shortStyleClass == null ? null : "." + shortStyleClass;
        }
        boolean isShorter = false;
        int length = selector.length();
        StringBuffer buffer = new StringBuffer(length);
        int styleClassStartIndex = -1;
        for (int i = 0; i < length; ++i) {
            char c = selector.charAt(i);
            if (styleClassStartIndex == -1) {
                if (c == '.') {
                    styleClassStartIndex = i;
                }
                buffer.append(c);
                continue;
            }
            boolean end = CSSGenerationUtils._isStyleClassTerminator(c);
            if (!end && i == length - 1) {
                ++i;
                end = true;
            }
            if (!end) continue;
            String styleClass = selector.substring(styleClassStartIndex + 1, i);
            String shortStyleClass = null;
            if (styleClass.indexOf(124) == -1) {
                shortStyleClass = shortStyleClassMap.get(styleClass);
            }
            if (shortStyleClass == null) {
                buffer.append(styleClass);
            } else {
                buffer.append(shortStyleClass);
                isShorter = true;
            }
            if (i < length - 1) {
                buffer.append(c);
            }
            styleClassStartIndex = c == '.' ? i : -1;
        }
        return isShorter ? buffer.toString() : selector;
    }

    public static String getMappedSelector(Map<String, String> afSelectorMap, String[] namespacePrefixArray, String selector) {
        String mappedSelector;
        if (CSSGenerationUtils._hasNamespacePrefix(selector, namespacePrefixArray)) {
            String[] selectorArray = CSSGenerationUtils._orderPseudoElementsAndClasses(selector);
            mappedSelector = CSSGenerationUtils._getMappedNSSelector(afSelectorMap, namespacePrefixArray, selector, selectorArray, false);
        } else {
            int start = 0;
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < selector.length(); ++i) {
                char c = selector.charAt(i);
                if (c != ' ') continue;
                if (start == i) {
                    start = i + 1;
                    continue;
                }
                String subSelector = selector.substring(start, i);
                subSelector = CSSGenerationUtils._convertPseudoClassesInSelector(subSelector);
                start = i + 1;
                b.append(subSelector);
                b.append(' ');
            }
            if (start == 0) {
                mappedSelector = CSSGenerationUtils._convertPseudoClassesInSelector(selector);
            } else {
                String subSelector = selector.substring(start);
                subSelector = CSSGenerationUtils._convertPseudoClassesInSelector(subSelector);
                b.append(subSelector);
                mappedSelector = b.toString();
            }
        }
        return mappedSelector;
    }

    private static String _getMappedNSSelector(Map<String, String> map, String[] nsPrefixArray, String selector, String[] selectorArray, boolean shorten) {
        for (int i = 0; i < selectorArray.length; ++i) {
            int nsIndex = -1;
            int numNsPrefixes = nsPrefixArray.length;
            for (int j = 0; j < numNsPrefixes && nsIndex == -1; ++j) {
                nsIndex = selectorArray[i].indexOf(nsPrefixArray[j]);
            }
            if (nsIndex <= -1) continue;
            selectorArray[i] = CSSGenerationUtils._getEachMappedSelector(map, nsIndex, selectorArray[i], shorten);
        }
        return CSSGenerationUtils._arrayToStringWithSpaces(selectorArray);
    }

    private static String _getEachMappedSelector(Map<String, String> map, int indexOfNSPrefix, String selector, boolean shorten) {
        int endIndex;
        if (indexOfNSPrefix == -1) {
            return selector;
        }
        if (map == null) {
            return selector;
        }
        String wholeAfSelector = selector.substring(indexOfNSPrefix);
        int colonIndex = wholeAfSelector.indexOf("::");
        if (colonIndex != -1) {
            if (_LOG.isWarning() && wholeAfSelector.lastIndexOf("::") != colonIndex) {
                _LOG.warning("UNSUPPORTED_CONSECUTIVE_SUB_ELEMENT_SYNTAX", (Object)selector);
            }
            colonIndex += 2;
        } else {
            colonIndex = 0;
        }
        String afterDoubleColon = wholeAfSelector.substring(colonIndex);
        boolean end = false;
        int afterLength = afterDoubleColon.length();
        for (endIndex = 0; endIndex < afterLength && !end; ++endIndex) {
            char c = afterDoubleColon.charAt(endIndex);
            end = Character.isWhitespace(c) || c == '.' || c == ':' || c == '[';
        }
        String mainSelector = endIndex == afterLength ? wholeAfSelector.substring(0, colonIndex + endIndex) : wholeAfSelector.substring(0, colonIndex + endIndex - 1);
        String afterMain = null;
        if (endIndex != afterLength) {
            afterMain = wholeAfSelector.substring(colonIndex + endIndex - 1);
            if (!shorten) {
                afterMain = CSSGenerationUtils._convertPseudoClassesInSelector(afterMain);
            }
        }
        StringBuffer buffer = new StringBuffer();
        if (indexOfNSPrefix > 0) {
            buffer.append(selector.substring(0, indexOfNSPrefix));
            if (shorten && selector.charAt(indexOfNSPrefix - 1) != '.') {
                buffer.append('.');
            }
        } else if (shorten) {
            buffer.append('.');
        }
        buffer.append(CSSGenerationUtils._runThroughMap(map, mainSelector));
        if (afterMain != null) {
            buffer.append(afterMain);
        }
        return buffer.toString();
    }

    private static boolean _hasNamespacePrefix(String selector, String[] nsPrefixArray) {
        if (selector == null) {
            return false;
        }
        boolean hasNamespacePrefix = false;
        int numNamespaces = nsPrefixArray.length;
        for (int i = 0; i < numNamespaces && !hasNamespacePrefix; ++i) {
            if (selector.indexOf(nsPrefixArray[i]) <= -1) continue;
            hasNamespacePrefix = true;
        }
        return hasNamespacePrefix;
    }

    private static String _arrayToStringWithSpaces(String[] stringArray) {
        int length = stringArray.length;
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        int bufferSize = 0;
        for (int i = 0; i < length; ++i) {
            bufferSize += stringArray[i].length() + 1;
        }
        StringBuffer returnString = new StringBuffer(bufferSize);
        for (int i = 0; i < length; ++i) {
            returnString.append(stringArray[i]);
            if (i + 1 >= length) continue;
            returnString.append(' ');
        }
        return returnString.toString();
    }

    private static String[] _orderPseudoElementsAndClasses(String selector) {
        String[] input = CSSGenerationUtils._splitStringByWhitespace(selector);
        ArrayList<String> output = new ArrayList<String>();
        for (int i = 0; i < input.length; ++i) {
            int indexOfClass;
            boolean styleClassBeforePseudoElement;
            int indexOfDoubleColon = input[i].indexOf("::");
            if (indexOfDoubleColon == -1) {
                output.add(input[i]);
                continue;
            }
            int indexOfFirstColon = input[i].indexOf(58);
            int indexOfDot = input[i].indexOf(46);
            boolean pseudoClassBeforePseudoElement = indexOfFirstColon < indexOfDoubleColon;
            boolean bl = styleClassBeforePseudoElement = indexOfDot != -1 && indexOfDot < indexOfDoubleColon;
            if (!pseudoClassBeforePseudoElement && !styleClassBeforePseudoElement) {
                output.add(input[i]);
                continue;
            }
            if (indexOfFirstColon == indexOfDoubleColon) {
                indexOfFirstColon = -1;
            }
            if ((indexOfClass = Math.min(indexOfFirstColon, indexOfDot)) == -1) {
                indexOfClass = Math.max(indexOfFirstColon, indexOfDot);
            }
            String main = input[i].substring(0, indexOfClass);
            String mainPlusClasses = input[i].substring(0, indexOfDoubleColon);
            String end = input[i].substring(indexOfDoubleColon);
            output.add(mainPlusClasses);
            output.add(main + end);
        }
        return output.toArray(new String[output.size()]);
    }

    public static String getValidFullNameSelector(String selector, String[] namespacePrefixArray) {
        if (selector.indexOf(124) == -1) {
            return selector;
        }
        String[] spacerArray = CSSGenerationUtils._splitStringByWhitespace(selector);
        block0: for (int i = 0; i < spacerArray.length; ++i) {
            if (spacerArray[i].indexOf(124) <= -1) continue;
            for (int j = 0; j < namespacePrefixArray.length; ++j) {
                String nsPrefix = namespacePrefixArray[j];
                if (!spacerArray[i].startsWith(nsPrefix)) continue;
                spacerArray[i] = ".".concat(spacerArray[i]);
                continue block0;
            }
        }
        return StyleUtils.convertToValidSelector(CSSGenerationUtils._arrayToStringWithSpaces(spacerArray));
    }

    private static boolean _isStyleClassTerminator(char c) {
        return Character.isWhitespace(c) || c == ':' || c == '.' || c == '[';
    }

    private static String _getSortedPropertyString(StyleNode style) {
        Vector<PropertyNode> v = new Vector<PropertyNode>();
        Collection<PropertyNode> propertyNodeList = style.getProperties();
        for (PropertyNode propertyNode : propertyNodeList) {
            v.addElement(propertyNode);
        }
        Object[] properties = new PropertyNode[v.size()];
        v.copyInto(properties);
        Arrays.sort(properties, PropertyNodeComparator.sharedInstance());
        int bufferSize = 0;
        for (int i = 0; i < properties.length; ++i) {
            Object property = properties[i];
            String name = ((PropertyNode)property).getName();
            String value = ((PropertyNode)property).getValue();
            if (name == null || value == null) continue;
            bufferSize += ((PropertyNode)property).getName().length();
            bufferSize += ((PropertyNode)property).getValue().length();
            ++bufferSize;
        }
        StringBuffer buffer = new StringBuffer(bufferSize);
        boolean first = true;
        for (int i = 0; i < properties.length; ++i) {
            Object property = properties[i];
            String name = ((PropertyNode)property).getName();
            String value = ((PropertyNode)property).getValue();
            if (name == null || value == null) continue;
            if (!first) {
                buffer.append(";");
            } else {
                first = false;
            }
            buffer.append(name);
            buffer.append(":");
            buffer.append(value);
        }
        return buffer.toString();
    }

    private static String _convertPseudoClassesInSelector(String selector) {
        if (selector == null) {
            return selector;
        }
        StringBuffer completeBuffer = new StringBuffer();
        StringBuffer pseudoClassBuffer = new StringBuffer();
        boolean inPseudoClass = false;
        for (int i = 0; i < selector.length(); ++i) {
            char x = selector.charAt(i);
            if (x == ':' || x == '.' || x == '[') {
                if (inPseudoClass) {
                    String convertedPseudoClass = CSSGenerationUtils._convertPseudoClass(pseudoClassBuffer.toString());
                    completeBuffer.append(convertedPseudoClass);
                    pseudoClassBuffer = new StringBuffer();
                    inPseudoClass = false;
                }
                if (x == ':') {
                    inPseudoClass = true;
                    pseudoClassBuffer.append(x);
                    continue;
                }
                if (x != '.' && x != '[') continue;
                completeBuffer.append(x);
                continue;
            }
            if (!inPseudoClass) {
                completeBuffer.append(x);
                continue;
            }
            pseudoClassBuffer.append(x);
        }
        if (inPseudoClass) {
            String mappedPseudoClass = CSSGenerationUtils._convertPseudoClass(pseudoClassBuffer.toString());
            completeBuffer.append(mappedPseudoClass);
        }
        return completeBuffer.toString();
    }

    private static String[] _splitStringByWhitespace(String selector) {
        int length = selector.length();
        StringBuffer buffer = new StringBuffer(length);
        ArrayList<String> splitList = new ArrayList<String>();
        boolean inWhitespace = false;
        for (int i = 0; i < length; ++i) {
            char c = selector.charAt(i);
            if (Character.isWhitespace(c)) {
                String bufferString;
                if (inWhitespace || (bufferString = buffer.toString()).length() <= 0) continue;
                splitList.add(bufferString);
                buffer = new StringBuffer(length);
                inWhitespace = true;
                continue;
            }
            buffer.append(c);
            if (!inWhitespace) continue;
            inWhitespace = false;
        }
        String lastString = buffer.toString();
        if (lastString.length() > 0) {
            splitList.add(lastString);
        }
        return splitList.toArray(_EMPTY_STRING_ARRAY);
    }

    private static String _runThroughMap(Map<String, String> map, String selector) {
        String mappedSelector = map.get(selector);
        return mappedSelector != null ? mappedSelector : selector;
    }

    private static String _convertPseudoClass(String pseudoClass) {
        if (_BUILT_IN_PSEUDO_CLASSES.contains(pseudoClass) && !Beans.isDesignTime()) {
            return pseudoClass;
        }
        StringBuilder builder = new StringBuilder(pseudoClass.length() + 3);
        builder.append(".");
        builder.append("p_AF");
        for (String content : _DASH_PATTERN.split(pseudoClass.substring(1))) {
            if (content.length() <= 0) continue;
            builder.append(Character.toUpperCase(content.charAt(0)));
            builder.append(content.substring(1));
        }
        return builder.toString();
    }

    static {
        _BUILT_IN_PSEUDO_CLASSES.add(":first-child");
        _BUILT_IN_PSEUDO_CLASSES.add(":link");
        _BUILT_IN_PSEUDO_CLASSES.add(":visited");
        _BUILT_IN_PSEUDO_CLASSES.add(":hover");
        _BUILT_IN_PSEUDO_CLASSES.add(":active");
        _BUILT_IN_PSEUDO_CLASSES.add(":focus");
        _DASH_PATTERN = Pattern.compile("-");
        _EMPTY_STRING_ARRAY = new String[0];
        _LOG = TrinidadLogger.createTrinidadLogger(CSSGenerationUtils.class);
    }

    private static class PropertyNodeComparator
    implements Comparator<PropertyNode> {
        private static final Comparator<PropertyNode> _sInstance = new PropertyNodeComparator();

        public static Comparator<PropertyNode> sharedInstance() {
            return _sInstance;
        }

        @Override
        public int compare(PropertyNode o1, PropertyNode o2) {
            String name2;
            String name1 = o1 == null ? null : o1.getName();
            String string = name2 = o2 == null ? null : o2.getName();
            if (name1 == null || name2 == null) {
                if (name1 == name2) {
                    return 0;
                }
                if (name1 != null) {
                    return 1;
                }
                return -1;
            }
            return name1.compareTo(name2);
        }

        private PropertyNodeComparator() {
        }
    }
}

