/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpSession;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.context.Window;
import org.apache.myfaces.trinidad.context.WindowManager;

public final class TokenCacheDebugUtils {
    private static final String _UNSUPPORTED_OPERATION_MESSAGE = "Methods in TokenCacheDebugUtils can only be called when TokenCacheDebugUtils.debugTokenCache() returns true. TokenCacheDebugUtils.debugTokenCache() returns true when the system property 'org.apache.myfaces.trinidadinternal.DEBUG_TOKEN_CACHE' is true";
    private static final String _STRINGBUFFER_KEY = TokenCacheDebugUtils.class.getName() + "#StringBuffer";
    private static final boolean _DEBUG_TOKEN_CACHE;

    private TokenCacheDebugUtils() {
    }

    public static boolean debugTokenCache() {
        return _DEBUG_TOKEN_CACHE;
    }

    public static void addTokenToViewIdMap(String token) {
        if (!_DEBUG_TOKEN_CACHE) {
            throw new UnsupportedOperationException(_UNSUPPORTED_OPERATION_MESSAGE);
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Map<String, String> tokenToViewIdMap = TokenCacheDebugUtils._getTokenToViewIdMap(context);
        UIViewRoot root = context.getViewRoot();
        String viewId = root.getViewId();
        tokenToViewIdMap.put(token, viewId);
        StringBuffer logBuffer = TokenCacheDebugUtils._getLogBuffer(context);
        logBuffer.append("\nADDING ").append(TokenCacheDebugUtils._getTokenToViewIdString(tokenToViewIdMap, token));
    }

    public static void removeTokenFromViewIdMap(String token) {
        if (!_DEBUG_TOKEN_CACHE) {
            throw new UnsupportedOperationException(_UNSUPPORTED_OPERATION_MESSAGE);
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Map<String, String> tokenToViewIdMap = TokenCacheDebugUtils._getTokenToViewIdMap(context);
        StringBuffer logBuffer = TokenCacheDebugUtils._getLogBuffer(context);
        logBuffer.append("\nREMOVING ").append(TokenCacheDebugUtils._getTokenToViewIdString(tokenToViewIdMap, token));
        tokenToViewIdMap.remove(token);
    }

    public static String getTokenToViewIdString(String token) {
        if (!_DEBUG_TOKEN_CACHE) {
            throw new UnsupportedOperationException(_UNSUPPORTED_OPERATION_MESSAGE);
        }
        FacesContext context = FacesContext.getCurrentInstance();
        return TokenCacheDebugUtils._getTokenToViewIdString(TokenCacheDebugUtils._getTokenToViewIdMap(context), token);
    }

    public static <V> void logCacheInfo(Map<String, V> targetStore, Map<String, String> pinned, String logAddition) {
        if (!_DEBUG_TOKEN_CACHE) {
            throw new UnsupportedOperationException(_UNSUPPORTED_OPERATION_MESSAGE);
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Map<String, String> tokenToViewId = TokenCacheDebugUtils._getTokenToViewIdMap(context);
        StringBuffer logString = TokenCacheDebugUtils._getLogBuffer(context);
        logString.append("\n");
        if (logAddition != null) {
            logString.append(logAddition).append("\n");
        }
        logString.append("cached token keys:");
        for (String targetStoreToken : targetStore.keySet()) {
            logString.append("\n    ");
            logString.append(TokenCacheDebugUtils._getTokenToViewIdString(tokenToViewId, targetStoreToken));
        }
        if (pinned != null) {
            logString.append("\n_pinned token keys:");
            for (String pinnedKeyToken : pinned.keySet()) {
                logString.append("\n    ");
                logString.append(TokenCacheDebugUtils._getTokenToViewIdString(tokenToViewId, pinnedKeyToken));
                logString.append("   pinned to     ");
                String pinnedValueToken = pinned.get(pinnedKeyToken);
                logString.append(TokenCacheDebugUtils._getTokenToViewIdString(tokenToViewId, pinnedValueToken));
            }
        }
    }

    public static void addToLog(String addString) {
        if (!_DEBUG_TOKEN_CACHE) {
            throw new UnsupportedOperationException(_UNSUPPORTED_OPERATION_MESSAGE);
        }
        FacesContext context = FacesContext.getCurrentInstance();
        TokenCacheDebugUtils._getLogBuffer(context).append(addString);
    }

    public static void startLog(String startString) {
        if (!_DEBUG_TOKEN_CACHE) {
            throw new UnsupportedOperationException(_UNSUPPORTED_OPERATION_MESSAGE);
        }
        FacesContext context = FacesContext.getCurrentInstance();
        StringBuffer logBuffer = TokenCacheDebugUtils._getLogBuffer(context, true);
        logBuffer.append("-------------- ").append(startString).append(" ----------\n");
        TokenCacheDebugUtils._logIdString(context);
    }

    public static String getLogString() {
        if (!_DEBUG_TOKEN_CACHE) {
            throw new UnsupportedOperationException(_UNSUPPORTED_OPERATION_MESSAGE);
        }
        FacesContext context = FacesContext.getCurrentInstance();
        return TokenCacheDebugUtils._getLogBuffer(context).toString();
    }

    private static StringBuffer _getLogBuffer(FacesContext context) {
        return TokenCacheDebugUtils._getLogBuffer(context, false);
    }

    private static StringBuffer _getLogBuffer(FacesContext context, boolean startNewBuffer) {
        Map requestMap = context.getExternalContext().getRequestMap();
        StringBuffer buff = null;
        if (!startNewBuffer) {
            buff = (StringBuffer)requestMap.get(_STRINGBUFFER_KEY);
        }
        if (buff == null) {
            buff = new StringBuffer();
            requestMap.put(_STRINGBUFFER_KEY, buff);
        }
        return buff;
    }

    private static void _logIdString(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        String sessionId = "";
        Object session = externalContext.getSession(false);
        if (session instanceof HttpSession) {
            sessionId = ((HttpSession)session).getId();
        }
        StringBuffer buff = TokenCacheDebugUtils._getLogBuffer(context);
        buff.append("Session Id = ").append(sessionId);
        WindowManager wm = RequestContext.getCurrentInstance().getWindowManager();
        if (wm != null) {
            Window window = wm.getCurrentWindow(externalContext);
            if (window != null) {
                buff.append("\nWindow Id = ").append(window.getId());
            } else {
                buff.append("\nWindow Id could not be determined, window is null");
            }
        } else {
            buff.append("\nWindow Id could not be determined, window manager null");
        }
    }

    private static Map<String, String> _getTokenToViewIdMap(FacesContext context) {
        ConcurrentHashMap tokenToViewId = (ConcurrentHashMap)context.getExternalContext().getSessionMap().get("org.apache.myfaces.trinidadinternal.util.TOKEN_FOR_VIEW_ID");
        if (tokenToViewId == null) {
            tokenToViewId = new ConcurrentHashMap();
            context.getExternalContext().getSessionMap().put("org.apache.myfaces.trinidadinternal.util.TOKEN_FOR_VIEW_ID", tokenToViewId);
        }
        return tokenToViewId;
    }

    private static String _getTokenToViewIdString(Map<String, String> tokenToViewId, String token) {
        StringBuffer tokenBuffer = new StringBuffer();
        tokenBuffer.append(token);
        tokenBuffer.append(" (");
        tokenBuffer.append(tokenToViewId.get(token));
        tokenBuffer.append(")");
        return tokenBuffer.toString();
    }

    static {
        String dtcProp = System.getProperty("org.apache.myfaces.trinidadinternal.DEBUG_TOKEN_CACHE");
        _DEBUG_TOKEN_CACHE = Boolean.valueOf(dtcProp);
    }
}

