/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.agent;

import java.util.Collections;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.agent.AgentFactory;
import org.apache.myfaces.trinidadinternal.agent.AgentImpl;
import org.apache.myfaces.trinidadinternal.agent.CapabilityKey;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;

public class AgentFactoryImpl
implements AgentFactory {
    private static final String _EMAIL_PARAM = "org.apache.myfaces.trinidad.agent.email";
    private static final String _IASW_DEVICE_HINT_PARAM = "X-Oracle-Device.Class";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(AgentFactoryImpl.class);
    private static final String _GOOGLEBOT_ID = "Googlebot";
    private static final String _MSNBOT_ID = "msnbot";
    private static final String _BINGBOT_ID = "bingbot";
    private static final String _ORACLE_SES_ID = "Oracle Secure Enterprise Search";

    public Agent createAgent(Map<String, String> headerMap) {
        AgentImpl agent = new AgentImpl();
        this._populateAgentImpl(null, headerMap, agent);
        return agent;
    }

    @Override
    public Agent createAgent(FacesContext facesContext) {
        AgentImpl agent = new AgentImpl();
        Map headerMap = facesContext != null ? facesContext.getExternalContext().getRequestHeaderMap() : Collections.emptyMap();
        this._populateAgentImpl(facesContext, headerMap, agent);
        return agent;
    }

    private void _populateAgentImpl(FacesContext facesContext, Map<String, String> headerMap, AgentImpl agent) {
        String userAgent = headerMap.get("User-Agent");
        if (userAgent == null) {
            this._populateUnknownAgentImpl(userAgent, agent);
            return;
        }
        String isEmail = null;
        if (facesContext != null) {
            isEmail = (String)facesContext.getExternalContext().getRequestParameterMap().get(_EMAIL_PARAM);
        }
        if ("true".equals(isEmail)) {
            this._populateEmailAgentImpl(agent);
            return;
        }
        if (userAgent != null && userAgent.startsWith("PTG")) {
            this._populateIaswAgentImpl(userAgent, headerMap.get(_IASW_DEVICE_HINT_PARAM), agent);
            return;
        }
        String accept = headerMap.get("Accept");
        if (accept != null && accept.regionMatches(true, 0, "vnd.wap.wml", 0, 11)) {
            this._populateWAPAgentImpl(agent);
            return;
        }
        if (userAgent == null) {
            this._populateUnknownAgentImpl(null, agent);
            return;
        }
        int googlebotIndex = userAgent.indexOf(_GOOGLEBOT_ID);
        if (googlebotIndex >= 0) {
            this._populateCrawlerAgentImpl(userAgent, agent, "googlebot", _GOOGLEBOT_ID, googlebotIndex);
            return;
        }
        int bingIndex = userAgent.indexOf(_BINGBOT_ID);
        if (bingIndex >= 0) {
            this._populateCrawlerAgentImpl(userAgent, agent, _MSNBOT_ID, _BINGBOT_ID, bingIndex);
            return;
        }
        bingIndex = userAgent.indexOf(_MSNBOT_ID);
        if (bingIndex >= 0) {
            this._populateCrawlerAgentImpl(userAgent, agent, _MSNBOT_ID, _MSNBOT_ID, bingIndex);
            return;
        }
        int oracleSesIndex = userAgent.indexOf(_ORACLE_SES_ID);
        if (oracleSesIndex >= 0) {
            this._populateCrawlerAgentImpl(userAgent, agent, "oracle_ses", _ORACLE_SES_ID, oracleSesIndex);
            return;
        }
        if (userAgent.startsWith("OracleJDevMobile")) {
            this._populateJDevMobileAgentImpl(userAgent, agent);
            return;
        }
        if (userAgent.startsWith("OracleITS")) {
            this._populateTelnetAgentImpl(userAgent, agent);
            return;
        }
        if (userAgent.startsWith("Pixo-Browser")) {
            this._populatePixoAgentImpl(userAgent, agent);
            return;
        }
        if (userAgent.startsWith("ICE Browser")) {
            this._populateIceAgentImpl(userAgent, agent);
            return;
        }
        if (userAgent.indexOf("WebPro") != -1 && userAgent.indexOf("Palm") != -1 || userAgent.indexOf("Blazer/3.") != -1) {
            this._populatePalmWebBrowserProAgentImpl(userAgent, agent);
            return;
        }
        if (userAgent.indexOf("Windows CE") != -1) {
            String uaPixels = headerMap.get("UA-pixels");
            this._populatePocketPCAgentImpl(userAgent, uaPixels, agent);
            return;
        }
        if (userAgent.indexOf("PalmOS") != -1 || userAgent.indexOf("Blazer") != -1 || userAgent.indexOf("Xiino") != -1) {
            this._populatePalmAgentImpl(userAgent, agent);
            return;
        }
        if (userAgent.indexOf("AppleWebKit") != -1 || userAgent.indexOf("Safari") != -1) {
            this._populateSafariAgentImpl(userAgent, agent);
            return;
        }
        if (userAgent.startsWith("BlackBerry")) {
            this._populateBlackberryAgentImpl(userAgent, agent);
            return;
        }
        if (userAgent.indexOf("Opera") > -1) {
            this._populateOperaAgentImpl(userAgent, agent);
            return;
        }
        String userAgentLowercase = userAgent.toLowerCase();
        if (userAgentLowercase.indexOf("wap1.") < 0 && (userAgentLowercase.indexOf("wap2.") > -1 || userAgentLowercase.indexOf("up.browser") > -1 || userAgentLowercase.indexOf("nokia") > -1 || userAgentLowercase.startsWith("mot-") || userAgentLowercase.indexOf("symbian") > -1 || userAgentLowercase.indexOf("sonyeri") > -1 || userAgentLowercase.indexOf("netfront/") > -1 || userAgentLowercase.startsWith("samsang-") || userAgentLowercase.startsWith("lg-") || userAgentLowercase.indexOf("obigo") > -1 || userAgentLowercase.indexOf("vodafone") > -1 || userAgentLowercase.indexOf("kddi") > -1 || userAgentLowercase.indexOf("openwave") > -1)) {
            this._populateGenericPDAAgentImpl(userAgent, agent);
            return;
        }
        if (userAgent.indexOf("Gecko/") != -1) {
            this._populateGeckoAgentImpl(userAgent, agent);
            return;
        }
        if (userAgent.startsWith("Mozilla")) {
            this._populateMozillaAgentImpl(userAgent, agent);
            return;
        }
        this._populateUnknownAgentImpl(userAgent, agent);
    }

    private void _populateGenericPDAAgentImpl(String userAgent, AgentImpl agent) {
        agent.setType(Agent.TYPE_PDA);
        agent.setAgent("genericpda");
        agent.setAgentVersion("1");
        agent.setPlatform("genericpda");
    }

    private void _populateUnknownAgentImpl(String userAgent, AgentImpl agent) {
        _LOG.warning("UNKNOWN_AGENT_ATTRIBUTES_CREATE_WITH_UNKNOWN", (Object)userAgent);
        agent.setAgentEntryToNULL();
    }

    private void _populateJDevMobileAgentImpl(String agent, AgentImpl agentObj) {
        boolean returnUnknownAgentObj = false;
        int itsIndex = agent.indexOf("ITS");
        int pdaIndex = agent.indexOf("PDA");
        int versionStartIndex = -1;
        if (itsIndex > -1) {
            agentObj.setType(Agent.TYPE_TELNET);
            versionStartIndex = "OracleJDevMobile_ITS".length() + 1;
        } else if (pdaIndex > -1) {
            agentObj.setType(Agent.TYPE_PDA);
            versionStartIndex = "OracleJDevMobile_PDA".length() + 1;
        } else {
            returnUnknownAgentObj = true;
        }
        if (!returnUnknownAgentObj) {
            int agentNameStartIndex;
            int versionEndIndex = agent.indexOf("(");
            String version = agent.substring(versionStartIndex, versionEndIndex);
            agentObj.setAgentVersion(version);
            int agentNameEndIndex = agentNameStartIndex = agent.indexOf(":", versionEndIndex) + 1;
            while (agent.charAt(agentNameEndIndex) != ';' && agent.charAt(agentNameEndIndex) != ')') {
                ++agentNameEndIndex;
            }
            String agentName = agent.substring(agentNameStartIndex, agentNameEndIndex);
            agentObj.setAgent(agentName);
            if (agent.charAt(agentNameEndIndex) == ')') {
                return;
            }
            int capabilityValueEndIndex = agentNameEndIndex;
            while (agent.charAt(capabilityValueEndIndex) != ')') {
                int capabilityNameStartIndex = capabilityValueEndIndex + 1;
                int capabilityNameEndIndex = agent.indexOf(":", capabilityNameStartIndex);
                String capabilityName = agent.substring(capabilityNameStartIndex, capabilityNameEndIndex);
                int capabilityValueStartIndex = capabilityNameEndIndex + 1;
                capabilityValueEndIndex = agent.indexOf(";", capabilityValueStartIndex);
                if (capabilityValueEndIndex == -1) {
                    capabilityValueEndIndex = agent.indexOf(")", capabilityValueEndIndex);
                }
                String capabilityValue = agent.substring(capabilityValueStartIndex, capabilityValueEndIndex);
                agentObj.__addRequestCapability(CapabilityKey.getCapabilityKey(capabilityName, true), capabilityValue);
            }
        }
        if (returnUnknownAgentObj) {
            this._populateUnknownAgentImpl(agent, agentObj);
        }
    }

    private void _populateTelnetAgentImpl(String agent, AgentImpl agentObj) {
        int agentNameStartIndex;
        agentObj.setType(Agent.TYPE_TELNET);
        int versionStartIndex = "OracleITS".length() + 1;
        int versionEndIndex = agent.indexOf("(");
        String version = agent.substring(versionStartIndex, versionEndIndex);
        agentObj.setAgentVersion(version);
        int agentNameEndIndex = agentNameStartIndex = agent.indexOf(":", versionEndIndex) + 1;
        while (agent.charAt(agentNameEndIndex) != ';' && agent.charAt(agentNameEndIndex) != ')') {
            ++agentNameEndIndex;
        }
        String agentName = agent.substring(agentNameStartIndex, agentNameEndIndex);
        agentObj.setAgent(agentName);
        if (agent.charAt(agentNameEndIndex) == ')') {
            return;
        }
        int capabilityValueEndIndex = agentNameEndIndex;
        while (agent.charAt(capabilityValueEndIndex) != ')') {
            int capabilityNameStartIndex = capabilityValueEndIndex + 1;
            int capabilityNameEndIndex = agent.indexOf(":", capabilityNameStartIndex);
            String capabilityName = agent.substring(capabilityNameStartIndex, capabilityNameEndIndex);
            int capabilityValueStartIndex = capabilityNameEndIndex + 1;
            capabilityValueEndIndex = agent.indexOf(";", capabilityValueStartIndex);
            if (capabilityValueEndIndex == -1) {
                capabilityValueEndIndex = agent.indexOf(")", capabilityValueEndIndex);
            }
            String capabilityValue = agent.substring(capabilityValueStartIndex, capabilityValueEndIndex);
            agentObj.__addRequestCapability(CapabilityKey.getCapabilityKey(capabilityName, true), capabilityValue);
        }
    }

    private void _populatePocketPCAgentImpl(String agent, String uaPixels, AgentImpl agentObj) {
        int length;
        int start = agent.indexOf("IEMobile");
        if (start < 0) {
            start = agent.indexOf("MSIE");
            length = "MSIE".length();
        } else {
            length = "IEMobile".length();
        }
        String version = null;
        if (start > -1) {
            version = this._getVersion(agent, start + length);
        }
        agentObj.setType(Agent.TYPE_PDA);
        agentObj.setAgent("ie");
        agentObj.setAgentVersion(version);
        agentObj.setPlatform("ppc");
        boolean narrowScreenDevice = false;
        if (uaPixels != null && uaPixels.length() > 0) {
            Integer width = null;
            Integer height = null;
            String[] parts = uaPixels.split("x");
            if (parts.length == 2) {
                try {
                    width = new Integer(parts[0]);
                    height = new Integer(parts[1]);
                }
                catch (NumberFormatException ex) {
                    _LOG.fine((Throwable)ex);
                }
            }
            if (width != null && height != null) {
                agentObj.__addRequestCapability(TrinidadAgent.CAP_WIDTH, width);
                agentObj.__addRequestCapability(TrinidadAgent.CAP_HEIGHT, height);
                if (width < 240) {
                    narrowScreenDevice = true;
                }
            } else {
                _LOG.fine("When creating the Agent, the UA-pixels value \"{0}\" could not be parsed.", (Object)uaPixels);
            }
        } else {
            narrowScreenDevice = true;
        }
        if (narrowScreenDevice) {
            agentObj.__addRequestCapability(TrinidadAgent.CAP_NARROW_SCREEN, Boolean.TRUE);
        } else {
            agentObj.__addRequestCapability(TrinidadAgent.CAP_NARROW_SCREEN, Boolean.FALSE);
        }
    }

    private void _populateBlackberryAgentImpl(String agent, AgentImpl agentObj) {
        int slashLoc;
        int start = agent.indexOf("BlackBerry");
        String version = null;
        String makeModel = null;
        if (start > -1 && (slashLoc = agent.indexOf(47, start)) > -1) {
            makeModel = agent.substring(start, slashLoc);
            version = this._getVersion(agent, slashLoc);
        }
        agentObj.setType(Agent.TYPE_PDA);
        agentObj.setAgent("blackberry");
        agentObj.setAgentVersion(version);
        agentObj.setPlatform("blackberry");
        agentObj.setMakeModel(makeModel);
        agentObj.__addRequestCapability(TrinidadAgent.CAP_NARROW_SCREEN, Boolean.FALSE);
    }

    private void _populatePalmWebBrowserProAgentImpl(String agent, AgentImpl agentObj) {
        agentObj.setType(Agent.TYPE_PDA);
        agentObj.setAgent("webpro");
        int start = agent.indexOf("WebPro/");
        if (start > -1) {
            agentObj.setAgentVersion(this._getVersion(agent, start + 6));
        }
        agentObj.setPlatform("palm");
    }

    private void _populateIaswAgentImpl(String agent, String wirelessType, AgentImpl agentObj) {
        if (wirelessType == null) {
            this._populateUnknownAgentImpl(agent, agentObj);
            return;
        }
        String version = this._getVersion(agent, agent.indexOf(47));
        agentObj.setType(Agent.TYPE_PHONE);
        agentObj.setAgent("ptg");
        agentObj.setAgentVersion(version);
    }

    private void _populatePalmAgentImpl(String userAgent, AgentImpl agentObj) {
        agentObj.setType(Agent.TYPE_PDA);
        if (userAgent.indexOf("Blazer") != -1) {
            agentObj.setAgent("blazer");
        } else if (userAgent.indexOf("Xiino") != -1) {
            agentObj.setAgent("xiino");
        }
        agentObj.setPlatform("palm");
    }

    private void _populateIceAgentImpl(String agent, AgentImpl agentObj) {
        int slashIndex = agent.indexOf(47);
        agentObj.setType(Agent.TYPE_DESKTOP);
        agentObj.setAgent("icebrowser");
        agentObj.setAgentVersion(this._getVersion(agent, slashIndex));
        agentObj.setPlatform(this._getJavaOS(agent, slashIndex));
    }

    private void _populatePixoAgentImpl(String agent, AgentImpl agentObj) {
        agentObj.setType(Agent.TYPE_PHONE);
        agentObj.setAgent("pixo");
        agentObj.setAgentVersion(this._getVersion(agent, agent.indexOf(47)));
    }

    private void _populateWAPAgentImpl(AgentImpl agentObj) {
        agentObj.setType(Agent.TYPE_PHONE);
    }

    private void _populateGeckoAgentImpl(String agent, AgentImpl agentObj) {
        agentObj.setType(Agent.TYPE_DESKTOP);
        agentObj.setAgent("gecko");
        int start = agent.indexOf("rv:");
        if (start >= 0) {
            agentObj.setAgentVersion(this._getVersion(agent, start + 2));
        } else {
            int geckoIndex = agent.indexOf("Gecko/");
            agentObj.setAgentVersion(agent.substring(geckoIndex + 6, geckoIndex + 14));
        }
        int paren = agent.indexOf(40);
        if (paren >= 0) {
            if (agent.indexOf("Win", paren) > 0) {
                agentObj.setPlatform("windows");
            } else if (agent.indexOf("Mac", paren) > 0) {
                agentObj.setPlatform("mac");
            } else if (agent.indexOf("Linux", paren) > 0) {
                agentObj.setPlatform("linux");
            } else if (agent.indexOf("Sun", paren) > 0) {
                agentObj.setPlatform("solaris");
            }
        }
    }

    private void _populateOperaAgentImpl(String agent, AgentImpl agentObj) {
        int start = agent.indexOf("Opera Mini");
        if (start > -1) {
            start = agent.indexOf(47, start);
            String version = this._getVersion(agent, start);
            agentObj.setAgentVersion(version);
            agentObj.setType(Agent.TYPE_PDA);
            agentObj.setAgent("genericpda");
            agentObj.setPlatform("genericpda");
        } else {
            int paren;
            if (agent.indexOf("MOT-") != -1 || agent.indexOf("Nokia") != -1) {
                return;
            }
            agentObj.setType(Agent.TYPE_DESKTOP);
            agentObj.setAgent("opera");
            int operaIndex = agent.indexOf("Opera/");
            int firstSpace = agent.indexOf(" ");
            if (agent.indexOf("HTC-") != -1 || agent.indexOf("HTC_") != -1 || agent.indexOf("XV6850") != -1) {
                firstSpace = agent.indexOf(" ", operaIndex);
            }
            if (operaIndex >= 0 && firstSpace >= 0) {
                agentObj.setAgentVersion(agent.substring(operaIndex + 6, firstSpace));
            }
            if ((paren = agent.indexOf(40)) >= 0) {
                if (agent.indexOf("Win", paren) > 0) {
                    agentObj.setPlatform("windows");
                } else if (agent.indexOf("Mac", paren) > 0) {
                    agentObj.setPlatform("mac");
                } else if (agent.indexOf("Linux", paren) > 0) {
                    agentObj.setPlatform("linux");
                } else if (agent.indexOf("Sun", paren) > 0) {
                    agentObj.setPlatform("solaris");
                }
            }
        }
    }

    private void _populateSafariAgentImpl(String agent, AgentImpl agentObj) {
        int start = agent.indexOf("AppleWebKit");
        if (start < 0) {
            start = agent.indexOf("Safari");
        }
        if (start >= 0) {
            start = agent.indexOf(47, start);
        }
        if (agent.indexOf("iPhone") > 0) {
            agentObj.setPlatform("iphone");
        } else if (agent.indexOf("iPad") > 0) {
            agentObj.setPlatform("iphone");
        } else if (agent.indexOf("iPod") > 0) {
            agentObj.setPlatform("iphone");
        } else if (agent.indexOf("Win") > 0) {
            agentObj.setPlatform("windows");
        } else if (agent.indexOf("Android") > 0) {
            agentObj.setPlatform("android");
        } else if (agent.indexOf("Linux") > 0) {
            agentObj.setPlatform("linux");
        } else if (agent.indexOf("Mac") > 0) {
            agentObj.setPlatform("mac");
        } else if (agent.indexOf("BlackBerry") > 0) {
            agentObj.setPlatform("blackberry");
        } else if (agent.indexOf("webOS") > 0) {
            agentObj.setPlatform("palm");
        }
        String version = this._getVersion(agent, start);
        agentObj.setType(Agent.TYPE_DESKTOP);
        if (agent.indexOf("Symbian") > -1 || agent.indexOf("Nokia") > -1) {
            agentObj.setAgent("nokia_s60");
            agentObj.setPlatform("nokia_s60");
        } else {
            agentObj.setAgent("webkit");
        }
        agentObj.setAgentVersion(version);
    }

    private void _populateMozillaAgentImpl(String agent, AgentImpl agentObj) {
        int paren = agent.indexOf(40);
        agentObj.setType(Agent.TYPE_DESKTOP);
        if (paren == -1) {
            agentObj.setAgent("netscape");
            agentObj.setAgentVersion(this._getVersion(agent, agent.indexOf(47)));
        } else {
            boolean isJDevJSVE;
            boolean isJDevVE = agent.indexOf("JDeveloper", ++paren) > 0;
            boolean bl = isJDevJSVE = agent.indexOf("JDeveloper JS", paren) > 0;
            if (agent.indexOf("Konqueror", paren) >= 0) {
                agentObj.setType(Agent.TYPE_DESKTOP);
                agentObj.setAgent("konqueror");
                agentObj.setAgentVersion(this._getVersion(agent, agent.lastIndexOf(47)));
            } else if (agent.startsWith("compatible", paren)) {
                int ieIndex = agent.indexOf("MSIE", paren);
                if (ieIndex < 0) {
                    int palmIndex = agent.indexOf("Elaine", paren);
                    if (palmIndex > 0) {
                        agentObj.setType(Agent.TYPE_PDA);
                        agentObj.setAgent("elaine");
                        agentObj.setAgentVersion(this._getVersion(agent, palmIndex));
                        agentObj.setPlatform("palm");
                    }
                } else {
                    agentObj.setAgent("ie");
                    agentObj.setAgentVersion(this._getVersion(agent, ieIndex + 4));
                }
            } else {
                agentObj.setAgent("netscape");
                agentObj.setAgentVersion(this._getVersion(agent, agent.indexOf(47)));
            }
            if (agentObj.getPlatformName() == null || agentObj.getPlatformName().equals("unknown")) {
                if (agent.indexOf("Win", paren) > 0 || isJDevVE) {
                    agentObj.setPlatform("windows");
                } else if (agent.indexOf("Mac", paren) > 0) {
                    agentObj.setPlatform("mac");
                } else if (agent.indexOf("Linux", paren) > 0) {
                    agentObj.setPlatform("linux");
                } else if (agent.indexOf("Sun", paren) > 0) {
                    agentObj.setPlatform("solaris");
                }
            }
            if (isJDevVE) {
                agentObj.__addRequestCapability(TrinidadAgent.CAP_IS_JDEV_VE, Boolean.TRUE);
                if (isJDevJSVE) {
                    agentObj.__addRequestCapability(TrinidadAgent.CAP_IS_JDEV_JAVASCRIPT_VE, Boolean.TRUE);
                }
            }
        }
    }

    private void _populateEmailAgentImpl(AgentImpl agentObj) {
        agentObj.setType(Agent.TYPE_DESKTOP);
        agentObj.setAgent("email");
        agentObj.setAgentVersion("0.0");
        agentObj.setPlatform("unknown");
        agentObj.setPlatformVersion("unknown");
        agentObj.setMakeModel("unknown");
    }

    private void _populateCrawlerAgentImpl(String userAgent, AgentImpl agentObj, String agent, String agentId, int idIndex) {
        agentObj.setType(Agent.TYPE_WEBCRAWLER);
        agentObj.setAgent(agent);
        String version = this._getVersion(userAgent, idIndex + agentId.length());
        if (version != null && version.length() > 0) {
            agentObj.setAgentVersion(version);
        }
        agentObj.setPlatform("unknown");
        agentObj.setPlatformVersion("unknown");
        agentObj.setMakeModel("unknown");
    }

    private String _getVersion(String base, int start) {
        int end;
        if (start < 0) {
            return null;
        }
        for (int i = start = start >= (end = base.length()) ? end : start + 1; i < end; ++i) {
            char ch = base.charAt(i);
            if (ch == '.' || ch >= '0' && ch <= '9') continue;
            return base.substring(start, i);
        }
        return base.substring(start);
    }

    private String _getJavaOS(String base, int start) {
        if (start < 0) {
            return null;
        }
        if (base.regionMatches(start, "Windows", 0, base.length() - start)) {
            return "windows";
        }
        return null;
    }
}

