/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config.upload;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.UploadedFile;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidad.webapp.UploadedFileProcessor;
import org.apache.myfaces.trinidadinternal.config.upload.ErrorFile;
import org.apache.myfaces.trinidadinternal.config.upload.UploadedFileImpl;
import org.apache.myfaces.trinidadinternal.context.external.PortletApplicationMap;
import org.apache.myfaces.trinidadinternal.context.external.PortletInitParameterMap;
import org.apache.myfaces.trinidadinternal.context.external.PortletRequestMap;
import org.apache.myfaces.trinidadinternal.context.external.ServletApplicationMap;
import org.apache.myfaces.trinidadinternal.context.external.ServletInitParameterMap;
import org.apache.myfaces.trinidadinternal.context.external.ServletRequestMap;

public class CompositeUploadedFileProcessorImpl
implements UploadedFileProcessor {
    private long _maxMemory = -1L;
    private long _maxDiskSpace = -1L;
    private String _tempDir = null;
    private static final long _DEFAULT_MAX_MEMORY = 102400L;
    private static final long _DEFAULT_MAX_DISK_SPACE = 2048000L;
    private static final String _REQUEST_INFO_KEY;
    private static final TrinidadLogger _LOG;
    private static final Class<?> _PORTLET_CONTEXT_CLASS;
    private static final Class<?> _PORTLET_REQUEST_CLASS;
    private final List<? extends UploadedFileProcessor> chainedProcessors;

    public CompositeUploadedFileProcessorImpl() {
        this.chainedProcessors = Collections.emptyList();
    }

    public CompositeUploadedFileProcessorImpl(List<? extends UploadedFileProcessor> chainedProcessors) {
        this.chainedProcessors = chainedProcessors;
    }

    public void init(Object context) {
        this._init(context);
        for (UploadedFileProcessor uploadedFileProcessor : this.chainedProcessors) {
            uploadedFileProcessor.init(context);
        }
    }

    public UploadedFile processFile(Object request, UploadedFile tempFile) throws IOException {
        UploadedFile original = this._processFile(request, tempFile);
        if (this.chainedProcessors.isEmpty()) {
            return original;
        }
        ArrayList<UploadedFile> files = new ArrayList<UploadedFile>(this.chainedProcessors.size() + 1);
        files.add(original);
        for (UploadedFileProcessor uploadedFileProcessor : this.chainedProcessors) {
            try {
                original = uploadedFileProcessor.processFile(request, original);
            }
            catch (IOException ioe) {
                _LOG.severe((Throwable)ioe);
                String test = ioe.getLocalizedMessage();
                original = new ErrorFile(ioe.getLocalizedMessage());
                break;
            }
            files.add(original);
        }
        Collections.reverse(files);
        return new WrappedUploadedFileImpl(original, files);
    }

    private void _init(Object context) {
        ContextInfo info = _PORTLET_CONTEXT_CLASS != null && _PORTLET_CONTEXT_CLASS.isInstance(context) ? CompositeUploadedFileProcessorImpl._getPortletContextInfo(context) : CompositeUploadedFileProcessorImpl._getServletContextInfo(context);
        if (this._maxMemory == -1L) {
            String maxMemory = info.initParams.get("org.apache.myfaces.trinidad.UPLOAD_MAX_MEMORY");
            if (maxMemory != null) {
                try {
                    this._maxMemory = Long.parseLong(maxMemory);
                }
                catch (NumberFormatException nfe) {
                    this._maxMemory = 102400L;
                }
            } else {
                this._maxMemory = 102400L;
            }
        }
        if (this._maxDiskSpace == -1L) {
            String maxDiskSpace = info.initParams.get("org.apache.myfaces.trinidad.UPLOAD_MAX_DISK_SPACE");
            if (maxDiskSpace != null) {
                try {
                    this._maxDiskSpace = Long.parseLong(maxDiskSpace);
                }
                catch (NumberFormatException nfe) {
                    this._maxDiskSpace = 2048000L;
                }
            } else {
                this._maxDiskSpace = 2048000L;
            }
        }
        if (this._tempDir == null) {
            File tempDirFile;
            this._tempDir = info.initParams.get("org.apache.myfaces.trinidad.UPLOAD_TEMP_DIR");
            if (this._tempDir == null && (tempDirFile = (File)info.attributes.get("javax.servlet.context.tempdir")) != null) {
                this._tempDir = tempDirFile.getAbsolutePath();
            }
        }
    }

    private UploadedFile _processFile(Object request, UploadedFile tempFile) {
        RequestInfo info = this._getRequestInfo(request);
        int contentLength = this.getContentLength(request);
        Map<String, Object> requestMap = this._isPortletRequestClass(request) ? CompositeUploadedFileProcessorImpl._getPortletRequestMap(request) : CompositeUploadedFileProcessorImpl._getServletRequestMap(request);
        Long maxMemory = (Long)requestMap.get("org.apache.myfaces.trinidad.UPLOAD_MAX_MEMORY");
        Long maxDiskSpace = (Long)requestMap.get("org.apache.myfaces.trinidad.UPLOAD_MAX_DISK_SPACE");
        String tempDir = (String)requestMap.get("org.apache.myfaces.trinidad.UPLOAD_TEMP_DIR");
        if (maxMemory != null) {
            this._maxMemory = maxMemory;
        }
        if (maxDiskSpace != null) {
            this._maxDiskSpace = maxDiskSpace;
        }
        if (tempDir != null) {
            this._tempDir = tempDir;
        }
        if ((long)contentLength > this._maxDiskSpace) {
            return new ErrorFile(_LOG.getMessage("UPLOADED_FILE_LARGE"));
        }
        UploadedFileImpl file = new UploadedFileImpl();
        try {
            file.loadFile(tempFile, this._maxMemory - info.totalBytesInMemory, this._maxDiskSpace - info.totalBytesOnDisk, this._tempDir);
        }
        catch (IOException ioe) {
            _LOG.severe((Throwable)ioe);
            return new ErrorFile(ioe.getLocalizedMessage());
        }
        long length = file.getLength();
        if (file.__isInMemory()) {
            info.totalBytesInMemory += length;
        } else {
            info.totalBytesOnDisk += length;
        }
        return file;
    }

    private int getContentLength(Object request) {
        int length = -1;
        length = this._isPortletRequestClass(request) ? CompositeUploadedFileProcessorImpl._getPortletRequestLength(request) : CompositeUploadedFileProcessorImpl._getServletRequestLength(request);
        return length;
    }

    private RequestInfo _getRequestInfo(Object request) {
        Map<String, Object> attributes = this._isPortletRequestClass(request) ? CompositeUploadedFileProcessorImpl._getPortletRequestMap(request) : CompositeUploadedFileProcessorImpl._getServletRequestMap(request);
        RequestInfo info = (RequestInfo)attributes.get(_REQUEST_INFO_KEY);
        if (info == null) {
            info = new RequestInfo();
            attributes.put(_REQUEST_INFO_KEY, info);
        }
        return info;
    }

    private boolean _isPortletRequestClass(Object request) {
        return _PORTLET_REQUEST_CLASS != null && _PORTLET_REQUEST_CLASS.isInstance(request);
    }

    private static final ContextInfo _getServletContextInfo(Object context) {
        assert (context instanceof ServletContext);
        ServletContext sContext = (ServletContext)context;
        return new ContextInfo(new ServletInitParameterMap(sContext), new ServletApplicationMap(sContext));
    }

    private static final ContextInfo _getPortletContextInfo(Object context) {
        assert (context instanceof PortletContext);
        PortletContext pContext = (PortletContext)context;
        return new ContextInfo(new PortletInitParameterMap(pContext), new PortletApplicationMap(pContext));
    }

    private static final Map<String, Object> _getServletRequestMap(Object request) {
        assert (request instanceof ServletRequest);
        return new ServletRequestMap((ServletRequest)request);
    }

    private static final Map<String, Object> _getPortletRequestMap(Object request) {
        assert (request instanceof PortletRequest);
        return new PortletRequestMap((PortletRequest)request);
    }

    private static final int _getServletRequestLength(Object request) {
        assert (request instanceof ServletRequest);
        return ((ServletRequest)request).getContentLength();
    }

    private static final int _getPortletRequestLength(Object request) {
        if (!(request instanceof ActionRequest)) {
            return -1;
        }
        return ((ActionRequest)request).getContentLength();
    }

    static {
        Class request;
        Class context;
        _REQUEST_INFO_KEY = CompositeUploadedFileProcessorImpl.class.getName() + ".UploadedFilesInfo";
        _LOG = TrinidadLogger.createTrinidadLogger(CompositeUploadedFileProcessorImpl.class);
        try {
            context = ClassLoaderUtils.loadClass((String)"javax.portlet.PortletContext");
            request = ClassLoaderUtils.loadClass((String)"javax.portlet.PortletRequest");
        }
        catch (ClassNotFoundException e) {
            _LOG.fine("Portlet API is not available on the classpath.  Portlet configurations are disabled.");
            context = null;
            request = null;
        }
        _PORTLET_CONTEXT_CLASS = context;
        _PORTLET_REQUEST_CLASS = request;
    }

    private static class ContextInfo {
        public Map<String, String> initParams;
        public Map<String, Object> attributes;

        public ContextInfo(Map<String, String> init, Map<String, Object> attrib) {
            this.initParams = init;
            this.attributes = attrib;
        }
    }

    private static class RequestInfo {
        public long totalBytesInMemory;
        public long totalBytesOnDisk;

        private RequestInfo() {
        }
    }

    private static class WrappedUploadedFileImpl
    implements UploadedFile,
    Serializable {
        private final UploadedFile original;
        private final List<UploadedFile> files;
        private static final long serialVersionUID = 1L;

        public WrappedUploadedFileImpl(UploadedFile original, List<UploadedFile> files) {
            this.original = original;
            this.files = files;
        }

        public void dispose() {
            try {
                this.original.dispose();
            }
            catch (Exception e) {
                _LOG.warning("Exception while disposing!", (Throwable)e);
            }
            if (!this.files.isEmpty()) {
                ArrayList<UploadedFile> disposed = new ArrayList<UploadedFile>();
                disposed.add(this.original);
                for (UploadedFile file : this.files) {
                    if (disposed.contains(file)) continue;
                    try {
                        file.dispose();
                    }
                    catch (Exception e) {
                        _LOG.warning("Exception while disposing!", (Throwable)e);
                    }
                    disposed.add(file);
                }
            }
        }

        public String getFilename() {
            return this.original.getFilename();
        }

        public String getContentType() {
            return this.original.getContentType();
        }

        public long getLength() {
            return this.original.getLength();
        }

        public Object getOpaqueData() {
            return this.original.getOpaqueData();
        }

        public InputStream getInputStream() throws IOException {
            return this.original.getInputStream();
        }
    }
}

