/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.ResponseStateManager;
import javax.servlet.ServletResponse;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.context.PartialPageContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.render.DialogRenderKitService;
import org.apache.myfaces.trinidad.render.ExtendedRenderKitService;
import org.apache.myfaces.trinidad.render.RenderUtils;
import org.apache.myfaces.trinidadinternal.agent.AgentUtil;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.application.StateManagerImpl;
import org.apache.myfaces.trinidadinternal.config.dispatch.DispatchResponseConfiguratorImpl;
import org.apache.myfaces.trinidadinternal.context.DialogServiceImpl;
import org.apache.myfaces.trinidadinternal.io.DebugHtmlResponseWriter;
import org.apache.myfaces.trinidadinternal.io.DebugResponseWriter;
import org.apache.myfaces.trinidadinternal.io.HtmlResponseWriter;
import org.apache.myfaces.trinidadinternal.io.IndentingResponseWriter;
import org.apache.myfaces.trinidadinternal.io.XhtmlResponseWriter;
import org.apache.myfaces.trinidadinternal.renderkit.RenderKitDecorator;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreResponseStateManager;
import org.apache.myfaces.trinidadinternal.renderkit.core.DialogRequest;
import org.apache.myfaces.trinidadinternal.renderkit.core.ppr.PartialPageContextImpl;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.renderkit.htmlBasic.HtmlCommandButtonRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.htmlBasic.HtmlCommandLinkRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.htmlBasic.HtmlFormRenderer;
import org.apache.myfaces.trinidadinternal.share.util.CaboHttpUtils;

public class CoreRenderKit
extends RenderKitDecorator
implements DialogRenderKitService,
ExtendedRenderKitService {
    public static final String OUTPUT_MODE_DEFAULT = "default";
    public static final String OUTPUT_MODE_PORTLET = "portlet";
    public static final String OUTPUT_MODE_PRINTABLE = "printable";
    public static final String OUTPUT_MODE_EMAIL = "email";
    public static final String RETURN_PARAM = "rtrn";
    public static final String BASE_RENDER_KIT_ID = "org.apache.myfaces.trinidadinternal.core";
    private ResponseStateManager _rsm = new CoreResponseStateManager();
    private static final String[] _BASIC_HTML_RENDERERS = new String[]{"javax.faces.Data", "javax.faces.Table", "javax.faces.Panel", "javax.faces.Grid", "javax.faces.Panel", "javax.faces.Group", "javax.faces.Input", "javax.faces.Hidden", "javax.faces.Input", "javax.faces.Secret", "javax.faces.Input", "javax.faces.Text", "javax.faces.Input", "javax.faces.Textarea", "javax.faces.Graphic", "javax.faces.Image", "javax.faces.Message", "javax.faces.Message", "javax.faces.Messages", "javax.faces.Messages", "javax.faces.Output", "javax.faces.Format", "javax.faces.Output", "javax.faces.Label", "javax.faces.Output", "javax.faces.Link", "javax.faces.Output", "javax.faces.Text", "javax.faces.SelectBoolean", "javax.faces.Checkbox", "javax.faces.SelectOne", "javax.faces.Listbox", "javax.faces.SelectOne", "javax.faces.Menu", "javax.faces.SelectOne", "javax.faces.Radio", "javax.faces.SelectMany", "javax.faces.Listbox", "javax.faces.SelectMany", "javax.faces.Menu", "javax.faces.SelectMany", "javax.faces.Checkbox"};
    private static final String _XHTML_MIME_TYPE = "application/xhtml+xml";
    private static final String _APPLICATION_XML_MIME_TYPE = "application/xml";
    private static final String _XML_MIME_TYPE = "text/xml";
    private static final String _HTML_MIME_TYPE = "text/html";
    private static final String _RETURN_ID = "org.apache.myfaces.trinidadinternal.renderkit.ReturnId";
    private static final String _DIALOG_LIST_KEY = "org.apache.myfaces.trinidadinternal.renderkit.DialogList";
    private static final String _SCRIPT_LIST_KEY = "org.apache.myfaces.trinidadinternal.renderkit.ScriptList";
    private static final String _PPR_REQUEST_HEADER = "Tr-XHR-Message";
    private static final String _FACES_REQUEST = "Faces-Request";
    private static final String _PARTIAL_AJAX = "partial/ajax";
    private static final String _USE_DIALOG_POPUP_INIT_PARAM = "org.apache.myfaces.trinidad.ENABLE_LIGHTWEIGHT_DIALOGS";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(CoreRenderKit.class);

    public static String getId() {
        return "org.apache.myfaces.trinidad.core";
    }

    public static String chooseRenderKit(FacesContext context) {
        Agent agent;
        RequestContext afc = RequestContext.getCurrentInstance();
        if (afc != null && Agent.TYPE_PDA.equals((agent = afc.getAgent()).getType())) {
            return "org.apache.myfaces.trinidad.core.pda";
        }
        return "org.apache.myfaces.trinidad.core.desktop";
    }

    public static boolean isLegacyAjaxRequest(ExternalContext ec) {
        return "true".equals(ec.getRequestHeaderMap().get(_PPR_REQUEST_HEADER));
    }

    public static boolean isLegacyPartialRequest(Map<String, String[]> parameters) {
        return CoreRenderKit._checkParameter(parameters, _PPR_REQUEST_HEADER, "true");
    }

    public static boolean isLegacyPartialRequest(ExternalContext ec) {
        return CoreRenderKit.isLegacyAjaxRequest(ec) || "true".equals(ec.getRequestParameterMap().get(_PPR_REQUEST_HEADER));
    }

    public static boolean isPartialRequest(Map<String, String[]> parameters) {
        if (CoreRenderKit.isLegacyPartialRequest(parameters)) {
            return true;
        }
        return CoreRenderKit._checkParameter(parameters, _FACES_REQUEST, _PARTIAL_AJAX);
    }

    public static boolean isPartialRequest(ExternalContext ec) {
        if (CoreRenderKit.isLegacyPartialRequest(ec)) {
            return true;
        }
        return CoreRenderKit._isJsf2Ajax(ec);
    }

    public CoreRenderKit() {
        this._modifyBasicHTMLRenderKit();
    }

    @Override
    protected String getDecoratedRenderKitId() {
        return "HTML_BASIC";
    }

    @Override
    protected String getRenderKitMap() {
        return "META-INF/org.apache.myfaces.trinidadinternal.core.renderkit";
    }

    public static void saveDialogPostbackValues(String returnId) {
        Map pageFlowScope = RequestContext.getCurrentInstance().getPageFlowScope();
        pageFlowScope.put(_RETURN_ID, returnId);
    }

    public boolean launchDialog(FacesContext context, UIViewRoot targetRoot, UIComponent source, Map<String, Object> processParameters, boolean useWindow, Map<String, Object> windowProperties) {
        if (!useWindow) {
            return false;
        }
        if (!this._supportsSeparateWindow(context)) {
            return false;
        }
        String sourceId = source == null ? null : source.getClientId(context);
        String formId = RenderUtils.getFormId((FacesContext)context, (UIComponent)source);
        if (windowProperties == null) {
            windowProperties = new HashMap<String, Object>();
        }
        if (source != null) {
            Map sourceAttrs = source.getAttributes();
            CoreRenderKit._copyProperty(windowProperties, "width", sourceAttrs, "windowWidth");
            CoreRenderKit._copyProperty(windowProperties, "height", sourceAttrs, "windowHeight");
        }
        Map pageFlowScope = RequestContext.getCurrentInstance().getPageFlowScope();
        if (processParameters != null) {
            pageFlowScope.putAll(processParameters);
        }
        RequestContext rc = RequestContext.getCurrentInstance();
        DialogRequest request = new DialogRequest(targetRoot, sourceId, formId, windowProperties, CoreRenderKit.usePopupForDialog(context, rc));
        this._getDialogList(context, true).add(request);
        return true;
    }

    public static boolean usePopupForDialog(FacesContext context, RequestContext rc) {
        if (rc != null && rc.getAccessibilityMode() == RequestContext.Accessibility.SCREEN_READER) {
            return false;
        }
        String usePopup = context.getExternalContext().getInitParameter(_USE_DIALOG_POPUP_INIT_PARAM);
        return "true".equalsIgnoreCase(usePopup);
    }

    public boolean returnFromDialog(FacesContext context, Object returnValue) {
        if (!this._supportsSeparateWindow(context)) {
            return false;
        }
        try {
            boolean usePopup = CoreRenderKit.usePopupForDialog(context, RequestContext.getCurrentInstance());
            Writer out = this._getHtmlWriter(context);
            if (usePopup) {
                out.write("<script>");
                out.write("parent.TrPopupDialog._returnFromDialog();");
                out.write("</script>");
            } else {
                RequestContext afC = RequestContext.getCurrentInstance();
                String returnId = (String)afC.getPageFlowScope().get(_RETURN_ID);
                if (returnId == null) {
                    throw new IllegalStateException(_LOG.getMessage("NO_RETURNID_AVAILABLE_FOR_RETURNING_FROM_DIALOG"));
                }
                out.write("<script>");
                out.write("top.close()");
                out.write("</script>");
                _LOG.fine("Returning from dialog using return ID {0}", (Object)returnId);
            }
            out.close();
            context.responseComplete();
        }
        catch (IOException ioe) {
            _LOG.warning((Throwable)ioe);
        }
        return true;
    }

    public boolean isReturning(FacesContext context, UIComponent source) {
        Map parameterMap = context.getExternalContext().getRequestParameterMap();
        Object returning = parameterMap.get(RETURN_PARAM);
        if (returning == null || "".equals(returning)) {
            return false;
        }
        String clientId = source.getClientId(context);
        return returning.equals(clientId);
    }

    public boolean shortCircuitRenderView(FacesContext context) throws IOException {
        ExternalContext ec = context.getExternalContext();
        if (CoreRenderKit.isPartialRequest(ec)) {
            Map requestMap = ec.getRequestMap();
            UIViewRoot originalRoot = (UIViewRoot)requestMap.get("org.apache.myfaces.trinidadinternal.InitialViewRoot");
            if (context.getViewRoot() != originalRoot) {
                ViewHandler vh = context.getApplication().getViewHandler();
                String viewId = context.getViewRoot().getViewId();
                String redirect = vh.getActionURL(context, viewId);
                String encodedRedirect = ec.encodeActionURL(redirect);
                ec.redirect(encodedRedirect);
                if (_LOG.isFine()) {
                    _LOG.fine("Page navigation to {0} happened during a PPR request on {1};  Apache Trinidad is forcing a redirect.", (Object[])new String[]{viewId, originalRoot.getViewId()});
                }
                return true;
            }
        }
        return false;
    }

    public boolean isStateless(FacesContext context) {
        return false;
    }

    public void addScript(FacesContext context, String script) {
        if (script == null || "".equals(script)) {
            return;
        }
        if (!script.endsWith(";")) {
            script = script + ";";
        }
        this._getScriptList(context, true).add(script);
    }

    public void encodeScripts(FacesContext context) throws IOException {
        boolean hasScript;
        List<DialogRequest> dialogList = this._getDialogList(context, false);
        boolean hasDialog = dialogList != null && !dialogList.isEmpty();
        List<String> scriptList = this._getScriptList(context, false);
        boolean bl = hasScript = scriptList != null && !scriptList.isEmpty();
        if (hasDialog || hasScript) {
            RenderingContext arc = RenderingContext.getCurrentInstance();
            if (hasDialog) {
                DialogRequest.addDependencies(context, arc);
            }
            String scriptId = "::launchScript";
            PartialPageContext ppContext = arc.getPartialPageContext();
            PartialPageContextImpl ppImpl = (PartialPageContextImpl)ppContext;
            if (ppImpl != null) {
                ppImpl.addRenderedPartialTarget(scriptId);
                ppImpl.pushRenderedPartialTarget(scriptId);
            }
            ResponseWriter out = context.getResponseWriter();
            out.startElement("script", null);
            out.writeAttribute("id", (Object)scriptId, null);
            XhtmlRenderer.renderScriptDeferAttribute(context, arc);
            if (hasDialog) {
                for (DialogRequest dialog : dialogList) {
                    dialog.renderLaunchJavascript(context, arc);
                }
            }
            if (hasScript) {
                for (String script : scriptList) {
                    out.write(script);
                }
            }
            out.endElement("script");
            if (hasDialog) {
                dialogList.clear();
            }
            if (hasScript) {
                scriptList.clear();
            }
            if (ppImpl != null) {
                ppImpl.popRenderedPartialTarget();
            }
        }
    }

    public void encodeBegin(FacesContext context) {
        new CoreRenderingContext();
        DialogServiceImpl.pinPriorState(context);
    }

    public void encodeEnd(FacesContext context) {
    }

    public void encodeFinally(FacesContext context) {
        String stateToken = StateManagerImpl.getStateToken(context);
        DialogServiceImpl.writeCurrentStateToken(context, stateToken);
        RenderingContext arc = RenderingContext.getCurrentInstance();
        if (arc != null) {
            arc.release();
        } else {
            _LOG.warning("RENDERINGCONTEXT_NOT_AVAILABLE");
        }
    }

    @Override
    public ResponseStateManager getResponseStateManager() {
        return this._rsm;
    }

    @Override
    public ResponseStream createResponseStream(final OutputStream output) {
        return new ResponseStream(){

            public void write(int b) throws IOException {
                output.write(b);
            }

            public void write(byte[] b) throws IOException {
                output.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                output.write(b, off, len);
            }

            public void flush() throws IOException {
                output.flush();
            }

            public void close() throws IOException {
                output.close();
            }
        };
    }

    @Override
    public ResponseWriter createResponseWriter(Writer writer, String contentTypeList, String characterEncoding) {
        try {
            ResponseWriter rw;
            String[] acceptedTypes;
            String contentType;
            FacesContext fContext = FacesContext.getCurrentInstance();
            if (contentTypeList == null) {
                contentTypeList = DispatchResponseConfiguratorImpl.getContentType(fContext);
            }
            if (_XHTML_MIME_TYPE.equals(contentType = this._chooseContentType(acceptedTypes = contentTypeList == null ? null : CaboHttpUtils.decodeQValueString(contentTypeList))) || _APPLICATION_XML_MIME_TYPE.equals(contentType) || _XML_MIME_TYPE.equals(contentType)) {
                rw = new XhtmlResponseWriter(writer, contentType, characterEncoding);
            } else {
                assert (_HTML_MIME_TYPE.equals(contentType));
                rw = new HtmlResponseWriter(writer, characterEncoding);
            }
            if (CoreRenderKit._isJsf2Ajax(fContext.getExternalContext())) {
                return rw;
            }
            return CoreRenderKit._addDebugResponseWriters(rw);
        }
        catch (IOException ioe) {
            _LOG.severe((Throwable)ioe);
            return null;
        }
    }

    private static ResponseWriter _addDebugResponseWriters(ResponseWriter responseWriter) {
        RequestContext requestContext = RequestContext.getCurrentInstance();
        if (requestContext.isDebugOutput()) {
            responseWriter = new IndentingResponseWriter((ResponseWriter)responseWriter);
            if (_HTML_MIME_TYPE.equals((responseWriter = new DebugResponseWriter((ResponseWriter)responseWriter)).getContentType())) {
                responseWriter = new DebugHtmlResponseWriter((ResponseWriter)responseWriter);
            }
        }
        return responseWriter;
    }

    private void _modifyBasicHTMLRenderKit() {
        this.addRenderer("javax.faces.Form", "javax.faces.Form", new HtmlFormRenderer());
        this.addRenderer("javax.faces.Command", "javax.faces.Link", new HtmlCommandLinkRenderer());
        this.addRenderer("javax.faces.Command", "javax.faces.Button", new HtmlCommandButtonRenderer());
    }

    private List<DialogRequest> _getDialogList(FacesContext context, boolean createIfNew) {
        Map requestMap = context.getExternalContext().getRequestMap();
        ArrayList l = (ArrayList)requestMap.get(_DIALOG_LIST_KEY);
        if (l == null && createIfNew) {
            l = new ArrayList();
            requestMap.put(_DIALOG_LIST_KEY, l);
        }
        return l;
    }

    private List<String> _getScriptList(FacesContext context, boolean createIfNew) {
        Map requestMap = context.getExternalContext().getRequestMap();
        ArrayList l = (ArrayList)requestMap.get(_SCRIPT_LIST_KEY);
        if (l == null && createIfNew) {
            l = new ArrayList();
            requestMap.put(_SCRIPT_LIST_KEY, l);
        }
        return l;
    }

    private boolean _supportsSeparateWindow(FacesContext context) {
        TrinidadAgent agent = AgentUtil.getAgent(context);
        return XhtmlUtils.supportsSeparateWindow(agent);
    }

    private Writer _getHtmlWriter(FacesContext context) throws IOException {
        ServletResponse response = (ServletResponse)context.getExternalContext().getResponse();
        response.setContentType(_HTML_MIME_TYPE);
        return response.getWriter();
    }

    private static <K1, K2, V> void _copyProperty(Map<K1, V> toMap, K1 toKey, Map<K2, ? extends V> fromMap, K2 fromKey) {
        V o;
        if (!toMap.containsKey(toKey) && (o = fromMap.get(fromKey)) != null) {
            toMap.put(toKey, o);
        }
    }

    private String _chooseContentType(String[] acceptedTypes) {
        if (acceptedTypes != null) {
            for (int i = 0; i < acceptedTypes.length; ++i) {
                String type = acceptedTypes[i];
                if (_HTML_MIME_TYPE.equals(type)) {
                    return _HTML_MIME_TYPE;
                }
                if (_XHTML_MIME_TYPE.equals(type)) {
                    return _XHTML_MIME_TYPE;
                }
                if (_APPLICATION_XML_MIME_TYPE.equals(type)) {
                    return _APPLICATION_XML_MIME_TYPE;
                }
                if (!_XML_MIME_TYPE.equals(type)) continue;
                return _XML_MIME_TYPE;
            }
        }
        return _HTML_MIME_TYPE;
    }

    private static boolean _checkParameter(Map<String, String[]> parameters, String name, String value) {
        String[] array = parameters.get(name);
        if (array == null || array.length != 1) {
            return false;
        }
        return value.equals(array[0]);
    }

    private static boolean _isJsf2Ajax(ExternalContext ec) {
        return _PARTIAL_AJAX.equals(ec.getRequestHeaderMap().get(_FACES_REQUEST));
    }
}

