/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.input.CoreInputListOfValues;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.ReturnEvent;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.agent.AgentUtil;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AutoSubmitUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PartialPageUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SimpleInputTextRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class SimpleInputListOfValuesRenderer
extends SimpleInputTextRenderer {
    private PropertyKey _actionExpressionKey;
    private PropertyKey _iconKey;
    private PropertyKey _searchDescKey;
    private static final String _BUTTON_PART = "b";
    private static final String _PART_PARAMETER = "part";
    private static final String _BUTTON_AND_PART_PARAMETER = "part:'b'";

    public SimpleInputListOfValuesRenderer() {
        this(CoreInputListOfValues.TYPE);
    }

    public SimpleInputListOfValuesRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._searchDescKey = type.findKey("searchDesc");
        this._iconKey = type.findKey("icon");
        this._actionExpressionKey = type.findKey("actionExpression");
    }

    @Override
    protected void decode(FacesContext facesContext, UIComponent component, FacesBean facesBean, String clientId) {
        super.decode(facesContext, component, facesBean, clientId);
        RequestContext afContext = RequestContext.getCurrentInstance();
        ReturnEvent returnEvent = afContext.getDialogService().getReturnEvent(component);
        if (returnEvent != null) {
            afContext.addPartialTarget(component);
            this.queueReturnEvent(facesContext, component, returnEvent);
        } else {
            Object part;
            Map parameterMap = facesContext.getExternalContext().getRequestParameterMap();
            Object source = parameterMap.get("source");
            String string = clientId = clientId == null ? component.getClientId(facesContext) : clientId;
            if (source != null && source.equals(clientId) && _BUTTON_PART.equals(part = parameterMap.get(_PART_PARAMETER))) {
                TrinidadAgent agent = AgentUtil.getAgent(facesContext);
                if (XhtmlUtils.supportsSeparateWindow(agent)) {
                    PartialPageUtils.forcePartialRendering(facesContext);
                }
                this.queueActionEvent(facesContext, component);
            }
        }
    }

    protected void queueReturnEvent(FacesContext context, UIComponent component, ReturnEvent event) {
        event.queue();
    }

    protected void queueActionEvent(FacesContext context, UIComponent component) {
        new ActionEvent(component).queue();
    }

    @Override
    protected void encodeAllAsElement(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        boolean simple = this.getSimple(component, bean);
        if (simple) {
            rw.startElement("span", component);
            this.renderRootDomElementStyles(context, rc, component, bean);
        }
        this.renderTextField(context, rc, component, bean);
        this.renderAfterTextField(context, rc, component, bean);
        if (simple) {
            rw.endElement("span");
        }
    }

    @Override
    protected void encodeAllAsNonElement(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        boolean simple = this.getSimple(component, bean);
        if (simple) {
            rw.startElement("span", component);
            this.renderRootDomElementStyles(context, rc, component, bean);
        }
        super.encodeAllAsNonElement(context, rc, component, bean);
        if (simple) {
            rw.endElement("span");
        }
    }

    @Override
    protected boolean isSimpleInputText(UIComponent component, FacesBean bean) {
        return false;
    }

    protected void renderTextField(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        super.encodeAllAsElement(context, rc, component, bean);
    }

    protected void renderAfterTextField(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        if (!this.getDisabled(component, bean)) {
            this.renderSpacer(context, rc, "8", "1");
            this.renderIcon(context, rc, component, bean);
        }
    }

    protected void renderIcon(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        Icon icon;
        String iconUri = this.getIcon(component, bean);
        if (iconUri == null) {
            icon = rc.getIcon(this.getButtonIconName());
            if (icon == null || icon.isNull()) {
                return;
            }
        } else {
            icon = null;
        }
        String onclick = this.getLaunchOnclick(context, rc, component, bean);
        String buttonOnclick = this.getButtonOnclick(component, bean);
        if (buttonOnclick != null) {
            onclick = XhtmlUtils.getChainedJS(buttonOnclick, onclick, true);
        }
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("a", component);
        rw.writeURIAttribute("href", (Object)"#", null);
        rw.writeAttribute("onclick", (Object)onclick, null);
        String align = OutputUtils.getMiddleIconAlignment(rc);
        String title = this.getSearchDesc(component, bean);
        if (iconUri != null) {
            rw.startElement("img", null);
            rw.writeAttribute("border", (Object)"0", null);
            this.renderEncodedResourceURI(context, "src", iconUri);
            OutputUtils.renderAltAndTooltipForImage(context, rc, title);
            rw.writeAttribute("align", (Object)align, null);
            rw.endElement("img");
        } else {
            OutputUtils.renderIcon(context, rc, icon, title, align);
        }
        rw.endElement("a");
    }

    protected String getButtonIconName() {
        return "af|inputListOfValues::button-icon";
    }

    protected String getButtonOnclick(UIComponent component, FacesBean bean) {
        return super.getOnclick(component, bean);
    }

    protected String getLaunchOnclick(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        FormData fd = rc.getFormData();
        if (fd == null) {
            return null;
        }
        fd.addNeededValue(_PART_PARAMETER);
        fd.addNeededValue("source");
        if (SimpleInputListOfValuesRenderer.supportsSeparateWindow(rc)) {
            AutoSubmitUtils.writeDependencies(context, rc);
            return AutoSubmitUtils.getSubmitScript(rc, this.getClientId(context, component), true, false, null, _BUTTON_AND_PART_PARAMETER, false);
        }
        return AutoSubmitUtils.getFullPageSubmitScript(rc, this.getClientId(context, component), true, null, _BUTTON_AND_PART_PARAMETER, false);
    }

    @Override
    public boolean isTextArea(UIComponent component, FacesBean bean) {
        return false;
    }

    @Override
    protected boolean getSecret(UIComponent component, FacesBean bean) {
        return false;
    }

    @Override
    protected String getOnclick(UIComponent component, FacesBean bean) {
        if (this.shouldRenderInputOnclick()) {
            return null;
        }
        return super.getOnclick(component, bean);
    }

    protected boolean shouldRenderInputOnclick() {
        return true;
    }

    protected Object getActionExpression(UIComponent component, FacesBean bean) {
        return bean.getProperty(this._actionExpressionKey);
    }

    protected String getSearchDesc(UIComponent component, FacesBean bean) {
        return SimpleInputListOfValuesRenderer.toString((Object)bean.getProperty(this._searchDescKey));
    }

    protected String getIcon(UIComponent component, FacesBean bean) {
        if (this._iconKey == null) {
            return null;
        }
        return SimpleInputListOfValuesRenderer.toResourceUri((FacesContext)FacesContext.getCurrentInstance(), (Object)bean.getProperty(this._iconKey));
    }

    @Override
    protected String getRootStyleClass(UIComponent component, FacesBean bean) {
        return "af|inputListOfValues";
    }

    @Override
    protected String getContentStyleClass(UIComponent component, FacesBean bean) {
        return "af|inputListOfValues::content";
    }
}

