require 'jruby/rack'

module JRuby
  module Rack
    class RailsGrizzlyHelper < GrizzlyHelper
      attr_accessor :rails_env, :rails_root

      def initialize(grizzly_context = nil)
        super
        @rails_root = @grizzly_context.rails_root
        @rails_env = @grizzly_context.rails_env
        ENV['RAILS_ROOT'] = @rails_root
        ENV['RAILS_ENV'] = @rails_env
        silence_warnings { Object.const_set("PUBLIC_ROOT", public_root) }
      end

      def load_environment
        require 'dispatcher'
        setup_logger
      end

      def setup_logger
        if defined?(::RAILS_DEFAULT_LOGGER)
          class << ::RAILS_DEFAULT_LOGGER # Make these accessible to wire in the log device
            public :instance_variable_get, :instance_variable_set
          end
          if defined?(ActiveSupport::BufferedLogger) # Rails 2.x
            old_device = ::RAILS_DEFAULT_LOGGER.instance_variable_get "@log"
            old_device.close rescue nil
            ::RAILS_DEFAULT_LOGGER.instance_variable_set "@log", logdev
          else # Rails 1.x
            old_device = ::RAILS_DEFAULT_LOGGER.instance_variable_get "@logdev"
            old_device.close rescue nil
            ::RAILS_DEFAULT_LOGGER.instance_variable_set "@logdev", Logger::LogDevice.new(logdev)
          end
        end
      end

      def session_options
        @session_options ||= SESSION_OPTIONS
      end

      def session_options_for_request(env)
        options = session_options.dup
        options
      end

      def options
        {:public => public_root, :root => rails_root, :environment => rails_env}
      end

      def silence_warnings
        oldv, $VERBOSE = $VERBOSE, nil
        begin
          yield
        ensure
          $VERBOSE = oldv
        end
      end
    end

    class RailsSetup
      def initialize(app, grizzly_helper)
        @app = app
        @grizzly_helper = grizzly_helper
      end

      def call(env)
        @app.call(env)
      end
    end

    class RailsFactory
      def self.new
        helper = RailsGrizzlyHelper.instance
        helper.load_environment
        ::Rack::Builder.new {
          use RailsSetup, helper
          run ::Rack::Adapter::Rails.new(helper.options)
        }.to_app
      end
    end
  end
end
