/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.extras.osgicontainer;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.common_impl.DefaultModuleDefinition;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Manifest;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.glassfish.internal.deployment.GenericHandler;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PreDestroy;

@Service(name="osgi")
public class OSGiArchiveHandler
extends GenericHandler {
    @Inject
    ModulesRegistry mr;

    public String getArchiveType() {
        return "osgi";
    }

    public boolean handles(ReadableArchive archive) throws IOException {
        Manifest manifest = this.getManifest(archive);
        return manifest != null && manifest.getMainAttributes().getValue("Bundle-Name") != null;
    }

    public ClassLoader getClassLoader(ClassLoader parent, DeploymentContext context) {
        DefaultModuleDefinition moduleDef = null;
        try {
            moduleDef = new DefaultModuleDefinition(context.getSourceDir(), null);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        context.getAppProps().put("module-name", moduleDef.getName());
        final Module module = this.mr.add((ModuleDefinition)moduleDef);
        ArrayList<ProtectedClassLoader> finders = new ArrayList<ProtectedClassLoader>();
        finders.add(new ProtectedClassLoader(parent, module.getClassLoader()));
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ProtectedDelegatingCL
        extends DelegatingClassLoader
        implements PreDestroy {
            public ProtectedDelegatingCL(ClassLoader parent, List<DelegatingClassLoader.ClassFinder> delegates) throws IllegalArgumentException {
                super(parent, delegates);
            }

            public void preDestroy() {
                module.stop();
            }
        }
        return new ProtectedDelegatingCL(parent, finders);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProtectedClassLoader
    implements DelegatingClassLoader.ClassFinder {
        final ClassLoader parent;
        final ClassLoader delegate;

        public ProtectedClassLoader(ClassLoader parent, ClassLoader delegate) {
            this.parent = parent;
            this.delegate = delegate;
        }

        public ClassLoader getParent() {
            return this.parent;
        }

        public Class<?> findClass(String name) throws ClassNotFoundException {
            return this.delegate.loadClass(name);
        }

        public Class<?> findExistingClass(String name) {
            try {
                return this.delegate.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public URL findResource(String name) {
            return this.delegate.getResource(name);
        }

        public Enumeration<URL> findResources(String name) throws IOException {
            return this.delegate.getResources(name);
        }
    }
}

