/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.extras.osgicontainer;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.common_impl.DefaultModuleDefinition;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Manifest;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.extras.osgicontainer.RefCountingClassLoader;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.glassfish.internal.deployment.GenericHandler;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service(name="osgi")
@Scoped(value=Singleton.class)
public class OSGiArchiveHandler
extends GenericHandler {
    @Inject
    ModulesRegistry mr;
    private Map<Module, WeakReference<RefCountingClassLoader>> loaders = new HashMap<Module, WeakReference<RefCountingClassLoader>>();

    public String getArchiveType() {
        return "osgi";
    }

    public boolean handles(ReadableArchive archive) throws IOException {
        Manifest manifest = this.getManifest(archive);
        return manifest != null && manifest.getMainAttributes().getValue("Bundle-Name") != null;
    }

    public synchronized RefCountingClassLoader getClassLoader(ClassLoader parent, Module m) {
        WeakReference<RefCountingClassLoader> ref = this.loaders.get(m);
        if (ref != null && ref.get() != null) {
            RefCountingClassLoader loader = (RefCountingClassLoader)((Object)ref.get());
            loader.increment();
            return loader;
        }
        RefCountingClassLoader cl = new RefCountingClassLoader(parent, m);
        ref = new WeakReference<RefCountingClassLoader>(cl);
        this.loaders.put(m, ref);
        cl.increment();
        return cl;
    }

    public ClassLoader getClassLoader(ClassLoader parent, DeploymentContext context) {
        DefaultModuleDefinition moduleDef = null;
        try {
            moduleDef = new DefaultModuleDefinition(context.getSourceDir(), null);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        context.getAppProps().put("module-name", moduleDef.getName());
        Module module = this.mr.add((ModuleDefinition)moduleDef);
        return this.getClassLoader(parent, module);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProtectedClassLoader
    implements DelegatingClassLoader.ClassFinder {
        final ClassLoader parent;
        final ClassLoader delegate;

        public ProtectedClassLoader(ClassLoader parent, ClassLoader delegate) {
            this.parent = parent;
            this.delegate = delegate;
        }

        public ClassLoader getParent() {
            return this.parent;
        }

        public Class<?> findClass(String name) throws ClassNotFoundException {
            return this.delegate.loadClass(name);
        }

        public Class<?> findExistingClass(String name) {
            try {
                return this.delegate.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public URL findResource(String name) {
            return this.delegate.getResource(name);
        }

        public Enumeration<URL> findResources(String name) throws IOException {
            return this.delegate.getResources(name);
        }
    }
}

