/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgihttp;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.osgi.service.http.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiServletContext
implements ServletContext {
    private final ServletContext delegate;
    private final HttpContext httpContext;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    public OSGiServletContext(ServletContext delegate, HttpContext httpContext) {
        this.delegate = delegate;
        this.httpContext = httpContext;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getContextPath() {
        return this.delegate.getContextPath();
    }

    public ServletContext getContext(String uri) {
        return this.delegate.getContext(uri);
    }

    public String getInitParameter(String name) {
        return this.delegate.getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return this.delegate.getInitParameterNames();
    }

    public int getMajorVersion() {
        return this.delegate.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.delegate.getMinorVersion();
    }

    public int getEffectiveMajorVersion() {
        return this.delegate.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.delegate.getEffectiveMinorVersion();
    }

    public String getMimeType(String file) {
        String mimeType = this.httpContext.getMimeType(file);
        return mimeType != null ? mimeType : this.delegate.getMimeType(file);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.delegate.getNamedDispatcher(name);
    }

    public String getRealPath(String path) {
        return this.delegate.getRealPath(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.delegate.getRequestDispatcher(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.httpContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        try {
            URL url = this.getResource(path);
            return url != null ? url.openStream() : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Set getResourcePaths(String path) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public String getServerInfo() {
        return this.delegate.getServerInfo();
    }

    public Servlet getServlet(String name) throws ServletException {
        return this.delegate.getServlet(name);
    }

    public String getServletContextName() {
        return this.delegate.getServletContextName();
    }

    public Enumeration getServletNames() {
        return this.delegate.getServletNames();
    }

    public Enumeration getServlets() {
        return this.delegate.getServlets();
    }

    public void log(String message) {
        this.delegate.log(message);
    }

    public void log(Exception exception, String message) {
        this.delegate.log(exception, message);
    }

    public void log(String message, Throwable throwable) {
        this.delegate.log(message, throwable);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        throw new UnsupportedOperationException();
    }

    public void addServletMapping(String servletName, String[] urlPatterns) {
        throw new UnsupportedOperationException();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        throw new UnsupportedOperationException();
    }

    public void addFilterMappingForServletNames(String filterName, EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... servletNames) {
        throw new UnsupportedOperationException();
    }

    public void addFilterMappingForUrlPatterns(String filterName, EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... urlPatterns) {
        throw new UnsupportedOperationException();
    }

    public void setSessionCookieConfig(SessionCookieConfig sessionCookieConfig) {
        throw new UnsupportedOperationException();
    }

    public SessionCookieConfig getSessionCookieConfig() {
        throw new UnsupportedOperationException();
    }

    public void setSessionTrackingModes(EnumSet<SessionTrackingMode> sessionTrackingModes) {
        throw new UnsupportedOperationException();
    }

    public EnumSet<SessionTrackingMode> getDefaultSessionTrackingModes() {
        throw new UnsupportedOperationException();
    }

    public EnumSet<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        throw new UnsupportedOperationException();
    }

    public boolean setInitParameter(String name, String value) {
        return this.delegate.setInitParameter(name, value);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        return null;
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return null;
    }

    public Map<String, ServletRegistration> getServletRegistrations() {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return null;
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return null;
    }

    public Map<String, FilterRegistration> getFilterRegistrations() {
        return null;
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        return null;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
    }

    public <T extends Servlet> T createServlet(Class<T> c) throws ServletException {
        return null;
    }

    public <T extends Filter> T createFilter(Class<T> c) throws ServletException {
        return null;
    }

    public void addListener(String className) {
    }

    public <T extends EventListener> void addListener(T t) {
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
    }

    public <T extends EventListener> T createListener(Class<T> c) throws ServletException {
        return null;
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.delegate.getJspConfigDescriptor();
    }

    public ClassLoader getClassLoader() {
        return this.delegate.getClassLoader();
    }

    public void declareRoles(String ... roleNames) {
        this.delegate.declareRoles(roleNames);
    }
}

