/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgihttp;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.WebModuleConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.ContextConfig;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.Globals;
import org.glassfish.osgihttp.GlassFishHttpService;
import org.glassfish.osgihttp.HttpServiceWrapper;
import org.glassfish.osgihttp.OSGiHttpContextValve;
import org.glassfish.web.valve.GlassFishValve;
import org.jvnet.hk2.component.Habitat;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private BundleContext bctx;
    private Map<String, Host> vss = new HashMap<String, Host>();
    private String contextPath;
    private List<ServiceRegistration> registrations = new ArrayList<ServiceRegistration>();
    private static final String CONTEXT_PATH_PROP = Activator.class.getPackage().getName() + ".ContextPath";
    private ServiceTracker serverTracker;
    private WebModule standardContext;
    private Logger logger = Logger.getLogger(this.getClass().getPackage().getName());

    public void start(BundleContext context) throws Exception {
        this.bctx = context;
        this.serverTracker = new GlassFishServerTracker(this.bctx);
        this.serverTracker.open();
    }

    private void doActualWork(WebContainer webContainer) {
        String defaultVsId = this.getDefaultVirtualServer();
        StringTokenizer vsIds = new StringTokenizer(this.getAllVirtualServers(), ",");
        while (vsIds.hasMoreTokens()) {
            String vsId = vsIds.nextToken().trim();
            try {
                this.createRootWebModule(webContainer, vsId);
                if (this.standardContext == null) {
                    this.logger.logp(Level.WARNING, "Activator", "doActualWork", "GlassFishHttpService will not be available for for virtual server = {0}, because we are not able to create root web app.", new Object[]{vsId});
                    continue;
                }
                GlassFishHttpService httpService = new GlassFishHttpService(this.standardContext);
                Properties props = new Properties();
                props.put("VirtualServer", vsId);
                if (vsId.equals(defaultVsId)) {
                    props.put("service.ranking", (Object)Integer.MAX_VALUE);
                }
                ServiceRegistration registration = this.bctx.registerService(org.osgi.service.http.HttpService.class.getName(), (Object)new HttpServiceWrapper.HttpServiceFactory(httpService), (Dictionary)props);
                this.registrations.add(registration);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void createRootWebModule(WebContainer webContainer, String vsId) throws Exception {
        Engine engine = webContainer.getEngine();
        Host vs = (Host)engine.findChild(vsId);
        if (vs == null) {
            return;
        }
        this.vss.put(vsId, vs);
        this.contextPath = this.bctx.getProperty(CONTEXT_PATH_PROP);
        if (this.contextPath == null) {
            this.contextPath = "/osgi";
        }
        this.standardContext = new WebModule();
        this.standardContext.setWebContainer(webContainer);
        this.standardContext.setName(this.contextPath);
        this.standardContext.setPath(this.contextPath);
        this.standardContext.setDocBase(System.getProperty("java.io.tmpdir"));
        this.standardContext.setWorkDir(System.getProperty("java.io.tmpdir"));
        this.standardContext.setJ2EEServer(this.getInstanceName());
        this.standardContext.addLifecycleListener((LifecycleListener)new ContextConfig());
        Realm realm = (Realm)Globals.getDefaultHabitat().getByContract(Realm.class);
        this.standardContext.setRealm(realm);
        WebModuleConfig wmConfig = new WebModuleConfig();
        wmConfig.setWorkDirBase(System.getProperty("java.io.tmpdir"));
        wmConfig.setVirtualServers(vsId);
        this.standardContext.setParentClassLoader(this.getCommonClassLoader());
        this.standardContext.setWebModuleConfig(wmConfig);
        this.standardContext.addValve((GlassFishValve)new OSGiHttpContextValve());
        this.switchOffSessionPersistence((StandardContext)this.standardContext);
        vs.addChild((Container)this.standardContext);
        this.logger.logp(Level.INFO, "Activator", "createRootWebModule", "standardContext = {0}", new Object[]{this.standardContext});
    }

    private ClassLoader getCommonClassLoader() {
        ClassLoaderHierarchy clh = (ClassLoaderHierarchy)Globals.getDefaultHabitat().getComponent(ClassLoaderHierarchy.class);
        return clh.getAPIClassLoader();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.serverTracker != null) {
            this.serverTracker.close();
        }
        for (ServiceRegistration registration : this.registrations) {
            registration.unregister();
        }
        for (Host vs : this.vss.values()) {
            StandardContext standardContext = (StandardContext)StandardContext.class.cast(vs.findChild(this.contextPath));
            for (Container child : standardContext.findChildren()) {
                standardContext.removeChild(child);
            }
            vs.removeChild((Container)standardContext);
        }
    }

    private void switchOffSessionPersistence(StandardContext ctx) {
        Manager mgr = ctx.getManager();
        if (mgr == null) {
            mgr = new StandardManager();
            ((StandardManager)StandardManager.class.cast(mgr)).setPathname(null);
            ctx.setManager(mgr);
        } else {
            try {
                ((StandardManager)StandardManager.class.cast(mgr)).setPathname(null);
            }
            catch (ClassCastException cce) {
                this.logger.logp(Level.INFO, "Activator", "switchOffSessionPersistence", "SessionManager {0} does not allow path name of session store to be configured.", new Object[]{mgr});
            }
        }
    }

    private String getAllVirtualServers() {
        List hosts;
        HttpService httpService;
        Config config;
        String target;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Domain domain = (Domain)Globals.get(Domain.class);
        Server server = domain.getServerNamed(target = this.getInstanceName());
        if (server != null && (config = server.getConfig()) != null && (httpService = config.getHttpService()) != null && (hosts = httpService.getVirtualServer()) != null) {
            for (VirtualServer host : hosts) {
                if (first) {
                    sb.append(host.getId());
                    first = false;
                    continue;
                }
                sb.append(",");
                sb.append(host.getId());
            }
        }
        return sb.toString();
    }

    private String getInstanceName() {
        ServerEnvironment se = (ServerEnvironment)Globals.get(ServerEnvironment.class);
        String target = se.getInstanceName();
        return target;
    }

    private String getDefaultVirtualServer() {
        Class<?> netWorkListenerClass;
        try {
            netWorkListenerClass = Class.forName("com.sun.grizzly.config.dom.NetworkListener");
        }
        catch (ClassNotFoundException cnfe) {
            try {
                netWorkListenerClass = Class.forName("org.glassfish.grizzly.config.dom.NetworkListener");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        Object networkListenerObj = Globals.get(netWorkListenerClass);
        try {
            Method findHttpProtocolMethod = netWorkListenerClass.getMethod("findHttpProtocol", new Class[0]);
            Object httpProtocolObj = findHttpProtocolMethod.invoke(networkListenerObj, new Object[0]);
            Object httpObj = httpProtocolObj.getClass().getMethod("getHttp", new Class[0]).invoke(httpProtocolObj, new Object[0]);
            String defaultVirtualServer = (String)httpObj.getClass().getMethod("getDefaultVirtualServer", new Class[0]).invoke(httpObj, new Object[0]);
            this.logger.logp(Level.INFO, "Activator", "getDefaultVirtualServer", "defaultVirtualServer = {0}", new Object[]{defaultVirtualServer});
            return defaultVirtualServer;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private class GlassFishServerTracker
    extends ServiceTracker {
        public GlassFishServerTracker(BundleContext context) {
            super(context, Habitat.class.getName(), null);
        }

        public Object addingService(ServiceReference reference) {
            ServiceReference habitatServiceRef = this.context.getServiceReference(Habitat.class.getName());
            final Habitat habitat = (Habitat)Habitat.class.cast(this.context.getService(habitatServiceRef));
            Events events = (Events)habitat.getComponent(Events.class);
            EventListener listener = new EventListener(){

                public void event(EventListener.Event event) {
                    if (EventTypes.SERVER_READY.equals((Object)event.type())) {
                        WebContainer wc = (WebContainer)habitat.getComponent(WebContainer.class);
                        Activator.this.doActualWork(wc);
                    }
                }
            };
            events.register(listener);
            if (((ServerEnvironment)habitat.getComponent(ServerEnvironment.class)).getStatus() == ServerEnvironment.Status.started) {
                WebContainer wc = (WebContainer)habitat.getComponent(WebContainer.class);
                Activator.this.doActualWork(wc);
            }
            this.close();
            return super.addingService(reference);
        }
    }
}

