/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijavaeebase;

import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.osgijavaeebase.OSGiApplicationInfo;
import org.glassfish.osgijavaeebase.OSGiDeploymentContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.osgi.framework.Bundle;

public abstract class OSGiUndeploymentRequest {
    private static final Logger logger = Logger.getLogger(OSGiUndeploymentRequest.class.getPackage().getName());
    private Deployment deployer;
    private ServerEnvironmentImpl env;
    private ActionReport reporter;
    private OSGiApplicationInfo osgiAppInfo;

    public OSGiUndeploymentRequest(Deployment deployer, ServerEnvironmentImpl env, ActionReport reporter, OSGiApplicationInfo osgiAppInfo) {
        this.deployer = deployer;
        this.env = env;
        this.reporter = reporter;
        this.osgiAppInfo = osgiAppInfo;
    }

    protected void preUndeploy() {
    }

    protected void postUndeploy() {
    }

    public void execute() {
        OSGiDeploymentContext dc;
        this.preUndeploy();
        try {
            dc = this.getDeploymentContextImpl(this.reporter, logger, this.osgiAppInfo.getAppInfo().getSource(), this.getUndeployParams(this.osgiAppInfo), this.env, this.osgiAppInfo.getBundle());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ApplicationInfo appInfo = this.osgiAppInfo.getAppInfo();
        appInfo.stop((ExtendedDeploymentContext)dc, logger);
        appInfo.unload((ExtendedDeploymentContext)dc);
        this.deployer.undeploy(appInfo.getName(), (ExtendedDeploymentContext)dc);
        if (!this.osgiAppInfo.isDirectoryDeployment()) {
            this.cleanup(dc.getSourceDir());
        }
        this.postUndeploy();
    }

    protected abstract OSGiDeploymentContext getDeploymentContextImpl(ActionReport var1, Logger var2, ReadableArchive var3, UndeployCommandParameters var4, ServerEnvironmentImpl var5, Bundle var6) throws Exception;

    private void cleanup(File dir) {
        assert (dir.isDirectory() && dir.exists());
        FileUtils.whack((File)dir);
        logger.logp(Level.INFO, "OSGiUndeploymentRequest", "cleanup", "Deleted {0}", new Object[]{dir});
    }

    protected UndeployCommandParameters getUndeployParams(OSGiApplicationInfo osgiAppInfo) {
        UndeployCommandParameters parameters = new UndeployCommandParameters();
        parameters.name = osgiAppInfo.getAppInfo().getName();
        parameters.origin = OpsParams.Origin.undeploy;
        return parameters;
    }

    protected OSGiApplicationInfo getOsgiAppInfo() {
        return this.osgiAppInfo;
    }
}

