/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijavaeebase;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.osgijavaeebase.DeploymentException;
import org.glassfish.osgijavaeebase.OSGiApplicationInfo;
import org.glassfish.osgijavaeebase.OSGiArchiveHandler;
import org.glassfish.osgijavaeebase.OSGiBundleArchive;
import org.glassfish.osgijavaeebase.OSGiDeploymentContext;
import org.glassfish.osgijavaeebase.OSGiUndeploymentRequest;
import org.glassfish.server.ServerEnvironmentImpl;
import org.osgi.framework.Bundle;

public abstract class OSGiDeploymentRequest {
    private static final Logger logger = Logger.getLogger(OSGiUndeploymentRequest.class.getPackage().getName());
    private ActionReport reporter;
    private Bundle b;
    private boolean dirDeployment;
    private Deployment deployer;
    private ArchiveFactory archiveFactory;
    private ServerEnvironmentImpl env;
    private ReadableArchive archive;
    private OSGiDeploymentContext dc;
    private OSGiApplicationInfo result;

    public OSGiDeploymentRequest(Deployment deployer, ArchiveFactory archiveFactory, ServerEnvironmentImpl env, ActionReport reporter, Bundle b) {
        this.deployer = deployer;
        this.archiveFactory = archiveFactory;
        this.env = env;
        this.reporter = reporter;
        this.b = b;
    }

    protected void preDeploy() throws DeploymentException {
    }

    protected void postDeploy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSGiApplicationInfo execute() {
        try {
            this.preDeploy();
        }
        catch (DeploymentException e) {
            this.reporter.failure(logger, "Failed while deploying bundle " + this.b, (Throwable)e);
            return this.result;
        }
        try {
            this.prepare();
            this.result = this.deploy();
        }
        catch (Exception e) {
            this.reporter.failure(logger, "Failed while deploying bundle " + this.b, (Throwable)e);
        }
        finally {
            this.postDeploy();
        }
        return this.result;
    }

    private void prepare() throws Exception {
        this.archive = this.makeArchive();
        DeployCommandParameters opsParams = this.getDeployParams();
        this.expandIfNeeded();
        this.dc = this.getDeploymentContextImpl(this.reporter, logger, this.archive, (OpsParams)opsParams, this.env, this.b);
    }

    protected ReadableArchive makeArchive() {
        return new OSGiBundleArchive(this.b);
    }

    protected abstract OSGiDeploymentContext getDeploymentContextImpl(ActionReport var1, Logger var2, ReadableArchive var3, OpsParams var4, ServerEnvironmentImpl var5, Bundle var6) throws Exception;

    private OSGiApplicationInfo deploy() {
        block11: {
            OSGiApplicationInfo oSGiApplicationInfo;
            block12: {
                ApplicationInfo appInfo = null;
                try {
                    appInfo = this.deployer.deploy((ExtendedDeploymentContext)this.dc);
                    if (appInfo == null) break block11;
                    oSGiApplicationInfo = new OSGiApplicationInfo(appInfo, this.dirDeployment, this.b, this.dc.getFinalClassLoader());
                    Object var4_3 = null;
                    if (this.dirDeployment || appInfo != null) break block12;
                }
                catch (Throwable throwable) {
                    block13: {
                        Object var4_4 = null;
                        if (this.dirDeployment || appInfo != null) break block13;
                        try {
                            File dir = this.dc.getSourceDir();
                            assert (dir.isDirectory());
                            if (FileUtils.whack((File)dir)) {
                                logger.logp(Level.INFO, "OSGiDeploymentRequest", "deploy", "Deleted {0}", new Object[]{dir});
                                break block13;
                            }
                            logger.logp(Level.WARNING, "OSGiDeploymentRequest", "deploy", "Unable to delete {0} ", new Object[]{dir});
                        }
                        catch (Exception e2) {
                            logger.logp(Level.WARNING, "OSGiDeploymentRequest", "deploy", "Exception while cleaning up target directory.", e2);
                        }
                    }
                    throw throwable;
                }
                try {
                    File dir = this.dc.getSourceDir();
                    assert (dir.isDirectory());
                    if (FileUtils.whack((File)dir)) {
                        logger.logp(Level.INFO, "OSGiDeploymentRequest", "deploy", "Deleted {0}", new Object[]{dir});
                    } else {
                        logger.logp(Level.WARNING, "OSGiDeploymentRequest", "deploy", "Unable to delete {0} ", new Object[]{dir});
                    }
                }
                catch (Exception e2) {
                    logger.logp(Level.WARNING, "OSGiDeploymentRequest", "deploy", "Exception while cleaning up target directory.", e2);
                }
            }
            return oSGiApplicationInfo;
        }
        logger.logp(Level.FINE, "OSGiDeploymentRequest", "deploy", "failed to deploy {0} for following reason: {1} ", new Object[]{this.b, this.reporter.getMessage()});
        throw new RuntimeException("Failed to deploy bundle [ " + this.b + " ], root cause: " + this.reporter.getMessage(), this.reporter.getFailureCause());
    }

    private void expandIfNeeded() throws IOException {
        File file = OSGiDeploymentRequest.makeFile(this.archive);
        boolean bl = this.dirDeployment = file != null && file.isDirectory();
        if (this.dirDeployment) {
            logger.logp(Level.FINE, "OSGiDeploymentRequest", "expandIfNeeded", "Archive is already expanded at = {0}", new Object[]{file});
            this.archive = this.archiveFactory.openArchive(file);
            return;
        }
        File tmpFile = File.createTempFile("osgiapp", "");
        if (!tmpFile.delete()) {
            throw new IOException("Not able to expand " + this.archive.getName() + " in " + tmpFile);
        }
        tmpFile = new File(tmpFile.getAbsolutePath());
        tmpFile.deleteOnExit();
        if (!tmpFile.mkdirs()) {
            throw new IOException("Not able to expand " + this.archive.getName() + " in " + tmpFile);
        }
        WritableArchive targetArchive = this.archiveFactory.createArchive(tmpFile);
        new OSGiArchiveHandler().expand(this.archive, targetArchive, (DeploymentContext)this.dc);
        logger.logp(Level.INFO, "OSGiDeploymentRequest", "expand", "Expanded at {0}", new Object[]{targetArchive.getURI()});
        this.archive = this.archiveFactory.openArchive(tmpFile);
    }

    public static File makeFile(ReadableArchive a) {
        try {
            return new File(a.getURI());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected DeployCommandParameters getDeployParams() throws Exception {
        assert (this.archive != null);
        DeployCommandParameters parameters = new DeployCommandParameters();
        parameters.name = this.archive.getName();
        parameters.enabled = Boolean.TRUE;
        parameters.origin = OpsParams.Origin.deploy;
        parameters.force = false;
        parameters.target = this.getInstanceName();
        return parameters;
    }

    public Bundle getBundle() {
        return this.b;
    }

    public ReadableArchive getArchive() {
        return this.archive;
    }

    public OSGiApplicationInfo getResult() {
        return this.result;
    }

    private String getInstanceName() {
        ServerEnvironment se = (ServerEnvironment)Globals.get(ServerEnvironment.class);
        String target = se.getInstanceName();
        return target;
    }
}

