/*
 * Copyright (c) 2010, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package org.glassfish.osgijpa.extension;

import org.glassfish.api.Startup;
import org.jvnet.hk2.annotations.Service;

/**
 * This is a dummy startup service. This is only present to ensure that jpa-connector bundle is activated when
 * server starts up so that jpa-connector bundle's activator can do some initialisation that's only needed in
 * OSGi environment.
 *
 * @see OSGiJPAExtnBundleActivator
 * 
 * @author Sanjeeb.Sahoo@Sun.COM
 */
@Service
public class JPAStartupService implements Startup
{
    public Lifecycle getLifecycle() {
        return Lifecycle.START;
    }
}
