/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiweb;

import com.sun.enterprise.module.common_impl.CompositeEnumeration;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.naming.directory.DirContext;
import org.apache.naming.resources.FileDirContext;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.Globals;
import org.glassfish.osgijavaeebase.BundleClassLoader;
import org.glassfish.osgijavaeebase.OSGiArchiveHandler;
import org.glassfish.osgijavaeebase.OSGiDeploymentContext;
import org.glassfish.osgiweb.OSGiFaceletConfigResourceProvider;
import org.glassfish.osgiweb.OSGiFacesAnnotationScanner;
import org.glassfish.osgiweb.OSGiFacesConfigResourceProvider;
import org.glassfish.web.loader.ResourceEntry;
import org.glassfish.web.loader.WebappClassLoader;
import org.osgi.framework.Bundle;

class OSGiWebDeploymentContext
extends OSGiDeploymentContext {
    private static final Logger logger = Logger.getLogger(OSGiWebDeploymentContext.class.getPackage().getName());
    private static Map<String, String> hiddenServicesMap;
    private static Collection<String> hiddenServices;

    public OSGiWebDeploymentContext(ActionReport actionReport, Logger logger, ReadableArchive source, OpsParams params, ServerEnvironment env, Bundle bundle) throws Exception {
        super(actionReport, logger, source, params, env, bundle);
        this.setArchiveHandler((ArchiveHandler)new OSGiArchiveHandler(){

            public List<URI> getClassPathURIs(ReadableArchive archive) {
                final ArrayList<URI> uris = new ArrayList<URI>();
                File base = OSGiWebDeploymentContext.this.getSourceDir();
                assert (base != null && base.isDirectory());
                uris.add(new File(base, "WEB-INF/classes/").toURI());
                new File(base, "WEB-INF/lib/").listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        if (pathname.isFile() && pathname.getName().endsWith(".jar")) {
                            uris.add(pathname.toURI());
                        }
                        return false;
                    }
                });
                logger.logp(Level.INFO, "OSGiWebDeploymentContext", "getClassPathURIs", "uris = {0}", new Object[]{uris});
                return uris;
            }

            public String getArchiveType() {
                return ModuleType.WAR.toString();
            }
        });
    }

    protected void setupClassLoader() throws Exception {
        this.shareableTempClassLoader = this.finalClassLoader = new WABClassLoader(null);
        ((WebappClassLoader)WebappClassLoader.class.cast(this.finalClassLoader)).start();
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("META-INF/services/com.sun.faces.spi.annotationprovider", "META-INF/hiddenservices/com.sun.faces.spi.annotationprovider");
        map.put("META-INF/services/com.sun.faces.spi.FacesConfigResourceProvider", "META-INF/hiddenservices/com.sun.faces.spi.FacesConfigResourceProvider");
        map.put("META-INF/services/com.sun.faces.spi.FaceletConfigResourceProvider", "META-INF/hiddenservices/com.sun.faces.spi.FaceletConfigResourceProvider");
        hiddenServicesMap = Collections.unmodifiableMap(map);
        hiddenServices = Collections.unmodifiableList(Arrays.asList(OSGiFacesAnnotationScanner.class.getName(), OSGiFaceletConfigResourceProvider.class.getName(), OSGiFacesConfigResourceProvider.class.getName()));
    }

    private class WABClassLoader
    extends WebappClassLoader {
        final BundleClassLoader delegate1;
        final ClassLoader delegate2;

        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return this.loadClass(name, false);
        }

        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            if (hiddenServices.contains(name)) {
                return Class.forName(name);
            }
            try {
                return this.delegate1.loadClass(name, resolve);
            }
            catch (ClassNotFoundException cnfe) {
                return this.delegate2.loadClass(name);
            }
        }

        public URL getResource(String name) {
            URL url = this.delegate1.getResource(name);
            if (url == null) {
                url = this.delegate2.getResource(name);
            }
            return url;
        }

        public Enumeration<URL> getResources(String name) throws IOException {
            ArrayList<Enumeration<URL>> enumerators = new ArrayList<Enumeration<URL>>();
            String mappedResourcePath = (String)hiddenServicesMap.get(name);
            if (mappedResourcePath != null) {
                return ((Object)((Object)this)).getClass().getClassLoader().getResources(mappedResourcePath);
            }
            enumerators.add(this.delegate1.getResources(name));
            enumerators.add(this.delegate2.getResources(name));
            return new CompositeEnumeration(enumerators);
        }

        public InputStream getResourceAsStream(String name) {
            URL url = this.getResource(name);
            try {
                return url != null ? url.openStream() : null;
            }
            catch (IOException e) {
                return null;
            }
        }

        public WABClassLoader(ClassLoader parent) {
            super(parent);
            this.delegate1 = new BundleClassLoader(OSGiWebDeploymentContext.this.bundle);
            this.delegate2 = ((ClassLoaderHierarchy)Globals.get(ClassLoaderHierarchy.class)).getAPIClassLoader();
            this.setDelegate(true);
            FileDirContext r = new FileDirContext();
            File base = OSGiWebDeploymentContext.this.getSourceDir();
            r.setDocBase(base.getAbsolutePath());
            this.setResources((DirContext)r);
            this.addRepository("WEB-INF/classes/", new File(base, "WEB-INF/classes/"));
            File libDir = new File(base, "WEB-INF/lib");
            if (libDir.exists()) {
                int baseFileLen = base.getPath().length();
                for (File file : libDir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        String fileName = pathname.getName();
                        return fileName.endsWith(".jar") && pathname.isFile();
                    }
                })) {
                    JarFile jarFile = null;
                    try {
                        jarFile = new JarFile(file);
                        this.addJar(file.getPath().substring(baseFileLen), jarFile, file);
                        jarFile.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            this.setWorkDir(OSGiWebDeploymentContext.this.getScratchDir("jsp"));
        }

        public URL getResourceFromJars(String name) {
            assert (name.startsWith("META-INF/resources/"));
            if (name.startsWith("META-INF/resources/")) {
                URL url = super.findResource(name);
                if (url != null) {
                    ResourceEntry entry = (ResourceEntry)this.resourceEntries.get(name);
                    try {
                        String repository = entry.codeBase.toString();
                        if (repository.endsWith(".jar") && !name.endsWith(".class") && !name.endsWith(".jar")) {
                            File resourceFile = new File(this.loaderDir, name);
                            url = resourceFile.toURI().toURL();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return url;
                }
            } else {
                return super.getResourceFromJars(name);
            }
            return null;
        }
    }
}

