/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.fighterfish.sample.uas.ejbservice2;

import java.util.List;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.glassfish.fighterfish.sample.uas.api.UserAuthService;
import org.glassfish.fighterfish.sample.uas.entities.LoginAttempt;
import org.glassfish.fighterfish.sample.uas.entities.UserCredential;
import org.glassfish.osgicdi.OSGiService;

@Stateless
@Local(value={UserAuthService.class})
public class UserAuthServiceEJB2
implements UserAuthService {
    @Inject
    @OSGiService(dynamic=true, serviceCriteria="(persistence-unit=sample.uas.entities)")
    private EntityManagerFactory emf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login(String name, String password) {
        this.log("Logging in (" + name + ", " + password + ")");
        EntityManager em = this.emf.createEntityManager();
        try {
            boolean result;
            UserCredential uc = (UserCredential)em.find(UserCredential.class, (Object)name);
            boolean bl = result = uc != null && password.equals(uc.getPassword());
            if (uc != null) {
                LoginAttempt attempt = new LoginAttempt();
                attempt.setSuccessful(result);
                attempt.setUserCredential(uc);
                uc.getLoginAttempts().add(attempt);
                em.persist((Object)attempt);
            }
            boolean bl2 = result;
            return bl2;
        }
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(String name, String password) {
        this.log("Registering (" + name + ", " + password + ")");
        EntityManager em = this.emf.createEntityManager();
        try {
            UserCredential uc = (UserCredential)em.find(UserCredential.class, (Object)name);
            if (uc != null) {
                boolean bl = false;
                return bl;
            }
            uc = new UserCredential();
            uc.setName(name);
            uc.setPassword(password);
            em.persist((Object)uc);
            boolean bl = true;
            return bl;
        }
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(String name) {
        this.log("Unregistering (" + name + ")");
        EntityManager em = this.emf.createEntityManager();
        try {
            UserCredential uc = (UserCredential)em.find(UserCredential.class, (Object)name);
            if (uc == null) {
                boolean bl = false;
                return bl;
            }
            em.remove((Object)uc);
            boolean bl = true;
            return bl;
        }
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReport() {
        EntityManager em = this.emf.createEntityManager();
        try {
            List attempts = em.createNamedQuery("LoginAttempt.findAll").getResultList();
            this.log("Number of entries found: " + attempts.size());
            StringBuilder report = new StringBuilder("Login Attempt Report:\n");
            for (LoginAttempt attempt : attempts) {
                report.append(attempt).append("\n");
            }
            String string = report.toString();
            return string;
        }
        finally {
            em.close();
        }
    }

    private void log(String msg) {
        System.out.println("UserAuthServiceEJB2: " + msg);
    }
}

