/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.fighterfish.test.app16.msgproducer;

import java.util.Dictionary;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class TestApp16ProducerActivator
implements BundleActivator {
    public void start(BundleContext context) throws Exception {
        System.out.println("Message producer started - waiting to be configured with topic name");
        Properties props = new Properties();
        final String pkgName = this.getClass().getPackage().getName();
        props.put("service.pid", pkgName);
        context.registerService(ManagedService.class.getName(), (Object)new ManagedService(){

            public void updated(Dictionary properties) throws ConfigurationException {
                if (properties != null) {
                    String destinationName = (String)properties.get(pkgName + ".Destination");
                    String connectionFactoryName = (String)properties.get(pkgName + ".ConnectionFactory");
                    int noOfMsgs = Integer.valueOf((String)properties.get(pkgName + ".NoOfMsgs"));
                    TestApp16ProducerActivator.this.sendMessage(connectionFactoryName, destinationName, noOfMsgs);
                }
            }
        }, (Dictionary)props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(String connectionFactoryName, String destinationName, int noOfMsgs) {
        Connection connection = null;
        try {
            InitialContext ctx = new InitialContext();
            ConnectionFactory connectionFactory = (ConnectionFactory)ctx.lookup(connectionFactoryName);
            connection = connectionFactory.createConnection();
            Session session = connection.createSession(false, 1);
            Destination dest = (Destination)ctx.lookup(destinationName);
            MessageProducer producer = session.createProducer(dest);
            TextMessage message = session.createTextMessage();
            for (int i = 0; i < noOfMsgs; ++i) {
                message.setText("This is message " + (i + 1));
                System.out.println("Sending message: " + message.getText());
                producer.send((Message)message);
            }
            producer.send(session.createMessage());
        }
        catch (JMSException e) {
            System.err.println("Exception occurred: " + e.toString());
        }
        catch (NamingException e) {
            System.err.println("Exception occurred: " + e.toString());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {}
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
    }
}

