/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.fighterfish.test.app8.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.glassfish.fighterfish.test.app8.entities.Employee;

@Entity
public class Department
implements Serializable {
    private static final long serialVersionUID = -6707620916711314356L;
    @Id
    private String name;
    @OneToMany(mappedBy="department", cascade={CascadeType.ALL})
    private Collection<Employee> employees = new ArrayList<Employee>();

    protected Department() {
    }

    public Department(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name is empty");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addEmployee(Employee e) {
        this.employees.add(e);
    }

    public Collection<Employee> getEmployees() {
        return this.employees;
    }

    public String toString() {
        return "Department(" + this.name + ", " + this.employees + ")";
    }
}

