/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.fighterfish.test.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.fighterfish.test.util.RestorableDomainConfiguration;

public class EnterpriseResourceProvisioner {
    public static final String DEFAULT_DS = "jdbc/__default";
    public static final String DEFAULT_POOL = "DerbyPool";
    public static final File derbyRootDir = EnterpriseResourceProvisioner.getDerbyDBRootDir();
    protected List<RestorableDomainConfiguration> rdcs = new ArrayList<RestorableDomainConfiguration>();

    public static File getDerbyDBRootDir() {
        String s = System.getProperty("fighterfish.test.DerbyDBRootDir", System.getProperty("java.io.tmpdir"));
        File d = new File(s);
        if (!d.isDirectory() && !d.mkdirs()) {
            throw new RuntimeException("Can't create a directory called " + d.getAbsolutePath());
        }
        return d;
    }

    protected void restoreDomainConfiguration() throws GlassFishException {
        for (RestorableDomainConfiguration rdc : this.rdcs) {
            try {
                rdc.restore();
            }
            catch (GlassFishException e) {
                e.printStackTrace();
            }
        }
    }

    protected RestorableDomainConfiguration configureEmbeddedDerby(final GlassFish gf, final String poolName, File db) throws GlassFishException {
        this.createDerbyPool(gf, poolName, db);
        CommandResult result = gf.getCommandRunner().run("delete-jdbc-resource", new String[]{DEFAULT_DS});
        if (result.getExitStatus() == CommandResult.ExitStatus.FAILURE) {
            Assert.fail((String)result.getOutput());
        }
        if ((result = gf.getCommandRunner().run("create-jdbc-resource", new String[]{"--connectionpoolid", poolName, DEFAULT_DS})).getExitStatus() == CommandResult.ExitStatus.FAILURE) {
            Assert.fail((String)result.getOutput());
        }
        RestorableDomainConfiguration rdc = new RestorableDomainConfiguration(){

            @Override
            public void restore() throws GlassFishException {
                CommandResult result = gf.getCommandRunner().run("delete-jdbc-resource", new String[]{EnterpriseResourceProvisioner.DEFAULT_DS});
                if (result.getExitStatus() == CommandResult.ExitStatus.FAILURE) {
                    Assert.fail((String)result.getOutput());
                }
                if ((result = gf.getCommandRunner().run("delete-jdbc-connection-pool", new String[]{poolName})).getExitStatus() == CommandResult.ExitStatus.FAILURE) {
                    Assert.fail((String)result.getOutput());
                }
                if ((result = gf.getCommandRunner().run("create-jdbc-resource", new String[]{"--connectionpoolid", EnterpriseResourceProvisioner.DEFAULT_POOL, EnterpriseResourceProvisioner.DEFAULT_DS})).getExitStatus() == CommandResult.ExitStatus.FAILURE) {
                    Assert.fail((String)result.getOutput());
                }
            }
        };
        this.rdcs.add(rdc);
        return rdc;
    }

    private void createDerbyPool(GlassFish gf, String poolName, File db) throws GlassFishException {
        CommandResult result;
        String dbDir = db.getAbsolutePath();
        if (System.getProperty("os.name", "generic").toLowerCase().startsWith("windows")) {
            dbDir = dbDir.replace("\\", "\\\\").replace(":", "\\:");
            System.out.println("derby dir name = " + dbDir);
        }
        if ((result = gf.getCommandRunner().run("create-jdbc-connection-pool", new String[]{"--datasourceclassname=org.apache.derby.jdbc.EmbeddedXADataSource", "--restype=javax.sql.XADataSource", "--property", "databaseName=" + dbDir + ":" + "connectionAttributes=" + ";create\\=true", poolName})).getExitStatus() == CommandResult.ExitStatus.FAILURE) {
            Assert.fail((String)result.getOutput());
        }
    }

    protected RestorableDomainConfiguration createJmsCF(GlassFish gf, String cfName) throws GlassFishException {
        RestorableDomainConfiguration rdc = this.createJmsResource(gf, cfName, "javax.jms.ConnectionFactory");
        this.rdcs.add(rdc);
        return rdc;
    }

    protected RestorableDomainConfiguration createJmsTopic(GlassFish gf, String topicName) throws GlassFishException {
        RestorableDomainConfiguration rdc = this.createJmsResource(gf, topicName, "javax.jms.Topic");
        this.rdcs.add(rdc);
        return rdc;
    }

    protected RestorableDomainConfiguration createJmsQueue(GlassFish gf, String topicName) throws GlassFishException {
        RestorableDomainConfiguration rdc = this.createJmsResource(gf, topicName, "javax.jms.Queue");
        this.rdcs.add(rdc);
        return rdc;
    }

    private RestorableDomainConfiguration createJmsResource(final GlassFish gf, final String resName, String resType) throws GlassFishException {
        CommandResult result = gf.getCommandRunner().run("create-jms-resource", new String[]{"--restype", resType, resName});
        if (result.getExitStatus() == CommandResult.ExitStatus.FAILURE) {
            Assert.fail((String)result.getOutput());
        }
        return new RestorableDomainConfiguration(){

            @Override
            public void restore() throws GlassFishException {
                gf.getCommandRunner().run("delete-jms-resource", new String[]{resName});
            }
        };
    }
}

