/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.fighterfish.test.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.fighterfish.test.util.PropertiesUtil;
import org.glassfish.fighterfish.test.util.Version;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Info;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.OptionUtils;

public class PaxExamConfigurator {
    protected Logger logger = Logger.getLogger(this.getClass().getPackage().getName());
    private File gfHome;
    private String platform;
    private final long timeout;
    private final File fwStorage;

    public PaxExamConfigurator(File gfHome, String platform, long timeout, File fwStorage) {
        this.gfHome = gfHome;
        this.platform = platform;
        this.timeout = timeout;
        this.fwStorage = fwStorage;
    }

    public Option[] configure() throws IOException {
        return OptionUtils.combine((Option[])OptionUtils.combine((Option[])this.frameworkConfiguration(), (Option[])this.provisioningBundles()), (Option[])this.paxConfiguration());
    }

    private Option[] provisioningBundles() {
        String version = Version.getVersion();
        this.logger.logp(Level.INFO, "PaxExamConfigurator", "provisioningBundles", "FighterFish Test Util Version = {0}", new Object[]{version});
        return CoreOptions.options((Option[])new Option[]{CoreOptions.bundle((String)new File(this.gfHome, "modules/glassfish.jar").toURI().toString()), CoreOptions.mavenBundle().groupId("org.junit").artifactId("com.springsource.org.junit").version("4.8.1"), CoreOptions.mavenBundle().groupId("org.glassfish.fighterfish").artifactId("test.util").version(version)});
    }

    private Option[] frameworkConfiguration() throws IOException {
        List<Option> options = this.convertToOptions(this.readFrameworkConfiguration());
        options.add(CoreOptions.systemPackages((String[])new String[]{"org.ops4j.pax.exam.options.extra; version=" + Info.getPaxExamVersion()}));
        if (this.fwStorage != null) {
            options.add(0, (Option)CoreOptions.workingDirectory((String)this.fwStorage.getAbsolutePath()));
        }
        return options.toArray(new Option[options.size()]);
    }

    private Option[] paxConfiguration() {
        return CoreOptions.options((Option[])new Option[]{CoreOptions.systemProperty((String)"pax-exam.framework.shutdown.timeout").value(String.valueOf(this.timeout))});
    }

    private List<Option> convertToOptions(Properties properties) {
        ArrayList<Option> options = new ArrayList<Option>();
        for (String p : properties.getProperty("org.osgi.framework.bootdelegation", "").split(",")) {
            if (p.trim().isEmpty()) continue;
            System.out.println("Boot delegation pkg = " + p);
            options.add((Option)CoreOptions.bootDelegationPackage((String)p.trim()));
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (entry.getKey().equals("org.osgi.framework.bootdelegation")) continue;
            if (entry.getKey().equals("org.osgi.framework.storage")) {
                options.add((Option)CoreOptions.workingDirectory((String)((String)entry.getValue())));
                continue;
            }
            options.add((Option)CoreOptions.systemProperty((String)((String)entry.getKey())).value((String)entry.getValue()));
        }
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readFrameworkConfiguration() throws IOException {
        Properties properties = new Properties();
        this.logger.logp(Level.INFO, "DefaultPaxExamConfiguration", "readFrameworkConfiguration", "fwConfigFileName = {0}", new Object[]{"OSGiFramework.properties"});
        InputStream stream = this.getClass().getResourceAsStream("OSGiFramework.properties");
        if (stream != null) {
            try {
                properties.load(stream);
            }
            finally {
                stream.close();
            }
            PropertiesUtil.substVars(properties);
        } else {
            this.logger.logp(Level.WARNING, "DefaultPaxExamConfiguration", "readFrameworkConfiguration", "{0} not found. Using default values", new Object[]{"OSGiFramework.properties"});
        }
        return properties;
    }
}

