/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.fighterfish.test.util;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.fighterfish.test.util.BundleProvisioner;
import org.glassfish.fighterfish.test.util.EjbBundle;
import org.glassfish.fighterfish.test.util.EnterpriseResourceProvisioner;
import org.glassfish.fighterfish.test.util.EntityBundle;
import org.glassfish.fighterfish.test.util.GlassFishTracker;
import org.glassfish.fighterfish.test.util.TestsConfiguration;
import org.glassfish.fighterfish.test.util.WebAppBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class TestContext {
    private final String testClassName;
    private final String testMethodName;
    private BundleContext ctx;
    private BundleProvisioner bundleProvisioner;
    private EnterpriseResourceProvisioner resourceProvisioner;
    private Logger logger = Logger.getLogger(this.getClass().getPackage().getName());

    private TestContext(String testClassName, String testMethodName, BundleContext ctx) {
        this.logger.info("Beginning of test " + testClassName + "." + testMethodName);
        this.ctx = ctx;
        this.testClassName = testClassName;
        this.testMethodName = testMethodName;
        this.bundleProvisioner = new BundleProvisioner(ctx);
        this.resourceProvisioner = new EnterpriseResourceProvisioner();
    }

    public static TestContext create(BundleContext ctx) throws GlassFishException, InterruptedException {
        TestContext tc = new TestContext(TestContext.getCallingClassName(), TestContext.getCallingMethodName(), ctx);
        tc.getGlassFish();
        tc.configureEmbeddedDerby();
        return tc;
    }

    public void destroy() throws BundleException, GlassFishException {
        this.bundleProvisioner.uninstallAllTestBundles();
        this.resourceProvisioner.restoreDomainConfiguration();
        this.logger.info("End of test " + this.testClassName + "." + this.testMethodName);
    }

    public WebAppBundle deployWebAppBundle(Bundle bundle) throws BundleException, InterruptedException {
        WebAppBundle webAppBundle = new WebAppBundle(this.getBundleContext(), bundle);
        webAppBundle.deploy(TestsConfiguration.getInstance().getTimeout(), TimeUnit.MILLISECONDS);
        return webAppBundle;
    }

    public EntityBundle deployEntityBundle(Bundle bundle) throws BundleException, InterruptedException {
        EntityBundle entityBundle = new EntityBundle(this.getBundleContext(), bundle);
        entityBundle.deploy(TestsConfiguration.getInstance().getTimeout(), TimeUnit.MILLISECONDS);
        return entityBundle;
    }

    public EjbBundle deployEjbBundle(Bundle bundle, String[] services) throws BundleException, InterruptedException {
        EjbBundle ejbBundle = new EjbBundle(this.getBundleContext(), bundle, services);
        ejbBundle.deploy(TestsConfiguration.getInstance().getTimeout(), TimeUnit.MILLISECONDS);
        return ejbBundle;
    }

    public GlassFish getGlassFish() throws GlassFishException, InterruptedException {
        return GlassFishTracker.waitForGfToStart(this.ctx, TestsConfiguration.getInstance().getTimeout());
    }

    public void configureEmbeddedDerby() throws GlassFishException, InterruptedException {
        this.resourceProvisioner.configureEmbeddedDerby(this.getGlassFish(), this.testMethodName, new File(EnterpriseResourceProvisioner.getDerbyDBRootDir(), this.testMethodName));
    }

    public BundleContext getBundleContext() {
        return this.ctx;
    }

    public Bundle installTestBundle(String location) throws BundleException {
        return this.bundleProvisioner.installTestBundle(location);
    }

    public void createJmsCF(String cfName) throws GlassFishException, InterruptedException {
        this.resourceProvisioner.createJmsCF(this.getGlassFish(), cfName);
    }

    public void createJmsTopic(String topicName) throws GlassFishException, InterruptedException {
        this.resourceProvisioner.createJmsTopic(this.getGlassFish(), topicName);
    }

    private static String getCallingMethodName() {
        return new Exception().getStackTrace()[2].getMethodName();
    }

    private static String getCallingClassName() {
        return new Exception().getStackTrace()[2].getClassName();
    }
}

