/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.fighterfish.test.util;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.fighterfish.test.util.PaxExamConfigurator;
import org.ops4j.pax.exam.Option;

public class TestsConfiguration {
    private File gfHome;
    private String platform;
    private long testTimeout;
    private long examTimeout;
    protected Logger logger = Logger.getLogger(this.getClass().getPackage().getName());
    private static TestsConfiguration instance;
    private File fwStorage;

    public static synchronized TestsConfiguration getInstance() {
        if (instance == null) {
            instance = new TestsConfiguration(System.getProperties());
        }
        return instance;
    }

    private TestsConfiguration(Properties properties) {
        this.gfHome = new File(properties.getProperty("com.sun.aas.installRoot"));
        this.platform = properties.getProperty("GlassFish_Platform", "Felix");
        this.testTimeout = Long.parseLong(properties.getProperty("fighterfish.test.timeout", "30000"));
        this.examTimeout = Long.parseLong(properties.getProperty("pax-exam.framework.shutdown.timeout", "30000"));
        String s = properties.getProperty("org.osgi.framework.storage");
        if (s != null) {
            this.fwStorage = new File(s);
        }
    }

    public long getTimeout() {
        return this.testTimeout;
    }

    public File getGfHome() {
        return this.gfHome;
    }

    public String getPlatform() {
        return this.platform;
    }

    public Option[] getPaxExamConfiguration() throws IOException {
        return new PaxExamConfigurator(this.getGfHome(), this.getPlatform(), this.examTimeout, this.fwStorage).configure();
    }
}

