/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.fighterfish.test.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import org.glassfish.fighterfish.test.util.TimeoutException;
import org.glassfish.fighterfish.test.util.WABDeploymentEventHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class WebAppBundle {
    private BundleContext context;
    private Bundle b;
    private String contextPath;
    private State state;
    private CountDownLatch deploymentSignal = new CountDownLatch(1);

    public WebAppBundle(BundleContext context, Bundle b) {
        this.context = context;
        this.b = b;
    }

    public ServletContext deploy(long timeout, TimeUnit timeUnit) throws InterruptedException, BundleException, TimeoutException {
        WABDeploymentEventHandler eventHandler = new WABDeploymentEventHandler(this.context, this.b, new WABDeploymentEventHandler.Callback(){

            @Override
            public void deploying() {
                WebAppBundle.this.state = State.DEPLOYING;
            }

            @Override
            public void deployed(String contextPath) {
                WebAppBundle.this.state = State.DEPLOYED;
                WebAppBundle.this.contextPath = contextPath;
                WebAppBundle.this.deploymentSignal.countDown();
            }

            @Override
            public void undeploying() {
                WebAppBundle.this.state = State.UNDEPLOYING;
            }

            @Override
            public void undeployed() {
                WebAppBundle.this.state = State.UNDEPLOYED;
            }

            @Override
            public void failed(Throwable throwable, String collision, Long[] collisionBundleIds) {
                WebAppBundle.this.state = State.FAILED;
                WebAppBundle.this.deploymentSignal.countDown();
            }
        });
        this.b.start(1);
        this.deploymentSignal.await(timeout, timeUnit);
        if (State.DEPLOYED.equals((Object)this.state)) {
            return (ServletContext)this.context.getService(this.context.getServiceReference(ServletContext.class.getName()));
        }
        throw new TimeoutException("Deployment timedout. Check log to see what exactly went wrong.");
    }

    public void undeploy() throws BundleException {
        this.b.stop(1);
    }

    public String getResponse(String relativePath) throws IOException {
        String inputLine;
        URL servlet = new URL("http", this.getHost(), this.getPort(), this.contextPath + relativePath);
        URLConnection yc = servlet.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
        StringBuilder sb = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            sb.append(inputLine);
        }
        in.close();
        return sb.toString();
    }

    private String getHost() {
        return "localhost";
    }

    private int getPort() {
        return 8080;
    }

    static enum State {
        DEPLOYING,
        DEPLOYED,
        UNDEPLOYING,
        UNDEPLOYED,
        FAILED;

    }
}

