/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.fighterfish.test.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipUtil {
    private static Logger logger = Logger.getLogger(ZipUtil.class.getPackage().getName());

    private static boolean needToExplode(File dest) throws Exception {
        if (new File(dest, "glassfish3").isDirectory()) {
            return false;
        }
        if (dest.isFile()) {
            throw new Exception(dest.getAbsolutePath() + " is a file");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void explode(URI in, File out) throws Exception {
        assert (in != null);
        logger.entering("ZipUtil", "explode", new Object[]{in, out});
        if (!ZipUtil.needToExplode(out)) {
            logger.logp(Level.FINE, "ZipUtil", "explode", "Skipping exploding at {0}", new Object[]{out});
        }
        if (in != null) {
            ZipInputStream zis = new ZipInputStream(in.toURL().openStream());
            try {
                ZipUtil.extractZip(zis, out);
            }
            finally {
                zis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractZip(ZipInputStream zis, File destDir) throws IOException {
        ZipEntry ze;
        logger.logp(Level.FINE, "ZipUtil", "extractZip", "destDir = {0}", new Object[]{destDir});
        int n = 0;
        int size = 0;
        while ((ze = zis.getNextEntry()) != null) {
            logger.logp(Level.FINER, "ZipUtil", "extractZip", "ZipEntry name = {0}, size = {1}", new Object[]{ze.getName(), ze.getSize()});
            File f = new File(destDir + File.separator + ze.getName());
            if (ze.isDirectory()) {
                if (!f.exists()) {
                    if (f.mkdirs()) continue;
                    throw new IOException("Unable to create dir " + f.getAbsolutePath());
                }
                if (!f.isFile()) continue;
                throw new IOException("Unable to create dir " + f.getAbsolutePath() + " because it already exists as a file.");
            }
            if (f.exists()) continue;
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                int totalcount = 0;
                int count = 0;
                byte[] buffer = new byte[8192];
                while ((count = zis.read(buffer, 0, buffer.length)) != -1) {
                    fos.write(buffer, 0, count);
                    totalcount += count;
                }
                logger.logp(Level.FINER, "ZipUtil", "extractZip", "totalcount for this zip entry = {0}", new Object[]{totalcount});
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            zis.closeEntry();
            ++n;
            size = (int)((long)size + ze.getSize());
        }
        logger.logp(Level.INFO, "ZipUtil", "extractZip", "Extracted {0} of entries of total size {1} bytes to {2}.", new Object[]{n, size, destDir.getAbsolutePath()});
    }
}

