/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.fighterfish.test.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.fighterfish.test.util.BundleProvisioner;
import org.glassfish.fighterfish.test.util.EjbBundle;
import org.glassfish.fighterfish.test.util.EnterpriseResourceProvisioner;
import org.glassfish.fighterfish.test.util.EntityBundle;
import org.glassfish.fighterfish.test.util.GlassFishTracker;
import org.glassfish.fighterfish.test.util.TestsConfiguration;
import org.glassfish.fighterfish.test.util.WebAppBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;

public class TestContext {
    private final String testID;
    private static final AtomicInteger testIdGen = new AtomicInteger(0);
    private BundleContext ctx;
    private BundleProvisioner bundleProvisioner;
    private EnterpriseResourceProvisioner resourceProvisioner;
    private Logger logger = Logger.getLogger(this.getClass().getPackage().getName());

    private TestContext(String testID, BundleContext ctx) {
        this.logger.info("Creating test context for test id: " + testID);
        this.ctx = ctx;
        this.testID = testID;
        this.bundleProvisioner = new BundleProvisioner(ctx);
        this.resourceProvisioner = new EnterpriseResourceProvisioner(ctx);
    }

    public static TestContext create(Class testClass) throws GlassFishException, InterruptedException {
        BundleContext ctx = FrameworkUtil.getBundle((Class)testClass).getBundleContext();
        TestContext tc = new TestContext(TestContext.getNextTestId(testClass), ctx);
        tc.getGlassFish();
        tc.configureEmbeddedDerby();
        return tc;
    }

    private static String getNextTestId(Class testClass) {
        return testClass.getName() + "-" + String.valueOf(testIdGen.incrementAndGet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws BundleException, GlassFishException {
        this.logger.info("Destroying test context for test id: " + this.testID);
        try {
            this.bundleProvisioner.uninstallAllTestBundles();
        }
        finally {
            this.resourceProvisioner.restoreDomainConfiguration();
        }
    }

    public WebAppBundle deployWebAppBundle(Bundle bundle) throws BundleException, InterruptedException {
        WebAppBundle webAppBundle = new WebAppBundle(this.getBundleContext(), bundle);
        webAppBundle.deploy(TestsConfiguration.getInstance().getTimeout(), TimeUnit.MILLISECONDS);
        return webAppBundle;
    }

    public WebAppBundle deployWebAppBundle(String location) throws BundleException, InterruptedException {
        return this.deployWebAppBundle(this.installBundle(location));
    }

    public EntityBundle deployEntityBundle(Bundle bundle) throws BundleException, InterruptedException {
        EntityBundle entityBundle = new EntityBundle(this.getBundleContext(), bundle);
        entityBundle.deploy(TestsConfiguration.getInstance().getTimeout(), TimeUnit.MILLISECONDS);
        return entityBundle;
    }

    public EntityBundle deployEntityBundle(String location) throws BundleException, InterruptedException {
        return this.deployEntityBundle(this.installBundle(location));
    }

    public EjbBundle deployEjbBundle(Bundle bundle, String[] services) throws BundleException, InterruptedException {
        EjbBundle ejbBundle = new EjbBundle(this.getBundleContext(), bundle, services);
        ejbBundle.deploy(TestsConfiguration.getInstance().getTimeout(), TimeUnit.MILLISECONDS);
        return ejbBundle;
    }

    public EjbBundle deployEjbBundle(String location, String[] services) throws BundleException, InterruptedException {
        return this.deployEjbBundle(this.installBundle(location), services);
    }

    public GlassFish getGlassFish() throws GlassFishException, InterruptedException {
        return GlassFishTracker.waitForGfToStart(this.ctx, TestsConfiguration.getInstance().getTimeout());
    }

    public void configureEmbeddedDerby() throws GlassFishException, InterruptedException {
        this.resourceProvisioner.configureEmbeddedDerby(this.getGlassFish(), this.testID, this.testID);
    }

    public BundleContext getBundleContext() {
        return this.ctx;
    }

    public Bundle installBundle(String location) throws BundleException {
        return this.bundleProvisioner.installTestBundle(location);
    }

    public void createJmsCF(String cfName) throws GlassFishException, InterruptedException {
        this.resourceProvisioner.createJmsCF(this.getGlassFish(), cfName);
    }

    public void createJmsTopic(String topicName) throws GlassFishException, InterruptedException {
        this.resourceProvisioner.createJmsTopic(this.getGlassFish(), topicName);
    }

    private static String getCallingMethodName() {
        return new Exception().getStackTrace()[2].getMethodName();
    }

    private static String getCallingClassName() {
        return new Exception().getStackTrace()[2].getClassName();
    }

    private static BundleContext getCallingBundleContext() {
        return FrameworkUtil.getBundle((Class)TestContext.getCallingClass()).getBundleContext();
    }

    private static Class getCallingClass() {
        return new SecurityManager1().getCallingClass();
    }

    static class SecurityManager1
    extends SecurityManager {
        SecurityManager1() {
        }

        private Class getCallingClass() {
            return this.getClassContext()[6];
        }
    }
}

