/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.fighterfish.test.util;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class BundleProvisioner {
    private List<Bundle> testBundles = new ArrayList<Bundle>();
    private BundleContext ctx;
    private Logger logger = Logger.getLogger(this.getClass().getPackage().getName());

    public BundleProvisioner(BundleContext ctx) {
        this.ctx = ctx;
    }

    protected Bundle installTestBundle(String location) throws BundleException {
        this.logger.logp(Level.INFO, "AbstractTestObject", "installBundle", "Installing bundle = {0}", new Object[]{location});
        Bundle bundle = this.ctx.installBundle(location);
        this.testBundles.add(bundle);
        this.logger.logp(Level.INFO, "AbstractTestObject", "installBundle", "Installed bundle = {0} from {1} ", new Object[]{bundle, location});
        return bundle;
    }

    protected void uninstallTestBundle(Bundle bundle) throws BundleException {
        if (this.testBundles.remove(bundle)) {
            if (bundle.getState() != 1) {
                this.logger.logp(Level.INFO, "AbstractTestObject", "uninstallTestBundle", "Uninstalling bundle = {0}", new Object[]{bundle});
                bundle.uninstall();
                this.logger.logp(Level.INFO, "AbstractTestObject", "uninstallTestBundle", "Uninstalled bundle = {0}", new Object[]{bundle});
            } else {
                this.logger.logp(Level.INFO, "AbstractTestObject", "uninstallTestBundle", "Bundle Already Uninstalled = {0}", new Object[]{bundle});
            }
        } else {
            throw new RuntimeException(bundle + " is not a test bundle");
        }
    }

    protected void uninstallAllTestBundles() throws BundleException {
        for (Bundle b : this.testBundles.toArray(new Bundle[0])) {
            this.uninstallTestBundle(b);
        }
    }
}

