/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.fighterfish.test.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.fighterfish.test.util.RestorableDomainConfiguration;
import org.osgi.framework.BundleContext;

public class EnterpriseResourceProvisioner {
    protected List<RestorableDomainConfiguration> rdcs = new ArrayList<RestorableDomainConfiguration>();
    private boolean inMemoryDerbyDb;
    private File derbyDbRootDir;
    private Logger logger = Logger.getLogger(this.getClass().getPackage().getName());

    public EnterpriseResourceProvisioner(BundleContext ctx) {
        String derbyDbRootDir = ctx.getProperty("fighterfish.test.DerbyDBRootDir");
        if (derbyDbRootDir == null || derbyDbRootDir.isEmpty()) {
            this.inMemoryDerbyDb = true;
        } else {
            this.derbyDbRootDir = new File(derbyDbRootDir);
            if (!this.derbyDbRootDir.isDirectory() && !this.derbyDbRootDir.mkdirs()) {
                throw new RuntimeException("Can't create a directory called " + this.derbyDbRootDir.getAbsolutePath());
            }
        }
    }

    private File getDerbyDBRootDir() {
        return this.derbyDbRootDir;
    }

    private boolean isInmemoryDerbyDb() {
        return this.inMemoryDerbyDb;
    }

    protected void restoreDomainConfiguration() throws GlassFishException {
        for (RestorableDomainConfiguration rdc : this.rdcs) {
            try {
                rdc.restore();
            }
            catch (GlassFishException e) {
                e.printStackTrace();
            }
        }
    }

    protected RestorableDomainConfiguration configureEmbeddedDerby(final GlassFish gf, final String poolName, String db) throws GlassFishException {
        if (this.isInmemoryDerbyDb()) {
            this.createPoolForInmemoryEmbeddedDerbyDb(gf, poolName, db);
        } else {
            this.createPoolForEmbeddedDerbyDb(gf, poolName, db);
        }
        this.execute(gf, "delete-jdbc-resource", "jdbc/__default");
        this.execute(gf, "create-jdbc-resource", "--connectionpoolid", poolName, "jdbc/__default");
        RestorableDomainConfiguration rdc = new RestorableDomainConfiguration(){

            @Override
            public void restore() throws GlassFishException {
                CommandResult result = gf.getCommandRunner().run("delete-jdbc-resource", new String[]{"jdbc/__default"});
                if (result.getExitStatus() == CommandResult.ExitStatus.FAILURE) {
                    Assert.fail((String)result.getOutput());
                }
                if ((result = gf.getCommandRunner().run("delete-jdbc-connection-pool", new String[]{poolName})).getExitStatus() == CommandResult.ExitStatus.FAILURE) {
                    Assert.fail((String)result.getOutput());
                }
                if ((result = gf.getCommandRunner().run("create-jdbc-resource", new String[]{"--connectionpoolid", "DerbyPool", "jdbc/__default"})).getExitStatus() == CommandResult.ExitStatus.FAILURE) {
                    Assert.fail((String)result.getOutput());
                }
            }
        };
        this.rdcs.add(rdc);
        return rdc;
    }

    private void createPoolForEmbeddedDerbyDb(GlassFish gf, String poolName, String db) throws GlassFishException {
        String dbDir = new File(this.getDerbyDBRootDir(), db).getAbsolutePath();
        if (System.getProperty("os.name", "generic").toLowerCase().startsWith("windows")) {
            dbDir = dbDir.replace("\\", "\\\\").replace(":", "\\:");
        }
        String poolProps = "databaseName=" + dbDir + ":" + "connectionAttributes=;create\\=true";
        this.execute(gf, "create-jdbc-connection-pool", "--ping", "--restype=javax.sql.XADataSource", "--datasourceclassname=org.apache.derby.jdbc.EmbeddedXADataSource", "--property", poolProps, poolName);
    }

    private void createPoolForInmemoryEmbeddedDerbyDb(GlassFish gf, String poolName, String db) throws GlassFishException {
        String poolProps = "databaseName=memory\\:" + db + ":" + "connectionAttributes=;create\\=true";
        this.execute(gf, "create-jdbc-connection-pool", "--ping", "--restype=javax.sql.XADataSource", "--datasourceclassname=org.apache.derby.jdbc.EmbeddedXADataSource", "--property", poolProps, poolName);
    }

    protected RestorableDomainConfiguration createJmsCF(GlassFish gf, String cfName) throws GlassFishException {
        RestorableDomainConfiguration rdc = this.createJmsResource(gf, cfName, "javax.jms.ConnectionFactory");
        this.rdcs.add(rdc);
        return rdc;
    }

    protected RestorableDomainConfiguration createJmsTopic(GlassFish gf, String topicName) throws GlassFishException {
        RestorableDomainConfiguration rdc = this.createJmsResource(gf, topicName, "javax.jms.Topic");
        this.rdcs.add(rdc);
        return rdc;
    }

    protected RestorableDomainConfiguration createJmsQueue(GlassFish gf, String topicName) throws GlassFishException {
        RestorableDomainConfiguration rdc = this.createJmsResource(gf, topicName, "javax.jms.Queue");
        this.rdcs.add(rdc);
        return rdc;
    }

    private RestorableDomainConfiguration createJmsResource(final GlassFish gf, final String resName, String resType) throws GlassFishException {
        this.execute(gf, "create-jms-resource", "--restype", resType, resName);
        return new RestorableDomainConfiguration(){

            @Override
            public void restore() throws GlassFishException {
                gf.getCommandRunner().run("delete-jms-resource", new String[]{resName});
            }
        };
    }

    private CommandResult execute(GlassFish gf, String cmd, String ... args) throws GlassFishException {
        this.logger.logp(Level.INFO, "EnterpriseResourceProvisioner", "execute", "cmd = {0}, args = {1}", new Object[]{cmd, Arrays.toString(args)});
        CommandResult result = gf.getCommandRunner().run(cmd, args);
        if (result.getExitStatus() == CommandResult.ExitStatus.FAILURE) {
            Assert.fail((String)result.getOutput());
        }
        return result;
    }
}

