/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.fighterfish.test.util;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.fighterfish.test.util.TestsConfiguration;
import org.junit.Assert;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.statements.Fail;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.ops4j.pax.exam.ExamConfigurationException;
import org.ops4j.pax.exam.ExamSystem;
import org.ops4j.pax.exam.ExceptionHelper;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.TestContainerFactory;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.junit.ExamFactory;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.ProbeBuilder;
import org.ops4j.pax.exam.spi.DefaultExamReactor;
import org.ops4j.pax.exam.spi.ExamReactor;
import org.ops4j.pax.exam.spi.PaxExamRuntime;
import org.ops4j.pax.exam.spi.StagedExamReactor;
import org.ops4j.pax.exam.spi.StagedExamReactorFactory;
import org.ops4j.pax.exam.spi.reactors.EagerSingleStagedReactorFactory;

public class FighterFishJUnitRunner
extends BlockJUnit4ClassRunner {
    private Logger LOG = Logger.getLogger(((Object)((Object)this)).getClass().getPackage().getName());
    private final StagedExamReactor m_reactor;
    private final Map<TestAddress, FrameworkMethod> m_map = new HashMap<TestAddress, FrameworkMethod>();
    private final Map<FrameworkMethod, TestAddress> m__childs = new HashMap<FrameworkMethod, TestAddress>();
    private ExamSystem m_system;

    public FighterFishJUnitRunner(Class<?> klass) throws Exception {
        super(klass);
        this.m_reactor = this.prepareReactor();
    }

    public void run(RunNotifier notifier) {
        try {
            super.run(notifier);
        }
        catch (Exception e) {
            throw new TestContainerException("Problem interacting with reactor.", (Throwable)e);
        }
        finally {
            this.m_reactor.tearDown();
            this.m_system.clear();
        }
    }

    protected Statement classBlock(RunNotifier notifier) {
        Statement statement = this.childrenInvoker(notifier);
        return statement;
    }

    protected Statement methodBlock(FrameworkMethod method) {
        Object test;
        try {
            test = new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return FighterFishJUnitRunner.this.createTest();
                }
            }.run();
        }
        catch (Throwable e) {
            return new Fail(e);
        }
        Statement statement = this.methodInvoker(method, test);
        return statement;
    }

    protected List<FrameworkMethod> getChildren() {
        if (this.m__childs.isEmpty()) {
            this.fillChildren();
        }
        return Arrays.asList(this.m__childs.keySet().toArray(new FrameworkMethod[this.m__childs.size()]));
    }

    private void fillChildren() {
        Set targets = this.m_reactor.getTargets();
        for (final TestAddress address : targets) {
            final FrameworkMethod frameworkMethod = this.m_map.get(address.root());
            FrameworkMethod method = new FrameworkMethod(frameworkMethod.getMethod()){

                public String getName() {
                    return frameworkMethod.getName() + ":" + address.caption();
                }

                public boolean equals(Object obj) {
                    return address.equals(obj);
                }

                public int hashCode() {
                    return address.hashCode();
                }
            };
            this.m__childs.put(method, address);
        }
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
    }

    private synchronized StagedExamReactor prepareReactor() throws Exception {
        this.m_system = PaxExamRuntime.createTestSystem((Option[])new Option[0]);
        Class testClass = this.getTestClass().getJavaClass();
        Object testClassInstance = testClass.newInstance();
        DefaultExamReactor reactor = this.getReactor(testClass);
        this.addConfigurationsToReactor((ExamReactor)reactor, testClass, testClassInstance);
        this.addTestsToReactor((ExamReactor)reactor, testClass, testClassInstance);
        return reactor.stage(this.getFactory(testClass));
    }

    private void addConfigurationsToReactor(ExamReactor reactor, Class testClass, Object testClassInstance) throws IllegalAccessException, InvocationTargetException, IllegalArgumentException, IOException {
        reactor.addConfiguration(TestsConfiguration.getInstance().getPaxExamConfiguration());
    }

    private void addTestsToReactor(ExamReactor reactor, Class testClass, Object testClassInstance) throws IOException, ExamConfigurationException {
        TestProbeBuilder probe = this.m_system.createProbe();
        probe = this.overwriteWithUserDefinition(testClass, testClassInstance, probe);
        for (FrameworkMethod s : super.getChildren()) {
            TestAddress address = this.delegateTest(testClassInstance, probe, s);
            if (address == null) {
                address = probe.addTest(testClass, s.getMethod().getName(), new Object[0]);
            }
            this.m_map.put(address, s);
        }
        reactor.addProbe(probe.build());
    }

    private TestAddress delegateTest(Object testClassInstance, TestProbeBuilder probe, FrameworkMethod s) {
        try {
            Class<?>[] types = s.getMethod().getParameterTypes();
            if (types.length == 1 && types[0].isAssignableFrom(TestProbeBuilder.class)) {
                return (TestAddress)s.getMethod().invoke(testClassInstance, probe);
            }
            return null;
        }
        catch (Exception e) {
            throw new TestContainerException("Problem delegating to test.", (Throwable)e);
        }
    }

    private StagedExamReactorFactory getFactory(Class testClass) throws InstantiationException, IllegalAccessException {
        ExamReactorStrategy strategy = testClass.getAnnotation(ExamReactorStrategy.class);
        Object fact = strategy != null ? (StagedExamReactorFactory)strategy.value()[0].newInstance() : new EagerSingleStagedReactorFactory();
        return fact;
    }

    private DefaultExamReactor getReactor(Class testClass) throws InstantiationException, IllegalAccessException {
        return new DefaultExamReactor(this.m_system, this.getExamFactory(testClass));
    }

    private TestContainerFactory getExamFactory(Class testClass) throws IllegalAccessException, InstantiationException {
        ExamFactory f = testClass.getAnnotation(ExamFactory.class);
        TestContainerFactory fact = f != null ? (TestContainerFactory)f.value().newInstance() : PaxExamRuntime.getTestContainerFactory();
        return fact;
    }

    protected synchronized Statement methodInvoker(final FrameworkMethod method, Object test) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TestAddress address = (TestAddress)FighterFishJUnitRunner.this.m__childs.get(method);
                TestAddress root = address.root();
                FighterFishJUnitRunner.this.LOG.fine("Invoke " + method.getName() + " @ " + address + " Arguments: " + root.arguments());
                try {
                    FighterFishJUnitRunner.this.m_reactor.invoke(address);
                }
                catch (Exception e) {
                    Throwable t = ExceptionHelper.unwind((Throwable)e);
                    FighterFishJUnitRunner.this.LOG.log(Level.SEVERE, "Exception", e);
                    Assert.fail((String)t.getMessage());
                }
            }
        };
    }

    protected void validatePublicVoidNoArgMethods(Class<? extends Annotation> annotation, boolean isStatic, List<Throwable> errors) {
    }

    private TestProbeBuilder overwriteWithUserDefinition(Class testClass, Object instance, TestProbeBuilder probe) throws ExamConfigurationException {
        Method[] methods;
        for (Method m : methods = testClass.getMethods()) {
            TestProbeBuilder probeBuilder;
            ProbeBuilder conf = m.getAnnotation(ProbeBuilder.class);
            if (conf == null) continue;
            this.LOG.fine("User defined probe hook found: " + m.getName());
            try {
                probeBuilder = (TestProbeBuilder)m.invoke(instance, probe);
            }
            catch (Exception e) {
                throw new ExamConfigurationException("Invoking custom probe hook " + m.getName() + " failed", e);
            }
            if (probeBuilder != null) {
                return probe;
            }
            throw new ExamConfigurationException("Invoking custom probe hook " + m.getName() + " succeeded but returned null");
        }
        this.LOG.fine("No User defined probe hook found");
        return probe;
    }
}

