/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.fighterfish.test.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Date;

public class JStack {
    public String toString() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        return JStack.getAllStack(threadMXBean.dumpAllThreads(true, true));
    }

    private static String getAllStack(ThreadInfo[] tis) {
        if (tis == null) {
            return "null";
        }
        StringBuilder b = new StringBuilder("[");
        for (ThreadInfo ti : tis) {
            b.append("\n [" + JStack.getStack(ti) + " ]");
            if (ti == tis[tis.length - 1]) continue;
            b.append(",");
        }
        b.append("\n]");
        return b.toString();
    }

    private static String getStack(ThreadInfo ti) {
        StringBuilder sb = new StringBuilder("\"" + ti.getThreadName() + "\"" + " Id=" + ti.getThreadId() + " " + (Object)((Object)ti.getThreadState()));
        if (ti.getLockName() != null) {
            sb.append(" on " + ti.getLockName());
        }
        if (ti.getLockOwnerName() != null) {
            sb.append(" owned by \"" + ti.getLockOwnerName() + "\" Id=" + ti.getLockOwnerId());
        }
        if (ti.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (ti.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        StackTraceElement[] stackTrace = ti.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement ste = stackTrace[i];
            sb.append("\t\tat " + ste.toString());
            sb.append('\n');
            if (i == 0 && ti.getLockInfo() != null) {
                Thread.State ts = ti.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on " + ti.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on " + ti.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on " + ti.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                }
            }
            for (LockInfo lockInfo : ti.getLockedMonitors()) {
                if (((MonitorInfo)lockInfo).getLockedStackDepth() != i) continue;
                sb.append("\t-  locked " + lockInfo);
                sb.append('\n');
            }
        }
        LockInfo[] locks = ti.getLockedSynchronizers();
        if (locks.length > 0) {
            sb.append("\n\tNumber of locked synchronizers = " + locks.length);
            sb.append('\n');
            for (LockInfo lockInfo : locks) {
                sb.append("\t- " + lockInfo);
                sb.append('\n');
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    public void printStackTrace() {
        File f = new File(System.getProperty("user.home"), "jstack.txt");
        System.out.println("JStack written out to " + f.getAbsolutePath());
        try {
            FileOutputStream out = new FileOutputStream(f, true);
            this.printStackTrace(out);
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void printStackTrace(OutputStream out) {
        String s = this.toString();
        PrintWriter printWriter = new PrintWriter(out);
        printWriter.println("Stack trace generated at " + new Date() + "\n" + s);
        printWriter.flush();
    }

    public static void main(String[] args) {
        new Thread(){
            {
                this.setDaemon(false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }.start();
        JStack x = new JStack();
        System.out.println(x);
        x.printStackTrace();
    }
}

