/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.fighterfish.test.util;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.fighterfish.test.util.PaxExamConfigurator;
import org.glassfish.fighterfish.test.util.ZipUtil;
import org.ops4j.pax.exam.Option;

public class TestsConfiguration {
    private File gfHome;
    private String provisioningUrl;
    private long testTimeout;
    private long examTimeout;
    private boolean install;
    private File installDir;
    protected Logger logger = Logger.getLogger(this.getClass().getPackage().getName());
    private static TestsConfiguration instance;

    public static synchronized TestsConfiguration getInstance() {
        if (instance == null) {
            instance = new TestsConfiguration(System.getProperties());
        }
        return instance;
    }

    private TestsConfiguration(Properties properties) {
        this.testTimeout = Long.parseLong(properties.getProperty("fighterfish.test.timeout", "30000"));
        this.examTimeout = Long.parseLong(properties.getProperty("fighterfish.test.setup.timeout", "60000"));
        String property = properties.getProperty("com.sun.aas.installRoot");
        if (property != null && !property.isEmpty()) {
            this.gfHome = new File(property);
        }
        if ((property = properties.getProperty("fighterfish.provisioner.url")) != null && !property.isEmpty()) {
            this.provisioningUrl = property;
        }
        if (this.gfHome == null) {
            if (this.provisioningUrl == null) {
                this.provisioningUrl = "mvn:org.glassfish.distributions/glassfish/3.1.1/zip";
            }
            this.installDir = new File(System.getProperty("java.io.tmpdir"), "fighterfish-" + this.provisioningUrl.hashCode());
            this.gfHome = new File(this.installDir, "glassfish3/glassfish/");
            boolean bl = this.install = !this.installDir.exists();
            if (!this.install) {
                this.logger.logp(Level.INFO, "TestsConfiguration", "setup", "Reusing existing installation at {0}", new Object[]{this.installDir});
            }
        } else if (!this.gfHome.exists()) {
            this.install = this.provisioningUrl != null;
            this.installDir = new File(this.gfHome, "../..");
        }
    }

    private void install() {
        if (this.install) {
            this.logger.logp(Level.INFO, "TestsConfiguration", "TestsConfiguration", "Will install {0} at {1}", new Object[]{this.provisioningUrl, this.installDir});
            this.explode(this.provisioningUrl, this.installDir);
        }
        this.verifyInstallation();
    }

    private void verifyInstallation() {
        File file = new File(this.gfHome, "modules/glassfish.jar");
        if (!file.exists()) {
            throw new RuntimeException(file.getAbsolutePath() + " does not exist.");
        }
    }

    private void explode(String provisioningUrl, File out) {
        try {
            ZipUtil.explode(URI.create(provisioningUrl), out);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long getTimeout() {
        return this.testTimeout;
    }

    public long getExamTimeout() {
        return this.examTimeout;
    }

    private File getGfHome() {
        return this.gfHome;
    }

    public Option[] getPaxExamConfiguration() throws IOException {
        this.install();
        return new PaxExamConfigurator(this.getGfHome(), this.getExamTimeout()).configure();
    }

    static {
        ManagementFactory.getPlatformMBeanServer();
        System.setProperty("java.protocol.handler.pkgs", "org.ops4j.pax.url");
    }
}

