/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.fighterfish.test.util;

import java.util.Hashtable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class WABDeploymentEventHandler
implements EventHandler {
    private Callback callback;
    private ServiceRegistration registration;

    public WABDeploymentEventHandler(BundleContext context, Bundle b, Callback callback) {
        this.callback = callback;
        String[] topics = new String[]{"org/osgi/service/web/*"};
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("event.topics", topics);
        String filterString = "(bundle.id=" + b.getBundleId() + ")";
        ht.put("event.filter", filterString);
        this.registration = context.registerService(EventHandler.class.getName(), (Object)this, ht);
    }

    public void handleEvent(Event event) {
        String topic = event.getTopic();
        System.out.println(topic);
        System.out.println("event = " + event);
        if ("org/osgi/service/web/DEPLOYING".equals(topic)) {
            this.callback.deploying();
        } else if ("org/osgi/service/web/DEPLOYED".equals(topic)) {
            String contextPath = (String)event.getProperty("context.path");
            this.callback.deployed(contextPath);
        } else if ("org/osgi/service/web/FAILED".equals(topic)) {
            Throwable throwable = (Throwable)event.getProperty("exception");
            String collision = (String)event.getProperty("collision");
            Long[] collisionBundleIds = (Long[])event.getProperty("collision.bundles");
            this.callback.failed(throwable, collision, collisionBundleIds);
        } else if ("org/osgi/service/web/UNDEPLOYING".equals(topic)) {
            this.callback.undeploying();
        } else if ("org/osgi/service/web/UNDEPLOYED".equals(topic)) {
            this.callback.undeployed();
        }
    }

    public void stop() {
        this.registration.unregister();
    }

    public static interface Callback {
        public void deploying();

        public void deployed(String var1);

        public void undeploying();

        public void undeployed();

        public void failed(Throwable var1, String var2, Long[] var3);
    }
}

