/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.fighterfish.test.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.fighterfish.test.util.PropertiesUtil;
import org.glassfish.fighterfish.test.util.Version;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.OptionUtils;
import org.ops4j.pax.exam.options.UrlProvisionOption;

public class PaxExamConfigurator {
    protected Logger logger = Logger.getLogger(this.getClass().getPackage().getName());
    private File gfHome;
    private final long timeout;

    public PaxExamConfigurator(File gfHome, long timeout) {
        this.gfHome = gfHome;
        this.timeout = timeout;
    }

    public Option[] configure() throws IOException {
        return OptionUtils.combine((Option[])OptionUtils.combine((Option[])this.frameworkConfiguration(), (Option[])this.provisioningBundles()), (Option[])this.paxConfiguration());
    }

    private Option[] provisioningBundles() {
        String version = Version.getVersion();
        this.logger.logp(Level.INFO, "PaxExamConfigurator", "provisioningBundles", "FighterFish Test Util Version = {0}", new Object[]{version});
        UrlProvisionOption gfBundle = CoreOptions.bundle((String)new File(this.gfHome, "modules/glassfish.jar").toURI().toString());
        return CoreOptions.options((Option[])new Option[]{gfBundle, CoreOptions.junitBundles(), CoreOptions.mavenBundle().groupId("org.apache.httpcomponents").artifactId("httpclient-osgi").version("4.2.4"), CoreOptions.mavenBundle().groupId("org.apache.httpcomponents").artifactId("httpcore-osgi").version("4.2.4"), CoreOptions.mavenBundle().groupId("org.glassfish.fighterfish").artifactId("test.util").version(version)});
    }

    private Option[] frameworkConfiguration() throws IOException {
        Properties properties = this.readFrameworkConfiguration();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object orig = properties.get(entry.getKey());
            String override = System.getProperty((String)entry.getKey());
            if (override == null) continue;
            if (((String)String.class.cast(entry.getKey())).startsWith("felix.fileinstall.")) {
                this.logger.logp(Level.INFO, "PaxExamConfigurator", "frameworkConfiguration", "Ignoring overriding of {0}", new Object[]{entry});
                continue;
            }
            properties.put(entry.getKey(), override);
            this.logger.logp(Level.INFO, "PaxExamConfigurator", "frameworkConfiguration", "entry = {0}, original = {1}, override = {2}", new Object[]{entry.getKey(), orig, override});
        }
        List<Option> options = this.convertToOptions(properties);
        return options.toArray(new Option[options.size()]);
    }

    private Option[] paxConfiguration() {
        return CoreOptions.options((Option[])new Option[]{CoreOptions.systemTimeout((long)this.timeout)});
    }

    private List<Option> convertToOptions(Properties properties) {
        ArrayList<Option> options = new ArrayList<Option>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (entry.getKey().equals("org.osgi.framework.storage")) {
                options.add((Option)CoreOptions.workingDirectory((String)((String)entry.getValue())));
                this.logger.logp(Level.INFO, "PaxExamConfigurator", "convertToOptions", "OSGi cache dir = {0}", new Object[]{entry.getValue()});
            }
            options.add((Option)CoreOptions.frameworkProperty((String)((String)entry.getKey())).value(entry.getValue()));
        }
        options.add((Option)CoreOptions.cleanCaches((boolean)false));
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readFrameworkConfiguration() throws IOException {
        Properties properties = new Properties();
        this.logger.logp(Level.INFO, "DefaultPaxExamConfiguration", "readFrameworkConfiguration", "fwConfigFileName = {0}", new Object[]{"OSGiFramework.properties"});
        InputStream stream = this.getClass().getResourceAsStream("OSGiFramework.properties");
        if (stream != null) {
            try {
                properties.load(stream);
            }
            finally {
                stream.close();
            }
            PropertiesUtil.substVars(properties);
        } else {
            this.logger.logp(Level.WARNING, "DefaultPaxExamConfiguration", "readFrameworkConfiguration", "{0} not found. Using default values", new Object[]{"OSGiFramework.properties"});
        }
        return properties;
    }
}

