/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.fighterfish.test.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.glassfish.fighterfish.test.util.TestsConfiguration;
import org.glassfish.fighterfish.test.util.TimeoutException;
import org.glassfish.fighterfish.test.util.WABDeploymentEventHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class WebAppBundle {
    private BundleContext context;
    private Bundle b;
    private String contextPath;
    private State state;
    private CountDownLatch deploymentSignal = new CountDownLatch(1);
    private int requestReadTimeout = -1;

    public WebAppBundle(BundleContext context, Bundle b) {
        this.context = context;
        this.b = b;
    }

    public ServletContext deploy(long timeout, TimeUnit timeUnit) throws InterruptedException, BundleException, TimeoutException {
        WABDeploymentEventHandler eventHandler = new WABDeploymentEventHandler(this.context, this.b, new WABDeploymentEventHandler.Callback(){

            @Override
            public void deploying() {
                WebAppBundle.this.state = State.DEPLOYING;
            }

            @Override
            public void deployed(String contextPath) {
                WebAppBundle.this.state = State.DEPLOYED;
                WebAppBundle.this.contextPath = contextPath;
                WebAppBundle.this.deploymentSignal.countDown();
            }

            @Override
            public void undeploying() {
                WebAppBundle.this.state = State.UNDEPLOYING;
            }

            @Override
            public void undeployed() {
                WebAppBundle.this.state = State.UNDEPLOYED;
            }

            @Override
            public void failed(Throwable throwable, String collision, Long[] collisionBundleIds) {
                WebAppBundle.this.state = State.FAILED;
                WebAppBundle.this.deploymentSignal.countDown();
            }
        });
        this.b.start(1);
        this.deploymentSignal.await(timeout, timeUnit);
        if (State.DEPLOYED.equals((Object)this.state)) {
            return (ServletContext)this.context.getService(this.context.getServiceReference(ServletContext.class.getName()));
        }
        throw new TimeoutException("Deployment timedout. Check log to see what exactly went wrong.");
    }

    public void undeploy() throws BundleException {
        this.b.stop(1);
    }

    public ServletContext getServletContext() {
        return (ServletContext)this.context.getService(this.context.getServiceReference(ServletContext.class.getName()));
    }

    private String getHost() {
        return "localhost";
    }

    private int getPort() {
        return 8080;
    }

    public Bundle getBundle() {
        return this.b;
    }

    public String getHttpPostResponse(String relativePath) throws IOException {
        return this.getHttpResponseUsingHttpClient(relativePath, "POST", null);
    }

    public String getHttpPostResponse(String relativePath, String contentType) throws IOException {
        return this.getHttpResponseUsingHttpClient(relativePath, "POST", contentType);
    }

    public String getHttpGetResponse(String relativePath) throws IOException {
        return this.getHttpResponseUsingHttpClient(relativePath, "GET", null);
    }

    private String getHttpResponseUsingHttpClient(String relativePath, String mode, String contentType) throws IOException {
        String result = null;
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            String inputLine;
            HttpResponse response;
            BasicHttpParams httpParameters = new BasicHttpParams();
            int readTimeout = this.getRequestReadTimeout();
            HttpConnectionParams.setSoTimeout((HttpParams)httpParameters, (int)readTimeout);
            httpClient.setParams((HttpParams)httpParameters);
            URL serverAddress = new URL("http", this.getHost(), this.getPort(), this.contextPath + relativePath);
            Object httpRequest = null;
            httpRequest = "GET".endsWith(mode) ? new HttpGet() : new HttpPost();
            try {
                httpRequest.setURI(serverAddress.toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            if (contentType != null) {
                httpRequest.setHeader("Content-Type", contentType);
            }
            if ((response = httpClient.execute((HttpUriRequest)httpRequest)).getStatusLine().getStatusCode() == 404) {
                throw new FileNotFoundException("Request Resource is not available.");
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuilder sb = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                sb.append(inputLine);
            }
            result = sb.toString();
            in.close();
        }
        catch (SocketTimeoutException e) {
            throw new TimeoutException(e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        return result;
    }

    public void setRequestReadTimeout(int requestReadTimeout) {
        this.requestReadTimeout = requestReadTimeout;
    }

    private int getRequestReadTimeout() {
        return this.requestReadTimeout > 0 ? this.requestReadTimeout : (int)Math.min(TestsConfiguration.getInstance().getTimeout(), Integer.MAX_VALUE);
    }

    static enum State {
        DEPLOYING,
        DEPLOYED,
        UNDEPLOYING,
        UNDEPLOYED,
        FAILED;

    }
}

