/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.inbound;

import com.sun.genericra.GenericJMSRA;
import com.sun.genericra.inbound.AbstractJmsResourcePool;
import com.sun.genericra.inbound.ActivationSpec;
import com.sun.genericra.util.ExceptionUtils;
import com.sun.genericra.util.LogUtils;
import com.sun.genericra.util.ObjectBuilder;
import com.sun.genericra.util.ObjectBuilderFactory;
import com.sun.genericra.util.StringManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Topic;
import javax.jms.XAConnectionFactory;
import javax.resource.ResourceException;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.endpoint.MessageEndpointFactory;

public abstract class AbstractConsumer {
    protected static Logger logger;
    protected static StringManager sm;
    protected GenericJMSRA ra = null;
    protected ActivationSpec spec = null;
    Object cf = null;
    Object dmdCf = null;
    protected Destination dest = null;
    protected Destination dmd = null;
    protected transient MessageEndpointFactory mef = null;
    protected boolean stopped = false;
    protected boolean transacted = false;

    public AbstractConsumer(MessageEndpointFactory mef, javax.resource.spi.ActivationSpec actspec) throws ResourceException {
        actspec.validate();
        this.spec = (ActivationSpec)actspec;
        this.ra = (GenericJMSRA)this.spec.getResourceAdapter();
        this.mef = mef;
        this.initializeAdministeredObjects();
    }

    public Destination getDestination() {
        return this.dest;
    }

    private void initializeAdministeredObjects() throws ResourceException {
        String className = this.getAppropriateCFClassName();
        ObjectBuilder cfBuilder = null;
        ObjectBuilderFactory obf = this.ra.getObjectBuilderFactory();
        ObjectBuilder destBuilder = null;
        if (this.spec.getProviderIntegrationMode().equalsIgnoreCase("jndi")) {
            cfBuilder = obf.createUsingJndiName(this.spec.getConnectionFactoryJndiName(), this.spec.getJndiProperties());
            destBuilder = obf.createUsingJndiName(this.spec.getDestinationJndiName(), this.spec.getJndiProperties());
        } else {
            cfBuilder = obf.createUsingClassName(className);
            cfBuilder.setProperties(this.spec.getConnectionFactoryProperties());
            destBuilder = obf.createUsingClassName(this.getDestinationClassNameFromType(this.spec.getDestinationType()));
            destBuilder.setProperties(this.spec.getDestinationProperties());
        }
        String setMethod = this.spec.getCommonSetterMethodName();
        if (this.isNotNull(setMethod)) {
            cfBuilder.setCommonSetterMethodName(setMethod);
            destBuilder.setCommonSetterMethodName(setMethod);
        }
        this.cf = cfBuilder.build();
        this.dest = (Destination)destBuilder.build();
        ObjectBuilder dmdBuilder = null;
        ObjectBuilder dmdCfBuilder = null;
        if (this.spec.getSendBadMessagesToDMD()) {
            if (this.spec.getProviderIntegrationMode().equalsIgnoreCase("jndi")) {
                dmdCfBuilder = obf.createUsingJndiName(this.spec.getDeadMessageConnectionFactoryJndiName(), this.spec.getJndiProperties());
                dmdBuilder = obf.createUsingJndiName(this.spec.getDeadMessageDestinationJndiName(), this.spec.getJndiProperties());
            } else {
                if (this.spec.getDeadMessageDestinationClassName() == null) {
                    dmdCfBuilder = obf.createUsingClassName(this.getAppropriateDMDCFClassName());
                    dmdCfBuilder.setProperties(this.spec.getDeadMessageConnectionFactoryProperties());
                    dmdBuilder = obf.createUsingClassName(this.getDestinationClassNameFromType(this.spec.getDeadMessageDestinationType()));
                } else {
                    dmdCfBuilder = obf.createUsingClassName(this.getAppropriateCFClassName());
                    dmdCfBuilder.setProperties(this.spec.getConnectionFactoryProperties());
                    dmdBuilder = obf.createUsingClassName(this.spec.getDeadMessageDestinationClassName());
                }
                dmdBuilder.setProperties(this.spec.getDeadMessageDestinationProperties());
            }
            if (this.isNotNull(setMethod)) {
                dmdBuilder.setCommonSetterMethodName(setMethod);
                dmdCfBuilder.setCommonSetterMethodName(setMethod);
            }
            this.dmd = (Destination)dmdBuilder.build();
            this.dmdCf = dmdCfBuilder.build();
        }
    }

    private String getAppropriateCFClassName() throws ResourceException {
        if (this.spec.getSupportsXA()) {
            if (this.spec.getDestinationType() == null || this.spec.getDestinationType().equalsIgnoreCase("")) {
                throw new ResourceException("DestionationType not specified in the activation spec.");
            }
            if (this.spec.getDestinationType().equalsIgnoreCase("javax.jms.Queue")) {
                return this.spec.getXAQueueConnectionFactoryClassName();
            }
            if (this.spec.getDestinationType().equalsIgnoreCase("javax.jms.Topic")) {
                return this.spec.getXATopicConnectionFactoryClassName();
            }
            return this.spec.getXAConnectionFactoryClassName();
        }
        if (this.spec.getDestinationType().equalsIgnoreCase("javax.jms.Queue")) {
            return this.spec.getQueueConnectionFactoryClassName();
        }
        if (this.spec.getDestinationType().equalsIgnoreCase("javax.jms.Topic")) {
            return this.spec.getTopicConnectionFactoryClassName();
        }
        return this.spec.getConnectionFactoryClassName();
    }

    private String getAppropriateDMDCFClassName() throws ResourceException {
        if (this.spec.getDeadMessageDestinationType().equalsIgnoreCase("javax.jms.Queue")) {
            return this.spec.getQueueConnectionFactoryClassName();
        }
        if (this.spec.getDeadMessageDestinationType().equalsIgnoreCase("javax.jms.Topic")) {
            return this.spec.getTopicConnectionFactoryClassName();
        }
        return this.spec.getConnectionFactoryClassName();
    }

    public Destination getDmdDestination() {
        return this.dmd;
    }

    private String getDestinationClassNameFromType(String destinationType) {
        if (destinationType.equals("javax.jms.Queue")) {
            return this.spec.getQueueClassName();
        }
        if (destinationType.equals("javax.jms.Topic")) {
            return this.spec.getTopicClassName();
        }
        return this.spec.getUnifiedDestinationClassName();
    }

    private boolean isNotNull(String s) {
        return s != null && !s.trim().equals("");
    }

    public Object getDmdConnectionFactory() {
        return this.dmdCf;
    }

    public Object getConnectionFactory() {
        return this.cf;
    }

    public MessageEndpointFactory getMessageEndpointFactory() {
        return this.mef;
    }

    public ActivationSpec getSpec() {
        return this.spec;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.ra;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void validate() throws ResourceException {
        if (this.transacted && !this.spec.getSupportsXA()) {
            String msg = sm.getString("provider_cannot_support_transaction");
            throw new ResourceException(msg);
        }
        if (this.spec.getSubscriptionDurability().equals("Durable") && !(this.dest instanceof Topic)) {
            String msg = sm.getString("durable_shouldbe_topic");
            throw new ResourceException(msg);
        }
        if (this.spec.getSupportsXA() && !(this.cf instanceof XAConnectionFactory)) {
            String msg = sm.getString("cf_doesnot_supportsxa");
            throw new ResourceException(msg);
        }
    }

    public void setTransaction() {
        try {
            this.transacted = this.mef.isDeliveryTransacted(this.ra.getListeningMethod());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void setClientId() throws ResourceException {
        try {
            if (this.spec.getClientID() != null) {
                if (!this.spec.getShareClientid() && this.spec.getInstanceCount() > 1) {
                    try {
                        String clientid = null;
                        clientid = this.spec.getInstanceClientId() != null ? this.spec.getInstanceClientId() : (this.spec.getInstanceID() == 0 ? this.spec.getClientID() : this.spec.getClientID().substring(0, this.spec.getClientID().length() - 1) + this.spec.getInstanceID());
                        this.getConnection().setClientID(clientid);
                        logger.log(Level.INFO, "Setting the clientID to : " + clientid);
                    }
                    catch (Exception ce) {
                        logger.log(Level.SEVERE, "Failed to generate clientID to : " + ce.getMessage());
                    }
                } else {
                    this.getConnection().setClientID(this.spec.getClientID());
                    logger.log(Level.INFO, "Setting the clientID to : " + this.spec.getClientID());
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.newResourceException(e);
        }
    }

    public abstract void initialize(boolean var1) throws ResourceException;

    public abstract void start() throws ResourceException;

    public abstract void stop();

    public abstract Connection getConnection();

    public abstract AbstractJmsResourcePool getPool();

    static {
        sm = StringManager.getManager(GenericJMSRA.class);
        logger = LogUtils.getLogger();
    }
}

