/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.inbound;

import com.sun.genericra.GenericJMSRA;
import com.sun.genericra.GenericJMSRAProperties;
import com.sun.genericra.util.Constants;
import com.sun.genericra.util.LogUtils;
import com.sun.genericra.util.StringManager;
import com.sun.genericra.util.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.InvalidPropertyException;

public class ActivationSpec
extends GenericJMSRAProperties
implements javax.resource.spi.ActivationSpec {
    private static Logger logger = LogUtils.getLogger();
    private String cfJndiName;
    private String cfProperties;
    private String destJndiName;
    private String destProperties;
    private String destinationType = "javax.jms.Destination";
    private String dmType = "javax.jms.Destination";
    private String messageSelector;
    private String subscriptionDurability = "Non-Durable";
    private String subscriptionName;
    private String clientId;
    private int redeliveryAttempts;
    private int redeliveryInterval;
    private int reconnectAttempts;
    private int reconnectInterval;
    private int maxPoolSize = 8;
    private int maxWaitTime = 3;
    private boolean isDmd = false;
    private String dmClassName;
    private String dmJndiName;
    private String dmCfJndiName;
    private String dmProperties;
    private String dmCfProperties;
    private int endpointReleaseTimeout = 180;
    private boolean shareclientid = false;
    private int instanceCount = 1;
    private boolean loadBalance = true;
    private String mCurrentInstance = "0";
    private int mCurrentInstanceNo = 0;
    private String mMessageSelector = "";
    private String mInstanceClientId = null;
    private static String SELECTOR_PROPERTY = "com.sun.genericra.loadbalancing.selector";
    private static String INSTANCENO_PROPERTY = "com.sun.genericra.loadbalancing.instance.id";
    private static String INSTANCE_CLIENTID_PROPERTY = "com.sun.genericra.loadbalancing.instance.clientid";
    private int batchSize = 1;
    private boolean huaMode = false;
    private int ackTimeOut = Constants.DEFAULT_ACK_TIMEOUT;
    private StringManager sm = StringManager.getManager(GenericJMSRA.class);
    private String applicationName;

    public void setMaxWaitTime(int waitTime) {
        this.maxWaitTime = waitTime;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public void setRedeliveryInterval(int interval) {
        this.redeliveryInterval = interval;
    }

    public int getRedeliveryInterval() {
        return this.redeliveryInterval;
    }

    public void setRedeliveryAttempts(int attempts) {
        this.redeliveryAttempts = attempts;
    }

    public int getRedeliveryAttempts() {
        return this.redeliveryAttempts;
    }

    public void setInstanceCount(int instancecount) {
        this.instanceCount = instancecount;
    }

    public int getInstanceCount() {
        return this.instanceCount;
    }

    public void setLoadBalancingRequired(boolean loadbalance) {
        this.loadBalance = loadbalance;
    }

    public boolean getLoadBalancingRequired() {
        return this.loadBalance;
    }

    public int getInstanceID() {
        try {
            this.mCurrentInstance = System.getProperty(INSTANCENO_PROPERTY, "0");
            this.mCurrentInstanceNo = Integer.parseInt(this.mCurrentInstance.trim());
        }
        catch (Exception e) {
            this.mCurrentInstanceNo = 0;
        }
        return this.mCurrentInstanceNo;
    }

    public String getInstanceClientId() {
        try {
            this.mInstanceClientId = System.getProperty(INSTANCE_CLIENTID_PROPERTY);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mInstanceClientId;
    }

    public String getLoadBalancingSelector() {
        try {
            this.mMessageSelector = System.getProperty(SELECTOR_PROPERTY, "");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mMessageSelector = "";
        }
        return this.mMessageSelector;
    }

    public void setReconnectInterval(int interval) {
        this.reconnectInterval = interval;
    }

    public int getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void setReconnectAttempts(int attempts) {
        this.reconnectAttempts = attempts;
    }

    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public void setSubscriptionDurability(String durability) {
        this.subscriptionDurability = durability;
    }

    public String getSubscriptionDurability() {
        return this.subscriptionDurability;
    }

    public void setSubscriptionName(String name) {
        this.subscriptionName = name;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setMessageSelector(String selector) {
        this.messageSelector = selector;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setClientID(String clientId) {
        this.clientId = clientId;
    }

    public String getClientID() {
        return this.clientId;
    }

    public void setConnectionFactoryJndiName(String name) {
        this.cfJndiName = name;
    }

    public String getConnectionFactoryJndiName() {
        return this.cfJndiName;
    }

    public void setDestinationJndiName(String name) {
        this.destJndiName = name;
    }

    public String getDestinationJndiName() {
        return this.destJndiName;
    }

    public void setDestinationProperties(String properties) {
        this.destProperties = properties;
    }

    public String getDestinationProperties() {
        return this.destProperties;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setSendBadMessagesToDMD(boolean isDmd) {
        this.isDmd = isDmd;
    }

    public boolean getSendBadMessagesToDMD() {
        return this.isDmd;
    }

    public void setDeadMessageJndiName(String jndiName) {
        this.dmJndiName = jndiName;
    }

    public void setDeadMessageConnectionFactoryProperties(String p) {
        this.dmCfProperties = p;
    }

    public String getDeadMessageConnectionFactoryProperties() {
        return this.dmCfProperties;
    }

    public void setDeadMessageConnectionFactoryJndiName(String jndiName) {
        this.dmCfJndiName = jndiName;
    }

    public String getDeadMessageConnectionFactoryJndiName() {
        return this.dmCfJndiName;
    }

    public void setDeadMessageDestinationJndiName(String jndiName) {
        this.dmJndiName = jndiName;
    }

    public String getDeadMessageDestinationJndiName() {
        return this.dmJndiName;
    }

    public void setDeadMessageDestinationClassName(String className) {
        this.dmClassName = className;
    }

    public String getDeadMessageDestinationClassName() {
        return this.dmClassName;
    }

    public void setDeadMessageDestinationProperties(String dmdProps) {
        this.dmProperties = dmdProps;
    }

    public String getDeadMessageDestinationProperties() {
        return this.dmProperties;
    }

    public String getDeadMessageDestinationType() {
        return this.dmType;
    }

    public void setDeadMessageDestinationType(String dmType) {
        this.dmType = dmType;
    }

    public void setEndpointReleaseTimeout(int secs) {
        this.endpointReleaseTimeout = secs;
    }

    public int getEndpointReleaseTimeout() {
        return this.endpointReleaseTimeout;
    }

    public boolean getShareClientid() {
        return this.shareclientid;
    }

    public void setShareClientid(boolean genclientid) {
        this.shareclientid = genclientid;
    }

    public void validate() throws InvalidPropertyException {
        logger.log(Level.FINE, "" + this);
        if (this.getMaxPoolSize() <= 0) {
            String msg = this.sm.getString("maxpoolsize_iszero");
            throw new InvalidPropertyException(msg);
        }
        if (this.getMaxWaitTime() < 0) {
            String msg = this.sm.getString("maxwaittime_lessthan_zero");
            throw new InvalidPropertyException(msg);
        }
        if (this.getRedeliveryAttempts() < 0) {
            String msg = this.sm.getString("redelivery_attempts_lessthan_zero");
            throw new InvalidPropertyException(msg);
        }
        if (this.getRedeliveryInterval() < 0) {
            String msg = this.sm.getString("redelivery_attempts_lessthan_zero");
            throw new InvalidPropertyException(msg);
        }
        if (this.getEndpointReleaseTimeout() < 0) {
            String msg = this.sm.getString("endpointreleasetimeout_lessthan_zero");
            throw new InvalidPropertyException(msg);
        }
        if (this.getInstanceCount() < 1) {
            String msg = this.sm.getString("instancecount_lessthan_zero");
            throw new InvalidPropertyException(msg);
        }
        if (this.getInstanceID() < 0 || this.getInstanceID() >= this.getInstanceCount()) {
            String msg = this.sm.getString("instanceid_should_be_between_0_and_instancecount");
            throw new InvalidPropertyException(msg);
        }
        if (this.getSendBadMessagesToDMD()) {
            if (this.getProviderIntegrationMode().equalsIgnoreCase("jndi")) {
                if (StringUtils.isNull(this.getDeadMessageDestinationJndiName())) {
                    String msg = this.sm.getString("dmd_jndi_null");
                    throw new InvalidPropertyException(msg);
                }
            } else if (StringUtils.isNull(this.getDeadMessageDestinationProperties())) {
                String msg = this.sm.getString("dmd_props_null");
                throw new InvalidPropertyException(msg);
            }
        }
    }

    public String toString() {
        String s = super.toString();
        s = s + "{RedeliveryInterval = " + this.getRedeliveryInterval() + "},";
        s = s + "{RedeliveryAttempts = " + this.getRedeliveryAttempts() + "},";
        s = s + "{ClientID = " + this.getClientID() + "},";
        s = s + "{MessageSelector = " + this.getMessageSelector() + "},";
        s = s + "{SubscriptionDurability = " + this.getSubscriptionDurability() + "},";
        s = s + "{ConnectionFactoryJNDIName = " + this.getConnectionFactoryJndiName() + "},";
        s = s + "{SubscriptionName = " + this.getSubscriptionName() + "},";
        s = s + "{DestinationJNDIName = " + this.getDestinationJndiName() + "},";
        s = s + "{DestinationType = " + this.getDestinationType() + "},";
        s = s + "{DeadMessageDestinationType = " + this.getDeadMessageDestinationType() + "},";
        s = s + "{MaxPoolSize = " + this.getMaxPoolSize() + "},";
        s = s + "{DestinationProperties = " + this.getDestinationProperties() + "},";
        s = s + "{DeadMessageDestinationJndiName = " + this.getDeadMessageDestinationJndiName() + "},";
        s = s + "{DeadMessageConnectionFactoryJndiName = " + this.getDeadMessageConnectionFactoryJndiName() + "},";
        s = s + "{DeadMessageConnectionFactoryProperties = " + this.getDeadMessageConnectionFactoryProperties() + "},";
        s = s + "{DeadMessageDestinationClassName = " + this.getDeadMessageDestinationClassName() + "},";
        s = s + "{DeadMessageDestinationProperties = " + this.getDeadMessageDestinationProperties() + "},";
        s = s + "{SendBadMessagesToDMD = " + this.getSendBadMessagesToDMD() + "},";
        s = s + "{EndpointReleaseTimeOut = " + this.getEndpointReleaseTimeout() + "},";
        s = s + "{InstanceCount = " + this.getInstanceCount() + "},";
        s = s + "{LoadBalancingRequired = " + this.getLoadBalancingRequired() + "},";
        s = s + "{Instance ID = " + this.getInstanceID() + "},";
        s = s + "{CustomLoadBalancingMessageSelector = " + this.getLoadBalancingSelector() + "},";
        s = s + "{ShareClientID = " + this.getShareClientid() + "}";
        s = s + "{DeliveryType = " + this.getDeliveryType() + "}";
        return s;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(String destinationType) {
        this.destinationType = destinationType;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int size) {
        this.batchSize = size;
    }

    public void setHUAMode(boolean huamode) {
        this.huaMode = huamode;
    }

    public boolean getHUAMode() {
        return this.huaMode;
    }

    public void setAckTimeOut(int timeout) {
        this.ackTimeOut = timeout;
    }

    public int getAckTimeOut() {
        return this.ackTimeOut;
    }
}

