/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.inbound.async;

import com.sun.genericra.GenericJMSRA;
import com.sun.genericra.inbound.AbstractJmsResourcePool;
import com.sun.genericra.inbound.async.EndpointConsumer;
import com.sun.genericra.inbound.async.InboundJmsResource;
import com.sun.genericra.util.ExceptionUtils;
import com.sun.genericra.util.LogUtils;
import com.sun.genericra.util.StringManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XASession;
import javax.resource.ResourceException;
import javax.transaction.xa.XAResource;

public class InboundJmsResourcePool
extends AbstractJmsResourcePool
implements ServerSessionPool {
    private static Logger _logger = LogUtils.getLogger();
    private ArrayList resources;
    private int maxSize;
    private int connectionsInUse = 0;
    private long maxWaitTime;
    private LinkedList waitQ = null;
    private long TIME_OUT = 180000L;
    private StringManager sm = StringManager.getManager(GenericJMSRA.class);

    public InboundJmsResourcePool(EndpointConsumer consumer, boolean transacted) {
        super(consumer, transacted);
        this.waitQ = new LinkedList();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public long getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public int getCurrentResources() {
        int ret = 0;
        if (this.resources != null) {
            ret = this.resources.size();
        }
        return ret;
    }

    public int getBusyResources() {
        int busy = 0;
        if (this.resources != null) {
            Iterator it = this.resources.iterator();
            while (it.hasNext()) {
                InboundJmsResource resource = (InboundJmsResource)it.next();
                if (resource.isFree()) continue;
                ++busy;
            }
        }
        return busy;
    }

    public int getFreeResources() {
        int free = 0;
        if (this.resources != null) {
            Iterator it = this.resources.iterator();
            while (it.hasNext()) {
                InboundJmsResource resource = (InboundJmsResource)it.next();
                if (!resource.isFree()) continue;
                ++free;
            }
        }
        return free;
    }

    public int getConnectionsInUse() {
        return this.connectionsInUse;
    }

    public int getWaiting() {
        int wait = 0;
        if (this.waitQ != null) {
            wait = this.waitQ.size();
        }
        return wait;
    }

    public ConnectionConsumer createConnectionConsumer(Destination dest, String name, int maxMessages) throws JMSException {
        ConnectionConsumer conconsumer = null;
        Connection con = this.getConnection();
        if (this.isTopic()) {
            String selector = this.constructSelector(name);
            conconsumer = ((TopicConnection)con).createConnectionConsumer((Topic)dest, selector, (ServerSessionPool)this, maxMessages);
        } else {
            conconsumer = this.isQueue() ? ((QueueConnection)con).createConnectionConsumer((Queue)dest, name, (ServerSessionPool)this, maxMessages) : con.createConnectionConsumer(dest, name, (ServerSessionPool)this, maxMessages);
        }
        return conconsumer;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Destination dest, String name, String sel, int maxMessages) throws JMSException {
        ConnectionConsumer conconsumer = null;
        Connection con = this.getConnection();
        String selector = this.constructSelector(sel);
        conconsumer = ((TopicConnection)con).createDurableConnectionConsumer((Topic)dest, name, selector, (ServerSessionPool)this, maxMessages);
        return conconsumer;
    }

    public synchronized void initialize() throws ResourceException {
        try {
            this.resources = new ArrayList();
            this.maxSize = this.consumer.getSpec().getMaxPoolSize();
            this.maxWaitTime = this.consumer.getSpec().getMaxWaitTime() * 1000;
            if (this.consumer.getSpec().getSupportsXA()) {
                XAConnectionFactory xacf = (XAConnectionFactory)this.consumer.getConnectionFactory();
                this.con = this.createXAConnection(xacf);
                ConnectionFactory cf = (ConnectionFactory)this.consumer.getDmdConnectionFactory();
                if (this.consumer.getSpec().getSendBadMessagesToDMD()) {
                    this.dmdCon = this.createDmdConnection(cf);
                }
            } else {
                if (!(this.consumer.getConnectionFactory() instanceof ConnectionFactory)) {
                    String msg = this.sm.getString("classtype_not_correct", this.consumer.getConnectionFactory().getClass().getName());
                    throw new ResourceException(msg);
                }
                this.cf = (ConnectionFactory)this.consumer.getConnectionFactory();
                this.con = this.createConnection(this.cf);
            }
            this.stopped = false;
        }
        catch (JMSException e) {
            throw ExceptionUtils.newResourceException(e);
        }
    }

    public InboundJmsResource create() throws JMSException {
        _logger.log(Level.FINER, "Creating the ServerSession");
        Session sess = null;
        XAResource xar = null;
        if (this.transacted) {
            sess = this.createXASession((XAConnection)this.con);
            xar = this.getXAResource((XASession)sess);
            _logger.log(Level.FINE, "Created new XA ServerSession");
        } else {
            sess = this.createSession(this.con);
            _logger.log(Level.FINE, "Created new ServerSession");
        }
        return new InboundJmsResource(sess, this, xar);
    }

    public ServerSession getServerSession() throws JMSException {
        InboundJmsResource result = null;
        PauseObject obj = null;
        while (result == null) {
            this.validate();
            result = this._getServerSession();
            if (result != null || this.maxWaitTime < 0L) continue;
            if (obj == null) {
                obj = new PauseObject();
            }
            obj.pauseCallingThread();
        }
        return result.refreshListener();
    }

    public void validate() throws JMSException {
        if (this.destroyed) {
            String msg = this.sm.getString("serversession_pool_destroyed");
            throw new JMSException(msg);
        }
    }

    private synchronized InboundJmsResource _getServerSession() throws JMSException {
        _logger.log(Level.FINER, "JMS provider is getting the ServerSession");
        if (this.stopped) {
            return null;
        }
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            InboundJmsResource resource = (InboundJmsResource)it.next();
            if (!resource.isFree()) continue;
            ++this.connectionsInUse;
            return resource.markAsBusy();
        }
        if (this.resources.size() < this.maxSize) {
            InboundJmsResource res = this.create();
            this.resources.add(res);
            ++this.connectionsInUse;
            return res.markAsBusy();
        }
        return null;
    }

    public synchronized void put(InboundJmsResource resource) {
        resource.markAsFree();
        --this.connectionsInUse;
        if (this.stopped) {
            if (this.connectionsInUse <= 0) {
                this.notify();
            }
        } else {
            this.resumeWaitingThread();
        }
    }

    public void stop() throws JMSException {
        this.stopped = true;
        this.maxWaitTime = 0L;
        this.waitForAll();
        this.releaseAllResources();
        if (this.dmdCon != null) {
            this.dmdCon.close();
        }
    }

    public void destroy() throws JMSException {
        this.destroyed = true;
        this.stop();
        this.releaseAllWaitingThreads();
    }

    public synchronized void waitForAll() {
        if (this.connectionsInUse > 0) {
            _logger.log(Level.FINE, "Waiting for " + this.connectionsInUse + " ServerSessions" + " to come back to pool");
            try {
                this.wait(this.consumer.getSpec().getEndpointReleaseTimeout() * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void releaseAllWaitingThreads() {
        Iterator it = this.waitQ.iterator();
        int count = 0;
        while (it.hasNext()) {
            PauseObject obj = (PauseObject)it.next();
            obj.resume();
            ++count;
        }
        _logger.log(Level.FINE, "Released a total of " + count + " requests");
    }

    public void releaseAllResources() {
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            InboundJmsResource obj = (InboundJmsResource)it.next();
            try {
                obj.destroy();
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "Cannot destroy resource " + obj.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeWaitingThread() {
        PauseObject obj = null;
        LinkedList linkedList = this.waitQ;
        synchronized (linkedList) {
            if (this.waitQ.size() > 0) {
                obj = (PauseObject)this.waitQ.removeFirst();
            }
        }
        if (obj != null) {
            obj.resume();
        }
    }

    class PauseObject {
        long startTime = 0L;
        long elapsedWaitTime = 0L;
        long remainingWaitTime = 0L;

        PauseObject() {
        }

        void pauseCallingThread() throws JMSException {
            if (InboundJmsResourcePool.this.maxWaitTime == 0L) {
                this.remainingWaitTime = 0L;
                this.startTime = 0L;
            } else {
                if (this.startTime == 0L) {
                    this.startTime = System.currentTimeMillis();
                }
                this.elapsedWaitTime = this.startTime - System.currentTimeMillis();
                if (this.elapsedWaitTime > InboundJmsResourcePool.this.maxWaitTime) {
                    String msg = InboundJmsResourcePool.this.sm.getString("pool_limit_reached");
                    throw new JMSException(msg);
                }
                this.remainingWaitTime = this.startTime - this.elapsedWaitTime;
            }
            this.pause();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void pause() {
            LinkedList linkedList = InboundJmsResourcePool.this.waitQ;
            synchronized (linkedList) {
                InboundJmsResourcePool.this.waitQ.addLast(this);
            }
            try {
                _logger.log(Level.FINE, "Waiting for :" + this.remainingWaitTime);
                this.wait(this.remainingWaitTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            linkedList = InboundJmsResourcePool.this.waitQ;
            synchronized (linkedList) {
                InboundJmsResourcePool.this.waitQ.remove(this);
            }
        }

        synchronized void resume() {
            _logger.log(Level.FINE, "Notifying the thread");
            this.notify();
        }
    }
}

