/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.inbound.sync;

import com.sun.genericra.AbstractXAResourceType;
import com.sun.genericra.inbound.ActivationSpec;
import com.sun.genericra.inbound.DeadMessageProducer;
import com.sun.genericra.inbound.FirstXAResourceProxy;
import com.sun.genericra.inbound.InboundXAResourceProxy;
import com.sun.genericra.inbound.SimpleXAResourceProxy;
import com.sun.genericra.inbound.sync.AckHandler;
import com.sun.genericra.inbound.sync.SyncJmsResource;
import com.sun.genericra.inbound.sync.SyncJmsResourcePool;
import com.sun.genericra.inbound.sync.TxMgr;
import com.sun.genericra.inbound.sync.WBytesMessageIn;
import com.sun.genericra.inbound.sync.WMapMessageIn;
import com.sun.genericra.inbound.sync.WMessageIn;
import com.sun.genericra.inbound.sync.WObjectMessageIn;
import com.sun.genericra.inbound.sync.WStreamMessageIn;
import com.sun.genericra.inbound.sync.WTextMessageIn;
import com.sun.genericra.util.ExceptionUtils;
import com.sun.genericra.util.LogUtils;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

public class SyncDeliveryHelper {
    private static Logger _logger = LogUtils.getLogger();
    private static TxMgr mTxMgr = new TxMgr();
    ActivationSpec spec;
    SyncJmsResource jmsResource;
    XAResource xar;
    Message msg = null;
    Destination dest = null;
    boolean transacted;
    boolean sentToDmd = false;
    boolean redeliveryFailed = false;
    Coordinator coord = null;
    boolean mHoldUntilAck;
    int acktimeout;
    private boolean mTxFailureLoggedOnce;

    public SyncDeliveryHelper(SyncJmsResource jmsResource, SyncJmsResourcePool pool) {
        this.spec = pool.getConsumer().getSpec();
        this.jmsResource = jmsResource;
        this.transacted = pool.isTransacted();
        this.mHoldUntilAck = this.spec.getHUAMode();
        this.acktimeout = this.spec.getAckTimeOut();
        AbstractXAResourceType xarObject = null;
        xarObject = this.redeliveryRequired() ? (this.spec.getUseFirstXAForRedelivery() ? new FirstXAResourceProxy(jmsResource.getXAResource()) : new InboundXAResourceProxy(jmsResource.getXAResource())) : new SimpleXAResourceProxy(jmsResource.getXAResource());
        xarObject.setRMPolicy(this.spec.getRMPolicy());
        xarObject.setConnection(pool.getConnection());
        this.xar = xarObject;
    }

    public boolean redeliveryRequired() {
        return this.transacted && this.spec.getRedeliveryAttempts() > 0;
    }

    public XAResource getXAResource() {
        return this.xar;
    }

    private DeadMessageProducer createProducer(Connection con, Destination dest) throws JMSException {
        return new DeadMessageProducer(con, this.jmsResource.getPool(), dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessageToDMD() {
        AbstractXAResourceType localXar;
        _logger.log(Level.FINE, "Trying to send message  to DMD :" + this.dest);
        Object session = null;
        DeadMessageProducer msgProducer = null;
        Exception dmdexception = null;
        boolean dmdSendSuccess = true;
        try {
            if (this.dest != null && this.spec.getSendBadMessagesToDMD()) {
                AbstractXAResourceType localXar2;
                _logger.log(Level.FINE, "Sending the message to DMD :" + this.dest);
                if (this.redeliveryRequired()) {
                    localXar = (AbstractXAResourceType)this.xar;
                    if (!localXar.endCalled()) {
                        localXar.end(null, 0x4000000);
                    }
                    localXar.prepare(null);
                    _logger.log(Level.FINE, "Prepared DMD transaction");
                } else {
                    localXar = (AbstractXAResourceType)this.xar;
                    localXar.end(null, 0x4000000);
                    localXar.prepare(null);
                    _logger.log(Level.FINE, "Prepared DMD transaction");
                }
                Connection connection = this.jmsResource.getPool().getConnectionForDMD();
                msgProducer = this.createProducer(connection, this.dest);
                msgProducer.send(this.msg);
                _logger.log(Level.FINE, "Sent message to DMD");
                if (this.redeliveryRequired()) {
                    localXar2 = (AbstractXAResourceType)this.xar;
                    localXar2.commit(null, false);
                    _logger.log(Level.FINE, "Commited DMD transaction");
                } else {
                    localXar2 = (AbstractXAResourceType)this.xar;
                    localXar2.commit(null, false);
                    _logger.log(Level.FINE, "Commited DMD transaction");
                }
            } else {
                dmdSendSuccess = false;
            }
        }
        catch (Exception e) {
            dmdSendSuccess = false;
            dmdexception = e;
            e.printStackTrace();
        }
        finally {
            this.msg = null;
            this.dest = null;
            this.sentToDmd = false;
            if (msgProducer != null) {
                try {
                    msgProducer.close();
                }
                catch (Exception me) {
                    me.printStackTrace();
                }
            }
        }
        if (!dmdSendSuccess) {
            if (this.redeliveryRequired()) {
                _logger.log(Level.SEVERE, "FAILED : sending message to DMD");
            } else {
                _logger.log(Level.SEVERE, "FAILED : sending message to DMD");
                localXar = (AbstractXAResourceType)this.xar;
                localXar.setToRollback(true);
                try {
                    localXar.rollback(null);
                }
                catch (Exception e) {
                    _logger.log(Level.SEVERE, "FAILED : to rollback XA" + e.getMessage());
                }
            }
        }
    }

    public void deliver(Message message, Destination d) {
        this.msg = message;
        this.dest = d;
        this.deliver();
    }

    public void deliver() {
        try {
            if (this.transacted) {
                this.runOnceStdXA();
            } else {
                this.runOnceStdNoXA();
            }
            _logger.log(Level.FINE, "Completed delivery ");
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public void markForDMD() {
        this.sentToDmd = true;
    }

    public boolean markedForDMD() {
        return this.sentToDmd;
    }

    private void deliverMessage(Message message) throws ResourceException {
        block2: {
            MessageEndpoint endPoint = this.jmsResource.getEndpoint();
            try {
                _logger.log(Level.FINEST, "Now it is feeding the message to MDB instance");
                ((MessageListener)endPoint).onMessage(message);
            }
            catch (Exception e) {
                if (!this.transacted) break block2;
                throw ExceptionUtils.newResourceException(e);
            }
        }
    }

    private void runOnceStdXA() throws Exception {
        int myattempts = 0;
        int attempts = this.spec.getRedeliveryAttempts();
        AbstractXAResourceType localXar = null;
        Transaction tx = null;
        if (this.msg != null) {
            while (true) {
                try {
                    this.coord = this.newCoord();
                    Message message = this.msg = this.mHoldUntilAck ? this.wrapMsg(this.msg, this.coord, -1) : this.msg;
                    if (this.transacted) {
                        tx = this.getTransaction(true);
                        _logger.log(Level.FINE, "Got the transaction " + tx);
                    }
                    this.deliverMessage(this.msg);
                    _logger.log(Level.FINE, "Delivered the message");
                    if (this.redeliveryRequired()) {
                        localXar = (AbstractXAResourceType)this.xar;
                        localXar.startDelayedXA();
                        localXar.setToRollback(true);
                    }
                    this.coord.msgDelivered(true);
                }
                catch (ResourceException r) {
                    _logger.log(Level.FINE, "Exception during Delivery, running redelivery logic");
                    if (this.redeliveryRequired()) {
                        localXar = (AbstractXAResourceType)this.xar;
                        localXar.setToRollback(false);
                        try {
                            _logger.log(Level.FINE, "Setting JMSRedelivered header on message");
                            this.msg.setJMSRedelivered(true);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    } else {
                        AbstractXAResourceType simpleXar = (AbstractXAResourceType)this.xar;
                        simpleXar.setToRollback(false);
                        this.coord.setRollbackOnly((Exception)((Object)r));
                    }
                    if (myattempts < attempts) {
                        ++myattempts;
                        _logger.log(Level.FINEST, "Releasing the endpoint after an exception");
                        this.jmsResource.releaseEndpoint();
                        try {
                            Thread.sleep(this.spec.getRedeliveryInterval() * 1000);
                            _logger.log(Level.FINE, "getting the endpoint after an exception");
                            this.jmsResource.refresh();
                        }
                        catch (Exception ie) {
                            ie.printStackTrace();
                        }
                        continue;
                    }
                    this.markForDMD();
                    try {
                        this.msg.setJMSRedelivered(false);
                        _logger.log(Level.FINE, "Resetting JMS redelivered header");
                    }
                    catch (Exception jmse) {
                        _logger.log(Level.FINE, "Cannot reset JMS redelivered header");
                    }
                    if (this.redeliveryRequired()) {
                        localXar.startDelayedXA();
                    }
                    return;
                }
                break;
            }
        }
        if (!this.markedForDMD()) {
            this.coord.waitForAcks();
            _logger.log(Level.FINE, "Is there a TX associated here " + this.getTransaction(true));
            if (this.transacted && this.getTransaction(true) == null) {
                mTxMgr.getTransactionManager().resume(tx);
                _logger.log(Level.FINE, "Resumed the transaction ");
            }
            if (this.transacted && this.coord.isRollbackOnly()) {
                _logger.log(Level.FINE, "Setting to RollBack because coordinator was rollback");
                this.getTransaction(true).setRollbackOnly();
            }
            _logger.log(Level.FINE, "Releasing the Endpoint");
            this.jmsResource.releaseEndpoint();
            _logger.log(Level.FINE, "Released the Endpoint");
        }
    }

    private Transaction getTransaction(boolean mustSucceed) {
        block3: {
            if (mTxMgr != null) {
                try {
                    return mTxMgr.getTransactionManager().getTransaction();
                }
                catch (Exception e) {
                    if (!mustSucceed) break block3;
                    throw new RuntimeException("Failed to obtain handle to transaction: " + e, e);
                }
            }
        }
        return null;
    }

    private Message wrapMsg(Message toCopy, AckHandler ack, int iBatch) throws JMSException {
        WMessageIn ret;
        int nItf = 0;
        if (toCopy instanceof TextMessage) {
            ++nItf;
            ret = new WTextMessageIn((TextMessage)toCopy, ack, iBatch);
        } else if (toCopy instanceof BytesMessage) {
            ++nItf;
            ret = new WBytesMessageIn((BytesMessage)toCopy, ack, iBatch);
        } else if (toCopy instanceof MapMessage) {
            ++nItf;
            ret = new WMapMessageIn((MapMessage)toCopy, ack, iBatch);
        } else if (toCopy instanceof ObjectMessage) {
            ++nItf;
            ret = new WObjectMessageIn((ObjectMessage)toCopy, ack, iBatch);
        } else if (toCopy instanceof StreamMessage) {
            ++nItf;
            ret = new WStreamMessageIn((StreamMessage)toCopy, ack, iBatch);
        } else {
            ++nItf;
            ret = new WMessageIn(toCopy, ack, iBatch);
        }
        if (nItf > 1) {
            throw new JMSException("Cannot determine message type: the message implements multiple interfaces.");
        }
        return ret;
    }

    private void runOnceStdNoXA() throws Exception {
        if (this.msg != null) {
            this.msg = this.mHoldUntilAck ? this.wrapMsg(this.msg, this.coord, -1) : this.msg;
            try {
                this.deliverMessage(this.msg);
                this.coord.msgDelivered(true);
            }
            catch (ResourceException r) {
                this.coord.setRollbackOnly((Exception)((Object)r));
            }
            this.coord.waitForAcks();
            if (!this.coord.isRollbackOnly()) {
                this.jmsResource.getSession().commit();
            } else {
                this.jmsResource.getSession().rollback();
            }
            this.jmsResource.releaseEndpoint();
        }
    }

    public SyncJmsResource getJmsResource() {
        return this.jmsResource;
    }

    private Coordinator newCoord() {
        if (this.mHoldUntilAck) {
            return new HUACoordinator();
        }
        return new NonHUACoordinator();
    }

    private class HUACoordinator
    extends Coordinator {
        private Semaphore mSemaphore;
        private int mNAcksToExpect;
        private boolean mIsRollbackOnly;
        private boolean mNeedsToDiscardEndpoint;
        private int mNMsgsDelivered;

        private HUACoordinator() {
            this.mSemaphore = new Semaphore(0);
        }

        public synchronized void setRollbackOnly() {
            this.mIsRollbackOnly = true;
        }

        public void setRollbackOnly(Exception e) {
            if (e != null) {
                this.setRollbackOnly();
                this.mNeedsToDiscardEndpoint = true;
            }
        }

        public void ack(boolean isRollbackOnly, Message m) throws JMSException {
            if (isRollbackOnly) {
                this.setRollbackOnly();
                _logger.log(Level.FINE, "Setting rollback only");
            }
            this.mSemaphore.release();
            _logger.log(Level.FINE, "Released Semaphore here");
        }

        public synchronized boolean isRollbackOnly() {
            return this.mIsRollbackOnly;
        }

        public void msgDelivered(boolean wasDelivered) {
            if (wasDelivered) {
                ++this.mNAcksToExpect;
                ++this.mNMsgsDelivered;
            }
        }

        public void waitForAcks() throws InterruptedException {
            _logger.log(Level.FINE, "Tying to acquire a semaphore");
            if (!this.mSemaphore.tryAcquire(SyncDeliveryHelper.this.acktimeout, TimeUnit.SECONDS)) {
                _logger.log(Level.FINE, "Acquired");
                this.setRollbackOnly();
            }
        }

        public boolean needsToDiscardEndpoint() {
            return this.mNeedsToDiscardEndpoint;
        }

        public void setNeedsToDiscardEndpoint() {
            this.mNeedsToDiscardEndpoint = true;
        }
    }

    private class NonHUACoordinator
    extends Coordinator {
        private boolean mIsRollbackOnly;
        private boolean mNeedsToDiscardEndpoint;
        private int mNMsgsDelivered;

        private NonHUACoordinator() {
        }

        public void setRollbackOnly() {
            this.mIsRollbackOnly = true;
        }

        public void setRollbackOnly(Exception e) {
            if (e != null) {
                this.setRollbackOnly();
                this.mNeedsToDiscardEndpoint = true;
            }
        }

        public void ack(boolean isRollbackOnly, Message m) throws JMSException {
        }

        public boolean isRollbackOnly() {
            return this.mIsRollbackOnly;
        }

        public void msgDelivered(Exception e) {
        }

        public void msgDelivered(boolean wasDelivered) {
            if (wasDelivered) {
                ++this.mNMsgsDelivered;
            }
        }

        public void waitForAcks() throws InterruptedException {
        }

        public boolean needsToDiscardEndpoint() {
            return this.mNeedsToDiscardEndpoint;
        }

        public void setNeedsToDiscardEndpoint() {
            this.mNeedsToDiscardEndpoint = true;
        }
    }

    private abstract class Coordinator
    extends AckHandler {
        private Coordinator() {
        }

        public abstract void setRollbackOnly();

        public abstract void setRollbackOnly(Exception var1);

        public abstract void ack(boolean var1, Message var2) throws JMSException;

        public abstract boolean isRollbackOnly();

        public abstract void msgDelivered(boolean var1);

        public abstract void waitForAcks() throws InterruptedException;

        public abstract boolean needsToDiscardEndpoint();

        public abstract void setNeedsToDiscardEndpoint();
    }
}

