/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.inbound.sync;

import com.sun.genericra.inbound.sync.SyncConsumer;
import com.sun.genericra.inbound.sync.SyncJmsResourcePool;
import com.sun.genericra.util.LogUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;

public class SyncReconnectHelper
implements ExceptionListener {
    private static Logger _logger = LogUtils.getLogger();
    private SyncJmsResourcePool pool = null;
    private SyncConsumer consumer = null;
    private int attempts = 0;
    private long interval = 0L;
    private boolean reconnectInitiated = false;

    public SyncReconnectHelper(SyncJmsResourcePool pool, SyncConsumer consumer) {
        this.pool = pool;
        this.consumer = consumer;
        this.attempts = consumer.getSpec().getReconnectAttempts();
        this.interval = consumer.getSpec().getReconnectInterval() * 1000;
    }

    public void onException(JMSException exception) {
        if (this.reconnectInitiated || this.consumer.isStopped()) {
            _logger.log(Level.INFO, "Reconnect is in progress");
            return;
        }
        this.reconnectInitiated = true;
        _logger.log(Level.INFO, "Reconnecting now");
        _logger.log(Level.INFO, "Reconnecting now");
        _logger.log(Level.INFO, "Reconnecting now");
        if (this.reestablishPool()) {
            _logger.log(Level.INFO, "Reconnected!!");
        } else {
            _logger.log(Level.SEVERE, "Reconnect failed in pool!!");
        }
    }

    private boolean reestablishPool() {
        boolean result = false;
        for (int i = 0; i < this.attempts; ++i) {
            _logger.log(Level.INFO, "Reconnect attempt->" + i);
            try {
                this.pool.stop();
                this.pool.initialize();
                _logger.log(Level.INFO, "Reconnect successful with pool->" + i);
                this.consumer.restart();
                _logger.log(Level.INFO, "Restarted Consumer->" + i);
                result = true;
                break;
            }
            catch (Exception re) {
                _logger.log(Level.INFO, "Reconnect attempt failed. Now sleeping for" + this.interval);
                try {
                    Thread.sleep(this.interval);
                }
                catch (Exception e) {
                    _logger.info("Thread.sleep exception");
                }
                continue;
            }
        }
        return result;
    }

    public SyncJmsResourcePool getPool() {
        return this.pool;
    }
}

