/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.inbound.sync;

import com.sun.genericra.inbound.sync.SyncDeliveryHelper;
import com.sun.genericra.inbound.sync.SyncJmsResource;
import com.sun.genericra.util.LogUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.resource.spi.work.Work;

public class SyncWorker
implements Work {
    private static Logger _logger = LogUtils.getLogger();
    private volatile boolean mIsStopped = true;
    private Object mIsStoppedLock = new Object();
    private MessageConsumer mReceiver;
    private Session mSess;
    private SyncJmsResource resource = null;
    private int sessionid;
    private static long TIMEOUT = 100L;
    private static long WAIT_TIMEOUT = 1000L;
    boolean requiresrefresh = true;

    public SyncWorker(SyncJmsResource res) throws JMSException {
        this.resource = res;
        this.sessionid = this.resource.getSessionid();
        this.mReceiver = this.resource.getReceiver();
    }

    private void close() {
        if (this.mReceiver != null) {
            try {
                this.mReceiver.close();
            }
            catch (JMSException e) {
                _logger.log(Level.WARNING, "Non-critical failure to close a message consumer: " + (Object)((Object)e));
            }
            this.mReceiver = null;
        }
        _logger.log(Level.FINE, "Closed Synchronouse receiver #" + this.sessionid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.mIsStoppedLock;
        synchronized (object) {
            if (!this.mIsStopped) {
                return;
            }
            this.mIsStopped = false;
        }
        _logger.log(Level.INFO, "Starting synchronouse receiver #" + this.sessionid);
        while (true) {
            Object helper;
            try {
                Message m;
                if (this.requiresrefresh) {
                    _logger.log(Level.FINE, "Refreshing Receiver #" + this.sessionid);
                    this.resource.refreshListener();
                    this.resource.refresh();
                    this.requiresrefresh = false;
                    _logger.log(Level.FINE, "Refresed Receiver #" + this.sessionid);
                }
                if ((m = this.mReceiver.receive(TIMEOUT)) != null) {
                    this.requiresrefresh = true;
                    helper = this.resource.getDeliveryHelper();
                    ((SyncDeliveryHelper)helper).deliver(m, this.resource.getPool().getConsumer().getDmdDestination());
                    _logger.log(Level.FINE, "Delivered message Receiver #" + this.sessionid);
                } else {
                    this.requiresrefresh = false;
                }
                helper = this.mIsStoppedLock;
                synchronized (helper) {
                    block30: {
                        if (!this.mIsStopped) break block30;
                        _logger.log(Level.INFO, "Stopping synchronous receiver #" + this.sessionid);
                        this.mIsStoppedLock.notifyAll();
                        break;
                    }
                    continue;
                }
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Exception during receive , Receiver #" + this.sessionid + ex);
            }
            catch (Throwable ex) {
                _logger.log(Level.SEVERE, "Exception during receive, Receiver #" + this.sessionid + ex);
            }
            finally {
                if (!this.requiresrefresh) continue;
                try {
                    this.resource.releaseEndpoint();
                }
                catch (Exception ee) {}
                helper = this.resource.getDeliveryHelper();
                if (!((SyncDeliveryHelper)helper).markedForDMD()) continue;
                ((SyncDeliveryHelper)helper).sendMessageToDMD();
                continue;
            }
            break;
        }
        this.resource.releaseEndpoint();
        _logger.log(Level.FINE, "Closing the receiver from run #" + this.sessionid);
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopped() {
        Object object = this.mIsStoppedLock;
        synchronized (object) {
            return this.mIsStopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.mIsStoppedLock;
        synchronized (object) {
            if (this.mIsStopped) {
                return;
            }
            _logger.log(Level.FINE, "Stopping the receiver #" + this.sessionid);
            this.mIsStopped = true;
            try {
                this.mIsStoppedLock.wait(WAIT_TIMEOUT);
            }
            catch (InterruptedException ie) {
                _logger.log(Level.FINE, "Notification received for the receiver #" + this.sessionid);
            }
            _logger.log(Level.FINE, "Closing the receiver from release #" + this.sessionid);
            this.close();
        }
    }
}

