/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.inbound.sync;

import java.lang.reflect.Method;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class TxMgr {
    private TxMgrAdapter mTxMgrAdapter;
    private static TransactionManager sUnitTestTxMgr;

    public void init(Properties p) {
        this.getTxMgrAdapter();
    }

    public static void safeClose(Context ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    public boolean isInTransaction() {
        try {
            TxMgrAdapter txm = this.getTxMgrAdapter();
            if (txm != null) {
                return txm.isInTransaction();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void register(Synchronization sync) {
        try {
            TxMgrAdapter txm = this.getTxMgrAdapter();
            if (txm != null) {
                txm.register(sync);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TransactionManager getTransactionManager() throws Exception {
        TxMgrAdapter txm = this.getTxMgrAdapter();
        if (txm != null) {
            return txm.getTransactionManager();
        }
        throw new Exception("Could not find transaction manager adapter");
    }

    private TxMgrAdapter getTxMgrAdapter() {
        if (this.mTxMgrAdapter != null) {
            return this.mTxMgrAdapter;
        }
        if (this.mTxMgrAdapter == null) {
            this.mTxMgrAdapter = new UnitTest().init();
        }
        if (this.mTxMgrAdapter == null) {
            this.mTxMgrAdapter = new SJSAS().init();
        }
        if (this.mTxMgrAdapter == null) {
            this.mTxMgrAdapter = new GlobalJNDI("javax.transaction.TransactionManager").init();
        }
        if (this.mTxMgrAdapter == null) {
            this.mTxMgrAdapter = new LocalJNDI("java:/TransactionManager").init();
        }
        if (this.mTxMgrAdapter == null) {
            this.mTxMgrAdapter = new WL9().init();
        }
        if (this.mTxMgrAdapter == null) {
            this.mTxMgrAdapter = new WAS6a().init();
        }
        if (this.mTxMgrAdapter == null) {
            this.mTxMgrAdapter = new LocalJNDI("java:comp/UserTransaction").init();
        }
        return this.mTxMgrAdapter;
    }

    public static void setUnitTestTxMgr(TransactionManager txmgr) {
        sUnitTestTxMgr = txmgr;
    }

    public static TransactionManager getUnitTestTxMgr() {
        return sUnitTestTxMgr;
    }

    private class LocalJNDI
    extends TxMgrAdapter {
        private String mName;

        public LocalJNDI(String name) {
            this.mName = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TxMgrAdapter init() {
            InitialContext ctx = null;
            try {
                ctx = new InitialContext();
                TransactionManager mgr = (TransactionManager)ctx.lookup(this.mName);
                LocalJNDI localJNDI = mgr == null ? null : this;
                return localJNDI;
            }
            catch (Exception exception) {
            }
            finally {
                TxMgr.safeClose(ctx);
            }
            return null;
        }

        public TransactionManager getTransactionManager() throws Exception {
            InitialContext ctx = null;
            try {
                ctx = new InitialContext();
                TransactionManager transactionManager = (TransactionManager)ctx.lookup(this.mName);
                return transactionManager;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                TxMgr.safeClose(ctx);
            }
        }
    }

    private class GlobalJNDI
    extends TxMgrAdapter {
        private TransactionManager mTransactionManager;
        private String mName;

        public GlobalJNDI(String name) {
            this.mName = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TxMgrAdapter init() {
            InitialContext ctx = null;
            try {
                ctx = new InitialContext();
                this.mTransactionManager = (TransactionManager)ctx.lookup(this.mName);
                GlobalJNDI globalJNDI = this;
                return globalJNDI;
            }
            catch (Exception exception) {
            }
            finally {
                TxMgr.safeClose(ctx);
            }
            return null;
        }

        public TransactionManager getTransactionManager() {
            return this.mTransactionManager;
        }
    }

    private class UnitTest
    extends TxMgrAdapter {
        private UnitTest() {
        }

        public TxMgrAdapter init() {
            return sUnitTestTxMgr != null ? this : null;
        }

        public TransactionManager getTransactionManager() {
            return sUnitTestTxMgr;
        }
    }

    private class WL9
    extends TxMgrAdapter {
        private TransactionManager mTransactionManager;

        private WL9() {
        }

        public TxMgrAdapter init() {
            try {
                Class<?> c1 = Class.forName("weblogic.transaction.TransactionHelper");
                Method m1 = c1.getMethod("getTransactionManager", new Class[0]);
                Object ret = m1.invoke(null, new Object[0]);
                this.mTransactionManager = (TransactionManager)ret;
                return this;
            }
            catch (Exception exception) {
                return null;
            }
        }

        public TransactionManager getTransactionManager() {
            return this.mTransactionManager;
        }
    }

    private class WAS6a
    extends TxMgrAdapter {
        private TransactionManager mTransactionManager;

        private WAS6a() {
        }

        public TxMgrAdapter init() {
            try {
                Class<?> c1 = Class.forName("com.ibm.ws.Transaction.TransactionManagerFactory");
                Method m1 = c1.getMethod("getTransactionManager", new Class[0]);
                Object ret = m1.invoke(null, new Object[0]);
                this.mTransactionManager = (TransactionManager)ret;
                return this;
            }
            catch (Exception exception) {
                return null;
            }
        }

        public TransactionManager getTransactionManager() {
            return this.mTransactionManager;
        }
    }

    private class SJSAS
    extends TxMgrAdapter {
        private TransactionManager mTransactionManager;

        private SJSAS() {
        }

        public TxMgrAdapter init() {
            try {
                Class<?> c1 = Class.forName("com.sun.enterprise.Switch");
                Method m1 = c1.getMethod("getSwitch", new Class[0]);
                Object theswitch = m1.invoke(null, new Object[0]);
                Method m2 = c1.getMethod("getTransactionManager", new Class[0]);
                Object ret = m2.invoke(theswitch, new Object[0]);
                this.mTransactionManager = (TransactionManager)ret;
                return this;
            }
            catch (Exception exception) {
                return null;
            }
        }

        public TransactionManager getTransactionManager() {
            return this.mTransactionManager;
        }
    }

    private abstract class TxMgrAdapter {
        private TxMgrAdapter() {
        }

        public abstract TxMgrAdapter init();

        public abstract TransactionManager getTransactionManager() throws Exception;

        public Transaction getTransaction() throws Exception {
            return this.getTransactionManager().getTransaction();
        }

        public final void register(Synchronization sync) throws Exception {
            this.getTransaction().registerSynchronization(sync);
        }

        public final boolean isInTransaction() throws Exception {
            return this.getTransaction() != null;
        }
    }
}

