/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.inbound.sync;

import com.sun.genericra.inbound.sync.AckHandler;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;

public class WMessageIn
implements Message {
    private Message mDelegate;
    private AckHandler mAckHandler;
    private int mIBatch;
    private int mBatchSize;
    private boolean mIsRollbackOnly;
    private boolean mIsAckCalled;
    public static final String LEGACY_ISROLLBACKONLY = "JMSJCA.isRollbackOnly";
    public static final String SETROLLBACKONLY = "JMSJCA.setRollbackOnly";
    public static final String IBATCH = "JMSJCA.batchIndex";
    public static final String BATCHSIZE = "JMSJCA.batchSize";

    public WMessageIn(Message delegate, AckHandler ackHandler, int iBatch) {
        this.mDelegate = delegate;
        this.mAckHandler = ackHandler;
        this.mIBatch = iBatch;
    }

    public Object getWrappedObject() {
        return this.mDelegate;
    }

    public void setJMSReplyTo(Destination dest) throws JMSException {
        this.mDelegate.setJMSReplyTo(dest);
    }

    public void acknowledge() throws JMSException {
        if (this.mAckHandler != null && !this.mIsAckCalled) {
            this.mAckHandler.ack(this.mIsRollbackOnly, this);
            this.mIsAckCalled = true;
        }
        this.mDelegate.acknowledge();
    }

    public void clearBody() throws JMSException {
        this.mDelegate.clearBody();
    }

    public void clearProperties() throws JMSException {
        this.mDelegate.clearProperties();
    }

    public boolean getBooleanProperty(String arg0) throws JMSException {
        return this.mDelegate.getBooleanProperty(arg0);
    }

    public byte getByteProperty(String arg0) throws JMSException {
        return this.mDelegate.getByteProperty(arg0);
    }

    public double getDoubleProperty(String arg0) throws JMSException {
        return this.mDelegate.getDoubleProperty(arg0);
    }

    public float getFloatProperty(String arg0) throws JMSException {
        return this.mDelegate.getFloatProperty(arg0);
    }

    public int getIntProperty(String arg0) throws JMSException {
        return this.mDelegate.getIntProperty(arg0);
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.mDelegate.getJMSCorrelationID();
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this.mDelegate.getJMSCorrelationIDAsBytes();
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.mDelegate.getJMSDeliveryMode();
    }

    public Destination getJMSDestination() throws JMSException {
        return this.mDelegate.getJMSDestination();
    }

    public long getJMSExpiration() throws JMSException {
        return this.mDelegate.getJMSExpiration();
    }

    public String getJMSMessageID() throws JMSException {
        return this.mDelegate.getJMSMessageID();
    }

    public int getJMSPriority() throws JMSException {
        return this.mDelegate.getJMSPriority();
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.mDelegate.getJMSRedelivered();
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this.mDelegate.getJMSReplyTo();
    }

    public long getJMSTimestamp() throws JMSException {
        return this.mDelegate.getJMSTimestamp();
    }

    public String getJMSType() throws JMSException {
        return this.mDelegate.getJMSType();
    }

    public long getLongProperty(String arg0) throws JMSException {
        return this.mDelegate.getLongProperty(arg0);
    }

    public Object getObjectProperty(String name) throws JMSException {
        if (IBATCH.equalsIgnoreCase(name)) {
            return new Integer(this.mIBatch);
        }
        if (BATCHSIZE.equalsIgnoreCase(name)) {
            return new Integer(this.mBatchSize);
        }
        return this.mDelegate.getObjectProperty(name);
    }

    public Enumeration getPropertyNames() throws JMSException {
        return this.mDelegate.getPropertyNames();
    }

    public short getShortProperty(String arg0) throws JMSException {
        return this.mDelegate.getShortProperty(arg0);
    }

    public String getStringProperty(String arg0) throws JMSException {
        return this.mDelegate.getStringProperty(arg0);
    }

    public boolean propertyExists(String arg0) throws JMSException {
        return this.mDelegate.propertyExists(arg0);
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        if (!LEGACY_ISROLLBACKONLY.equalsIgnoreCase(name) && !SETROLLBACKONLY.equalsIgnoreCase(name)) {
            this.mDelegate.setBooleanProperty(name, value);
        } else {
            if (!value) {
                throw new JMSException("Value must be true");
            }
            if (this.mIsAckCalled) {
                throw new JMSException("Cannot set isRollbackOnly after acknowledge() has been called.");
            }
            this.mIsRollbackOnly = true;
        }
    }

    public void setByteProperty(String arg0, byte arg1) throws JMSException {
        this.mDelegate.setByteProperty(arg0, arg1);
    }

    public void setDoubleProperty(String arg0, double arg1) throws JMSException {
        this.mDelegate.setDoubleProperty(arg0, arg1);
    }

    public void setFloatProperty(String arg0, float arg1) throws JMSException {
        this.mDelegate.setFloatProperty(arg0, arg1);
    }

    public void setIntProperty(String arg0, int arg1) throws JMSException {
        this.mDelegate.setIntProperty(arg0, arg1);
    }

    public void setJMSCorrelationID(String arg0) throws JMSException {
        this.mDelegate.setJMSCorrelationID(arg0);
    }

    public void setJMSCorrelationIDAsBytes(byte[] arg0) throws JMSException {
        this.mDelegate.setJMSCorrelationIDAsBytes(arg0);
    }

    public void setJMSDeliveryMode(int arg0) throws JMSException {
        this.mDelegate.setJMSDeliveryMode(arg0);
    }

    public void setJMSDestination(Destination arg0) throws JMSException {
        this.mDelegate.setJMSDestination(arg0);
    }

    public void setJMSExpiration(long arg0) throws JMSException {
        this.mDelegate.setJMSExpiration(arg0);
    }

    public void setJMSMessageID(String arg0) throws JMSException {
        this.mDelegate.setJMSMessageID(arg0);
    }

    public void setJMSPriority(int arg0) throws JMSException {
        this.mDelegate.setJMSPriority(arg0);
    }

    public void setJMSRedelivered(boolean arg0) throws JMSException {
        this.mDelegate.setJMSRedelivered(arg0);
    }

    public void setJMSTimestamp(long arg0) throws JMSException {
        this.mDelegate.setJMSTimestamp(arg0);
    }

    public void setJMSType(String arg0) throws JMSException {
        this.mDelegate.setJMSType(arg0);
    }

    public void setLongProperty(String arg0, long arg1) throws JMSException {
        this.mDelegate.setLongProperty(arg0, arg1);
    }

    public void setObjectProperty(String arg0, Object arg1) throws JMSException {
        this.mDelegate.setObjectProperty(arg0, arg1);
    }

    public void setShortProperty(String arg0, short arg1) throws JMSException {
        this.mDelegate.setShortProperty(arg0, arg1);
    }

    public void setStringProperty(String arg0, String arg1) throws JMSException {
        this.mDelegate.setStringProperty(arg0, arg1);
    }

    public void setBatchSize(int batchSize) {
        this.mBatchSize = batchSize;
    }
}

