/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.inbound.async;

import com.sun.genericra.inbound.AbstractConsumer;
import com.sun.genericra.inbound.AbstractJmsResourcePool;
import com.sun.genericra.inbound.async.DeliveryHelper;
import com.sun.genericra.inbound.async.InboundJmsResource;
import com.sun.genericra.inbound.async.InboundJmsResourcePool;
import com.sun.genericra.inbound.async.ReconnectHelper;
import com.sun.genericra.util.ExceptionUtils;
import java.util.logging.Level;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.endpoint.MessageEndpointFactory;

public class EndpointConsumer
extends AbstractConsumer {
    InboundJmsResourcePool jmsPool = null;
    private ConnectionConsumer consumer = null;
    private ReconnectHelper reconHelper = null;

    public EndpointConsumer(MessageEndpointFactory mef, ActivationSpec actspec) throws ResourceException {
        super(mef, actspec);
    }

    public EndpointConsumer(ActivationSpec actspec) throws ResourceException {
        this(null, actspec);
    }

    public AbstractJmsResourcePool getPool() {
        return this.jmsPool;
    }

    public Connection getConnection() {
        return this.jmsPool.getConnection();
    }

    public void restart() throws ResourceException {
        this.consumer = this._start(this.reconHelper.getPool(), this.dest);
    }

    public void start() throws ResourceException {
        this.setTransaction();
        logger.log(Level.FINE, "Registering a endpoint consumer, transaction support :" + this.transacted);
        this.initialize(this.transacted);
        this.consumer = this._start(this.jmsPool, this.dest);
    }

    public void initialize(boolean isTx) throws ResourceException {
        super.validate();
        this.jmsPool = new InboundJmsResourcePool(this, isTx);
        this.jmsPool.initialize();
    }

    private ConnectionConsumer _start(InboundJmsResourcePool pool, Destination dst) throws ResourceException {
        ConnectionConsumer consmr = null;
        logger.log(Level.FINE, "Starting the message consumption");
        try {
            Connection con = pool.getConnection();
            this.setClientId();
            if (this.spec.getSubscriptionDurability().equals("Durable")) {
                String subscription_name = this.spec.getInstanceCount() > 1 && this.spec.getInstanceID() != 0 ? this.spec.getSubscriptionName() + this.spec.getInstanceID() : this.spec.getSubscriptionName();
                consmr = pool.createDurableConnectionConsumer(dst, subscription_name, this.spec.getMessageSelector(), 1);
                logger.log(Level.FINE, "Created durable connection consumer" + dst);
            } else {
                consmr = pool.createConnectionConsumer(dst, this.spec.getMessageSelector(), 1);
                logger.log(Level.FINE, "Created non durable connection consumer" + dst);
            }
            con.start();
            this.reconHelper = new ReconnectHelper(pool, this);
            if (this.spec.getReconnectAttempts() > 0) {
                con.setExceptionListener((ExceptionListener)this.reconHelper);
            }
        }
        catch (JMSException je) {
            this.closeConsumer();
            throw ExceptionUtils.newResourceException(je);
        }
        logger.log(Level.INFO, "Generic resource adapter started consumption ");
        return consmr;
    }

    public void stop() {
        logger.log(Level.FINE, "Now stopping the message consumption");
        this.stopped = true;
        if (this.jmsPool != null) {
            try {
                this.jmsPool.destroy();
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "" + t.getMessage(), t);
            }
        }
        this.closeConsumer();
        Connection con = this.jmsPool.getConnection();
        if (con != null) {
            try {
                con.close();
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "" + t.getMessage(), t);
            }
        }
    }

    public void closeConsumer() {
        if (this.consumer != null) {
            try {
                this.consumer.close();
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "" + t.getMessage(), t);
            }
        }
    }

    public void consumeMessage(Message message, InboundJmsResource jmsResource) {
        DeliveryHelper helper = jmsResource.getDeliveryHelper();
        helper.deliver(message, this.dmd);
    }
}

