/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.inbound.sync;

import com.sun.genericra.inbound.AbstractConsumer;
import com.sun.genericra.inbound.AbstractJmsResourcePool;
import com.sun.genericra.inbound.sync.SyncJmsResourcePool;
import com.sun.genericra.inbound.sync.SyncReconnectHelper;
import com.sun.genericra.inbound.sync.TxMgr;
import com.sun.genericra.util.ExceptionUtils;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.TransactionManager;

public class SyncConsumer
extends AbstractConsumer {
    private boolean mIsStopped = true;
    private String applicationName;
    private int mBatchSize;
    private boolean mHoldUntilAck;
    private SyncJmsResourcePool jmsPool;
    private ArrayList mWorkers;
    private SyncReconnectHelper reconHelper = null;

    public SyncConsumer(MessageEndpointFactory mef, ActivationSpec actspec) throws ResourceException {
        super(mef, actspec);
    }

    public AbstractJmsResourcePool getPool() {
        return this.jmsPool;
    }

    public void initialize(boolean istx) throws ResourceException {
        super.validate();
        if ((this.mBatchSize > 1 || this.mHoldUntilAck) && this.transacted) {
            TxMgr txmgr = new TxMgr();
            TransactionManager mgr = null;
            try {
                mgr = txmgr.getTransactionManager();
            }
            catch (Exception e) {
                throw ExceptionUtils.newResourceException(e);
            }
            if (mgr == null && this.mHoldUntilAck) {
                logger.log(Level.FINE, "TxMgr could not be obtained: ");
                throw new RuntimeException("Could not obtain TxMgr which is crucial for HUA mode: ");
            }
        }
        this.jmsPool = new SyncJmsResourcePool(this, istx);
        this.jmsPool.initialize();
    }

    public void start() throws ResourceException {
        this.setTransaction();
        this.initialize(this.transacted);
        this._start(this.jmsPool, this.dest);
    }

    public void restart() throws ResourceException {
        this._start(this.reconHelper.getPool(), this.dest);
    }

    private void _start(SyncJmsResourcePool pool, Destination destination) throws ResourceException {
        try {
            this.reconHelper = new SyncReconnectHelper(pool, this);
            if (this.spec.getReconnectAttempts() > 0) {
                pool.getConnection().setExceptionListener((ExceptionListener)this.reconHelper);
            }
            pool.getConnection().start();
        }
        catch (JMSException e) {
            this.stop();
            throw ExceptionUtils.newResourceException(e);
        }
    }

    public void stop() {
        try {
            this.jmsPool.destroy();
            logger.log(Level.FINE, "Destroyed the pool ");
            if (this.jmsPool.getConnection() != null) {
                this.jmsPool.getConnection().close();
                logger.log(Level.FINE, "Closed the connection ");
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Unexpected exception stopping JMS connection: " + ex, ex);
        }
    }

    public Connection getConnection() {
        return this.jmsPool.getConnection();
    }
}

