/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.inbound;

import com.sun.genericra.GenericJMSRA;
import com.sun.genericra.inbound.AbstractConsumer;
import com.sun.genericra.util.LogUtils;
import com.sun.genericra.util.StringManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.jms.XATopicSession;
import javax.transaction.xa.XAResource;

public abstract class AbstractJmsResourcePool {
    protected static Logger _logger = LogUtils.getLogger();
    protected AbstractConsumer consumer;
    protected Connection con = null;
    protected Connection dmdCon = null;
    protected ConnectionFactory cf = null;
    protected boolean transacted = false;
    protected boolean destroyed = false;
    protected boolean stopped = false;
    protected long TIME_OUT = 180000L;
    protected StringManager sm = StringManager.getManager(GenericJMSRA.class);

    public AbstractJmsResourcePool(AbstractConsumer cons, boolean transacted) {
        this.consumer = cons;
        this.transacted = transacted;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public XAConnection createXAConnection(XAConnectionFactory xacf) throws JMSException {
        Object xac = null;
        String user = this.consumer.getSpec().getUserName();
        String password = this.consumer.getSpec().getPassword();
        xac = user == null || user.equals("") ? (this.isQueue() ? ((XAQueueConnectionFactory)xacf).createXAQueueConnection() : (this.isTopic() ? ((XATopicConnectionFactory)xacf).createXATopicConnection() : xacf.createXAConnection())) : (this.isQueue() ? ((XAQueueConnectionFactory)xacf).createXAQueueConnection(user, password) : (this.isTopic() ? ((XATopicConnectionFactory)xacf).createXATopicConnection(user, password) : xacf.createXAConnection(user, password)));
        return xac;
    }

    public XASession createXASession(XAConnection con) throws JMSException {
        Object result = null;
        result = this.isQueue() ? ((XAQueueConnection)con).createXAQueueSession() : (this.isTopic() ? ((XATopicConnection)con).createXATopicSession() : con.createXASession());
        return result;
    }

    public XAResource getXAResource(XASession session) throws JMSException {
        XAResource result = null;
        result = this.isTopic() ? ((XATopicSession)session).getXAResource() : (this.isQueue() ? ((XAQueueSession)session).getXAResource() : session.getXAResource());
        return result;
    }

    public Connection createConnection(ConnectionFactory cf) throws JMSException {
        Object con = null;
        String user = this.consumer.getSpec().getUserName();
        String password = this.consumer.getSpec().getPassword();
        con = user == null || user.equals("") ? (this.isTopic() ? ((TopicConnectionFactory)cf).createTopicConnection() : (this.isQueue() ? ((QueueConnectionFactory)cf).createQueueConnection() : cf.createConnection())) : (this.isTopic() ? ((TopicConnectionFactory)cf).createTopicConnection(user, password) : (this.isQueue() ? ((QueueConnectionFactory)cf).createQueueConnection(user, password) : cf.createConnection(user, password)));
        return con;
    }

    public Session createSession(Connection con) throws JMSException {
        Object sess = null;
        sess = this.isTopic() ? ((TopicConnection)con).createTopicSession(false, 1) : (this.isQueue() ? ((QueueConnection)con).createQueueSession(false, 1) : con.createSession(false, 1));
        return sess;
    }

    public String constructSelector(String name) {
        String selector;
        block4: {
            selector = null;
            try {
                int instancecount = this.consumer.getSpec().getInstanceCount();
                int instanceid = this.consumer.getSpec().getInstanceID();
                String customeloadbalanceselector = this.consumer.getSpec().getLoadBalancingSelector();
                if (this.consumer.getSpec().getLoadBalancingRequired() && instancecount > 1) {
                    String loadbalancingselector = "(JMSTimestamp - (JMSTimestamp/" + instancecount + ")*" + instancecount + ") = " + instanceid;
                    String tmpselector = "";
                    if (name != null && !name.equals("")) {
                        tmpselector = "(" + name + ")" + " AND ";
                    }
                    _logger.log(Level.FINE, "Temporary selector  is " + tmpselector);
                    selector = !customeloadbalanceselector.equals("") ? tmpselector + "(" + customeloadbalanceselector + ")" : tmpselector + "(" + loadbalancingselector + ")";
                    break block4;
                }
                _logger.log(Level.FINE, "Returning default selector " + selector);
                return name;
            }
            catch (Exception e) {
                e.printStackTrace();
                selector = null;
            }
        }
        _logger.log(Level.FINE, "Returning selector " + selector);
        return selector;
    }

    public Connection createDmdConnection(ConnectionFactory cf) throws JMSException {
        Object con = null;
        String user = this.consumer.getSpec().getUserName();
        String password = this.consumer.getSpec().getPassword();
        con = user == null || user.equals("") ? (this.consumer.getSpec().getDeadMessageDestinationType().equals("javax.jms.Topic") ? ((TopicConnectionFactory)cf).createTopicConnection() : (this.consumer.getSpec().getDeadMessageDestinationType().equals("javax.jms.Queue") ? ((QueueConnectionFactory)cf).createQueueConnection() : cf.createConnection())) : (this.consumer.getSpec().getDeadMessageDestinationType().equals("javax.jms.Topic") ? ((TopicConnectionFactory)cf).createTopicConnection(user, password) : (this.consumer.getSpec().getDeadMessageDestinationType().equals("javax.jms.Queue") ? ((QueueConnectionFactory)cf).createQueueConnection(user, password) : cf.createConnection(user, password)));
        return con;
    }

    public boolean isTopic() {
        return this.consumer.getSpec().getDestinationType().equals("javax.jms.Topic");
    }

    public MessageConsumer createMessageConsumer(Session sess) throws JMSException {
        Destination dest = this.consumer.getDestination();
        if (this.transacted) {
            if (this.isTopic()) {
                if ("Durable".equals(this.consumer.getSpec().getSubscriptionDurability())) {
                    return ((XATopicSession)sess).getTopicSession().createDurableSubscriber((Topic)dest, this.consumer.getSpec().getSubscriptionName(), this.consumer.getSpec().getMessageSelector(), false);
                }
                return ((XATopicSession)sess).getTopicSession().createSubscriber((Topic)dest, this.consumer.getSpec().getMessageSelector(), false);
            }
            return ((XAQueueSession)sess).getQueueSession().createReceiver((Queue)dest, this.consumer.getSpec().getMessageSelector());
        }
        if (this.isTopic()) {
            if ("Durable".equals(this.consumer.getSpec().getSubscriptionDurability())) {
                return ((TopicSession)sess).createDurableSubscriber((Topic)dest, this.consumer.getSpec().getSubscriptionName(), this.consumer.getSpec().getMessageSelector(), false);
            }
            return ((TopicSession)sess).createSubscriber((Topic)dest, this.consumer.getSpec().getMessageSelector(), false);
        }
        return ((QueueSession)sess).createReceiver((Queue)dest, this.consumer.getSpec().getMessageSelector());
    }

    public boolean isQueue() {
        return this.consumer.getSpec().getDestinationType().equals("javax.jms.Queue");
    }

    public AbstractConsumer getConsumer() {
        return this.consumer;
    }

    public Connection getConnection() {
        return this.con;
    }

    public Connection getConnectionForDMD() throws JMSException {
        return this.dmdCon;
    }

    public abstract int getMaxSize();

    public abstract long getMaxWaitTime();

    public abstract int getCurrentResources();

    public abstract int getBusyResources();

    public abstract int getFreeResources();

    public abstract int getConnectionsInUse();

    public abstract int getWaiting();
}

