/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.inbound.async;

import com.sun.genericra.AbstractXAResourceType;
import com.sun.genericra.inbound.ActivationSpec;
import com.sun.genericra.inbound.DeadMessageProducer;
import com.sun.genericra.inbound.FirstXAResourceProxy;
import com.sun.genericra.inbound.InboundXAResourceProxy;
import com.sun.genericra.inbound.SimpleXAResourceProxy;
import com.sun.genericra.inbound.async.InboundJmsResource;
import com.sun.genericra.inbound.async.InboundJmsResourcePool;
import com.sun.genericra.util.ExceptionUtils;
import com.sun.genericra.util.LogUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.transaction.xa.XAResource;

public class DeliveryHelper {
    private static Logger _logger = LogUtils.getLogger();
    ActivationSpec spec;
    InboundJmsResource jmsResource;
    XAResource xar;
    Message msg = null;
    Destination dest = null;
    boolean transacted;
    boolean sentToDmd = false;
    boolean redeliveryFailed = false;

    public DeliveryHelper(InboundJmsResource jmsResource, InboundJmsResourcePool pool) {
        this.spec = pool.getConsumer().getSpec();
        this.jmsResource = jmsResource;
        this.transacted = pool.isTransacted();
        AbstractXAResourceType xarObject = null;
        if (this.redeliveryRequired()) {
            if (this.spec.getUseFirstXAForRedelivery()) {
                _logger.log(Level.FINE, "Using First XA redelivery logic");
                xarObject = new FirstXAResourceProxy(jmsResource.getXAResource());
            } else {
                _logger.log(Level.FINE, "Using Inbound XA redelivery logic");
                xarObject = new InboundXAResourceProxy(jmsResource.getXAResource());
            }
        } else {
            xarObject = new SimpleXAResourceProxy(jmsResource.getXAResource());
        }
        xarObject.setRMPolicy(this.spec.getRMPolicy());
        xarObject.setConnection(pool.getConnection());
        this.xar = xarObject;
    }

    public boolean redeliveryRequired() {
        return this.transacted && this.spec.getRedeliveryAttempts() > 0;
    }

    public XAResource getXAResource() {
        return this.xar;
    }

    private DeadMessageProducer createProducer(Connection con, Destination dest) throws JMSException {
        return new DeadMessageProducer(con, this.jmsResource.getPool(), dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessageToDMD() {
        AbstractXAResourceType localXar;
        _logger.log(Level.FINE, "Trying to send message  to DMD :" + this.dest);
        Object session = null;
        DeadMessageProducer msgProducer = null;
        Exception dmdexception = null;
        boolean dmdSendSuccess = true;
        try {
            if (this.dest != null && this.spec.getSendBadMessagesToDMD()) {
                _logger.log(Level.FINE, "Sending the message to DMD :" + this.dest);
                if (this.redeliveryRequired()) {
                    localXar = (AbstractXAResourceType)this.xar;
                    if (!localXar.endCalled()) {
                        localXar.end(null, 0x4000000);
                    }
                    localXar.prepare(null);
                    _logger.log(Level.FINE, "Prepared DMD transaction");
                } else {
                    localXar = (AbstractXAResourceType)this.xar;
                    localXar.end(null, 0x4000000);
                    localXar.prepare(null);
                    _logger.log(Level.FINE, "Prepared DMD transaction");
                }
                Connection connection = this.jmsResource.getPool().getConnectionForDMD();
                msgProducer = this.createProducer(connection, this.dest);
                msgProducer.send(this.msg);
                _logger.log(Level.FINE, "Sent message to DMD");
                AbstractXAResourceType localXar2 = (AbstractXAResourceType)this.xar;
                localXar2.commit(null, false);
                _logger.log(Level.FINE, "Commited DMD transaction");
            } else {
                dmdSendSuccess = false;
            }
        }
        catch (Exception e) {
            dmdSendSuccess = false;
            dmdexception = e;
            e.printStackTrace();
        }
        finally {
            this.msg = null;
            this.dest = null;
            this.sentToDmd = false;
            if (msgProducer != null) {
                try {
                    msgProducer.close();
                }
                catch (Exception me) {
                    me.printStackTrace();
                }
            }
        }
        if (!dmdSendSuccess) {
            if (this.redeliveryRequired()) {
                _logger.log(Level.SEVERE, "FAILED : sending message to DMD");
            } else {
                _logger.log(Level.SEVERE, "FAILED : sending message to DMD");
                localXar = (AbstractXAResourceType)this.xar;
                localXar.setToRollback(true);
                try {
                    localXar.rollback(null);
                }
                catch (Exception e) {
                    _logger.log(Level.SEVERE, "FAILED : to rollback XA" + e.getMessage());
                }
            }
        }
    }

    public void deliver(Message message, Destination d) {
        this.msg = message;
        this.dest = d;
        this.deliver();
    }

    public void deliver() {
        int myattempts = 0;
        int attempts = this.spec.getRedeliveryAttempts();
        AbstractXAResourceType localXar = null;
        while (true) {
            try {
                this.deliverMessage(this.msg);
                if (!this.redeliveryRequired()) break;
                localXar = (AbstractXAResourceType)this.xar;
                localXar.startDelayedXA();
                localXar.setToRollback(true);
            }
            catch (Exception e) {
                if (this.redeliveryRequired()) {
                    localXar = (AbstractXAResourceType)this.xar;
                    localXar.setToRollback(false);
                    try {
                        _logger.log(Level.FINE, "Setting JMSRedelivered header on message");
                        this.msg.setJMSRedelivered(true);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else {
                    AbstractXAResourceType simpleXar = (AbstractXAResourceType)this.xar;
                    simpleXar.setToRollback(false);
                }
                if (this.transacted) {
                    if (myattempts < attempts) {
                        ++myattempts;
                        _logger.log(Level.FINEST, "Releasing the endpoint after an exception");
                        this.jmsResource.releaseEndpoint();
                        try {
                            Thread.sleep(this.spec.getRedeliveryInterval() * 1000);
                            _logger.log(Level.FINE, "getting the endpoint after an exception");
                            this.jmsResource.refresh();
                        }
                        catch (Exception ie) {
                            ie.printStackTrace();
                        }
                        continue;
                    }
                    this.markForDMD();
                    try {
                        this.msg.setJMSRedelivered(false);
                        _logger.log(Level.FINE, "Resetting JMS redelivered header");
                    }
                    catch (Exception jmse) {
                        _logger.log(Level.FINE, "Cannot reset JMS redelivered header");
                    }
                    if (this.redeliveryRequired()) {
                        localXar.startDelayedXA();
                    }
                    return;
                }
                return;
            }
            break;
        }
    }

    public void markForDMD() {
        this.sentToDmd = true;
    }

    public boolean markedForDMD() {
        return this.sentToDmd;
    }

    private void deliverMessage(Message message) throws ResourceException {
        block2: {
            MessageEndpoint endPoint = this.jmsResource.getEndpoint();
            try {
                _logger.log(Level.FINEST, "Now it is feeding the message to MDB instance");
                ((MessageListener)endPoint).onMessage(message);
            }
            catch (Exception e) {
                if (!this.transacted) break block2;
                throw ExceptionUtils.newResourceException(e);
            }
        }
    }
}

