/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.inbound.async;

import com.sun.genericra.inbound.AbstractJmsResource;
import com.sun.genericra.inbound.async.DeliveryHelper;
import com.sun.genericra.inbound.async.InboundJmsResourcePool;
import com.sun.genericra.inbound.async.MessageListener;
import com.sun.genericra.inbound.async.WorkImpl;
import com.sun.genericra.util.ExceptionUtils;
import com.sun.genericra.util.LogUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.Session;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;

public class InboundJmsResource
extends AbstractJmsResource
implements ServerSession {
    private static Logger _logger = LogUtils.getLogger();
    private DeliveryHelper helper;

    public InboundJmsResource(Session session, InboundJmsResourcePool pool) throws JMSException {
        super(session, pool, null);
    }

    public InboundJmsResource(Session session, InboundJmsResourcePool pool, XAResource xaresource) throws JMSException {
        super(session, pool, xaresource);
    }

    public void start() throws JMSException {
        try {
            _logger.log(Level.FINER, "Provider is starting the message consumtion");
            WorkImpl w = new WorkImpl(this);
            WorkManager wm = this.ra.getWorkManager();
            wm.scheduleWork((Work)w);
        }
        catch (WorkException e) {
            throw ExceptionUtils.newJMSException(e);
        }
    }

    public InboundJmsResource refreshListener() throws JMSException {
        MessageListener listener = new MessageListener(this, (InboundJmsResourcePool)this.pool);
        this.session.setMessageListener((javax.jms.MessageListener)listener);
        this.helper = new DeliveryHelper(this, (InboundJmsResourcePool)this.pool);
        return this;
    }

    public void destroy() {
        block3: {
            if (this.session != null) {
                try {
                    this.session.close();
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.FINE)) break block3;
                    _logger.log(Level.FINE, e.getMessage(), e);
                }
            }
        }
        this.releaseEndpoint();
    }

    public boolean isFree() {
        return this.free;
    }

    public InboundJmsResource markAsBusy() {
        this.free = false;
        return this;
    }

    public InboundJmsResource markAsFree() {
        this.free = true;
        return this;
    }

    public DeliveryHelper getDeliveryHelper() {
        return this.helper;
    }

    public Session getSession() {
        _logger.log(Level.FINEST, "Message provider got the session :" + this.session);
        return this.session;
    }

    public void release() {
        ((InboundJmsResourcePool)this.getPool()).put(this);
    }

    public void refresh() throws JMSException {
        MessageEndpointFactory mef = this.pool.getConsumer().getMessageEndpointFactory();
        try {
            _logger.log(Level.FINER, "Creating message endpoint : " + this.xaresource);
            this.endPoint = mef.createEndpoint(this.helper.getXAResource());
            this.endPoint.beforeDelivery(this.ra.getListeningMethod());
            _logger.log(Level.FINE, "Created endpoint : ");
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "Refresh resource failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEndpoint() {
        try {
            if (this.endPoint != null) {
                this.endPoint.afterDelivery();
            }
        }
        catch (Exception re) {
            _logger.log(Level.SEVERE, "After delivery failed " + re.getMessage(), re);
        }
        finally {
            if (this.endPoint != null) {
                try {
                    this.endPoint.release();
                    _logger.log(Level.FINE, "InboundJMSResource: released endpoint : ");
                }
                catch (Exception e) {
                    _logger.log(Level.SEVERE, "InboundJMSResource: release endpoint failed ");
                }
                this.endPoint = null;
            }
        }
    }
}

